/*
 * Decompiled with CFR 0.152.
 */
package spark;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.ExceptionHandler;
import spark.ExceptionHandlerImpl;
import spark.ExceptionMapper;
import spark.FilterImpl;
import spark.HaltException;
import spark.Request;
import spark.Response;
import spark.Routable;
import spark.RouteImpl;
import spark.SparkServer;
import spark.globalstate.ServletFlag;
import spark.route.RouteMatcherFactory;
import spark.route.SimpleRouteMatcher;
import spark.ssl.SslStores;
import spark.staticfiles.ServletStaticFiles;
import spark.webserver.SparkServerFactory;

final class SparkInstance
extends Routable {
    private static final Logger LOG = LoggerFactory.getLogger("spark.Spark");
    public static final int SPARK_DEFAULT_PORT = 4567;
    protected static final String DEFAULT_ACCEPT_TYPE = "*/*";
    protected boolean initialized = false;
    protected int port = 4567;
    protected String ipAddress = "0.0.0.0";
    protected SslStores sslStores;
    protected String staticFileFolder = null;
    protected String externalStaticFileFolder = null;
    protected Map<String, Class<?>> webSocketHandlers = null;
    protected int maxThreads = -1;
    protected int minThreads = -1;
    protected int threadIdleTimeoutMillis = -1;
    protected Optional<Integer> webSocketIdleTimeoutMillis = Optional.empty();
    protected SparkServer server;
    protected SimpleRouteMatcher routeMatcher;
    private boolean servletStaticLocationSet;
    private boolean servletExternalStaticLocationSet;
    private CountDownLatch latch = new CountDownLatch(1);

    SparkInstance() {
    }

    public synchronized void setIpAddress(String ipAddress) {
        if (this.initialized) {
            this.throwBeforeRouteMappingException();
        }
        this.ipAddress = ipAddress;
    }

    public synchronized void ipAddress(String ipAddress) {
        if (this.initialized) {
            this.throwBeforeRouteMappingException();
        }
        this.ipAddress = ipAddress;
    }

    public synchronized void setPort(int port) {
        if (this.initialized) {
            this.throwBeforeRouteMappingException();
        }
        this.port = port;
    }

    public synchronized void port(int port) {
        if (this.initialized) {
            this.throwBeforeRouteMappingException();
        }
        this.port = port;
    }

    public synchronized void setSecure(String keystoreFile, String keystorePassword, String truststoreFile, String truststorePassword) {
        this.secure(keystoreFile, keystorePassword, truststoreFile, truststorePassword);
    }

    public synchronized void secure(String keystoreFile, String keystorePassword, String truststoreFile, String truststorePassword) {
        if (this.initialized) {
            this.throwBeforeRouteMappingException();
        }
        if (keystoreFile == null) {
            throw new IllegalArgumentException("Must provide a keystore file to run secured");
        }
        this.sslStores = SslStores.create(keystoreFile, keystorePassword, truststoreFile, truststorePassword);
    }

    public synchronized void threadPool(int maxThreads) {
        this.threadPool(maxThreads, -1, -1);
    }

    public synchronized void threadPool(int maxThreads, int minThreads, int idleTimeoutMillis) {
        if (this.initialized) {
            this.throwBeforeRouteMappingException();
        }
        this.maxThreads = maxThreads;
        this.minThreads = minThreads;
        this.threadIdleTimeoutMillis = idleTimeoutMillis;
    }

    public synchronized void staticFileLocation(String folder) {
        if (this.initialized && !ServletFlag.isRunningFromServlet()) {
            this.throwBeforeRouteMappingException();
        }
        this.staticFileFolder = folder;
        if (!this.servletStaticLocationSet) {
            if (ServletFlag.isRunningFromServlet()) {
                ServletStaticFiles.configureStaticResources(this.staticFileFolder);
                this.servletStaticLocationSet = true;
            }
        } else {
            LOG.warn("Static file location has already been set");
        }
    }

    public synchronized void externalStaticFileLocation(String externalFolder) {
        if (this.initialized && !ServletFlag.isRunningFromServlet()) {
            this.throwBeforeRouteMappingException();
        }
        this.externalStaticFileFolder = externalFolder;
        if (!this.servletExternalStaticLocationSet) {
            if (ServletFlag.isRunningFromServlet()) {
                ServletStaticFiles.configureExternalStaticResources(this.externalStaticFileFolder);
                this.servletExternalStaticLocationSet = true;
            }
        } else {
            LOG.warn("External static file location has already been set");
        }
    }

    public synchronized void webSocket(String path, Class<?> handler) {
        Objects.requireNonNull(path, "WebSocket path cannot be null");
        Objects.requireNonNull(handler, "WebSocket handler class cannot be null");
        if (this.initialized) {
            this.throwBeforeRouteMappingException();
        }
        if (ServletFlag.isRunningFromServlet()) {
            throw new IllegalStateException("WebSockets are only supported in the embedded server");
        }
        if (this.webSocketHandlers == null) {
            this.webSocketHandlers = new HashMap();
        }
        this.webSocketHandlers.put(path, handler);
    }

    public synchronized void webSocketIdleTimeoutMillis(int timeoutMillis) {
        if (this.initialized) {
            this.throwBeforeRouteMappingException();
        }
        if (ServletFlag.isRunningFromServlet()) {
            throw new IllegalStateException("WebSockets are only supported in the embedded server");
        }
        this.webSocketIdleTimeoutMillis = Optional.of(timeoutMillis);
    }

    public void awaitInitialization() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted by another thread");
        }
    }

    private void throwBeforeRouteMappingException() {
        throw new IllegalStateException("This must be done before route mapping has begun");
    }

    private boolean hasMultipleHandlers() {
        return this.staticFileFolder != null || this.externalStaticFileFolder != null || this.webSocketHandlers != null;
    }

    public synchronized void stop() {
        if (this.server != null) {
            this.routeMatcher.clearRoutes();
            this.server.stop();
            this.latch = new CountDownLatch(1);
        }
        this.initialized = false;
    }

    @Override
    public void addRoute(String httpMethod, RouteImpl route) {
        this.init();
        this.routeMatcher.parseValidateAddRoute(httpMethod + " '" + route.getPath() + "'", route.getAcceptType(), route);
    }

    @Override
    public void addFilter(String httpMethod, FilterImpl filter) {
        this.init();
        this.routeMatcher.parseValidateAddRoute(httpMethod + " '" + filter.getPath() + "'", filter.getAcceptType(), filter);
    }

    public synchronized void init() {
        if (!this.initialized) {
            this.routeMatcher = RouteMatcherFactory.get();
            if (!ServletFlag.isRunningFromServlet()) {
                new Thread(() -> {
                    this.server = SparkServerFactory.create(this.hasMultipleHandlers());
                    this.server.ignite(this.ipAddress, this.port, this.sslStores, this.staticFileFolder, this.externalStaticFileFolder, this.latch, this.maxThreads, this.minThreads, this.threadIdleTimeoutMillis, this.webSocketHandlers, this.webSocketIdleTimeoutMillis);
                }).start();
            }
            this.initialized = true;
        }
    }

    public synchronized void exception(Class<? extends Exception> exceptionClass, final ExceptionHandler handler) {
        ExceptionHandlerImpl wrapper = new ExceptionHandlerImpl(exceptionClass){

            @Override
            public void handle(Exception exception, Request request, Response response) {
                handler.handle(exception, request, response);
            }
        };
        ExceptionMapper.getInstance().map(exceptionClass, wrapper);
    }

    public void halt() {
        throw new HaltException();
    }

    public void halt(int status) {
        throw new HaltException(status);
    }

    public void halt(String body) {
        throw new HaltException(body);
    }

    public void halt(int status, String body) {
        throw new HaltException(status, body);
    }
}

