/*
 * Decompiled with CFR 0.152.
 */
package spark.staticfiles;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import spark.resource.AbstractFileResolvingResource;

public class MimeType {
    static final String CONTENT_TYPE = "Content-Type";
    private static volatile boolean guessingOn = true;
    private static Map<String, String> mappings = new HashMap<String, String>(){
        {
            this.put("au", "audio/basic");
            this.put("avi", "video/msvideo,video/avi,video/x-msvideo");
            this.put("bmp", "image/bmp");
            this.put("bz2", "application/x-bzip2");
            this.put("css", "text/css");
            this.put("dtd", "application/xml-dtd");
            this.put("doc", "application/msword");
            this.put("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
            this.put("dotx", "application/vnd.openxmlformats-officedocument.wordprocessingml.template");
            this.put("eot", "application/vnd.ms-fontobject");
            this.put("es", "application/ecmascript");
            this.put("exe", "application/octet-stream");
            this.put("gif", "image/gif");
            this.put("gz", "application/x-gzip");
            this.put("hqx", "application/mac-binhex40");
            this.put("html", "text/html");
            this.put("jar", "application/java-archive");
            this.put("jpg", "image/jpeg");
            this.put("js", "application/javascript");
            this.put("midi", "audio/x-midi");
            this.put("mp3", "audio/mpeg");
            this.put("mpeg", "video/mpeg");
            this.put("ogg", "audio/vorbis,application/ogg");
            this.put("otf", "application/font-otf");
            this.put("pdf", "application/pdf");
            this.put("pl", "application/x-perl");
            this.put("png", "image/png");
            this.put("potx", "application/vnd.openxmlformats-officedocument.presentationml.template");
            this.put("ppsx", "application/vnd.openxmlformats-officedocument.presentationml.slideshow");
            this.put("ppt", "application/vnd.ms-powerpointtd");
            this.put("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
            this.put("ps", "application/postscript");
            this.put("qt", "video/quicktime");
            this.put("ra", "audio/x-pn-realaudio,audio/vnd.rn-realaudio");
            this.put("rar", "application/x-rar-compressed");
            this.put("ram", "audio/x-pn-realaudio,audio/vnd.rn-realaudio");
            this.put("rdf", "application/rdf,application/rdf+xml");
            this.put("rtf", "application/rtf");
            this.put("sgml", "text/sgml");
            this.put("sit", "application/x-stuffit");
            this.put("sldx", "application/vnd.openxmlformats-officedocument.presentationml.slide");
            this.put("svg", "image/svg+xml");
            this.put("swf", "application/x-shockwave-flash");
            this.put("tgz", "application/x-tar");
            this.put("tiff", "image/tiff");
            this.put("tsv", "text/tab-separated-values");
            this.put("ttf", "application/font-ttf");
            this.put("txt", "text/plain");
            this.put("wav", "audio/wav,audio/x-wav");
            this.put("woff", "application/font-woff");
            this.put("woff2", "application/font-woff2");
            this.put("xlam", "application/vnd.ms-excel.addin.macroEnabled.12");
            this.put("xls", "application/vnd.ms-excel");
            this.put("xlsb", "application/vnd.ms-excel.sheet.binary.macroEnabled.12");
            this.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            this.put("xltx", "application/vnd.openxmlformats-officedocument.spreadsheetml.template");
            this.put("xml", "application/xml");
            this.put("zip", "application/zip,application/x-compressed-zip");
        }
    };

    public static void register(String extension, String mimeType) {
        mappings.put(extension, mimeType);
    }

    public static void disableGuessing() {
        guessingOn = false;
    }

    public static String fromResource(AbstractFileResolvingResource resource) {
        String filename = Optional.ofNullable(resource.getFilename()).orElse("");
        return MimeType.getMimeType(filename);
    }

    protected static String getMimeType(String filename) {
        String fileExtension = filename.replaceAll("^.*\\.(.*)$", "$1");
        return mappings.getOrDefault(fileExtension, "application/octet-stream");
    }

    protected static String fromPathInfo(String pathInfo) {
        return MimeType.getMimeType(pathInfo);
    }

    protected static boolean shouldGuess() {
        return guessingOn;
    }
}

