/*
 * Decompiled with CFR 0.152.
 */
package spark.webserver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.Filter;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import spark.utils.IOUtils;
import spark.webserver.NotConsumedException;

public class JettyHandler
extends SessionHandler {
    private static final Logger LOG = Log.getLogger(JettyHandler.class);
    private Filter filter;

    public JettyHandler(Filter filter) {
        this.filter = filter;
    }

    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            this.filter.doFilter((ServletRequest)new HttpRequestWrapper(request), (ServletResponse)response, null);
            baseRequest.setHandled(true);
        }
        catch (NotConsumedException ignore) {
            baseRequest.setHandled(false);
        }
    }

    private static class HttpRequestWrapper
    extends HttpServletRequestWrapper {
        private byte[] cachedBytes;

        public HttpRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public ServletInputStream getInputStream() throws IOException {
            if (this.cachedBytes == null) {
                this.cacheInputStream();
            }
            return new CachedServletInputStream();
        }

        private void cacheInputStream() throws IOException {
            this.cachedBytes = IOUtils.toByteArray((InputStream)super.getInputStream());
        }

        private class CachedServletInputStream
        extends ServletInputStream {
            private ByteArrayInputStream byteArrayInputStream;

            public CachedServletInputStream() {
                this.byteArrayInputStream = new ByteArrayInputStream(HttpRequestWrapper.this.cachedBytes);
            }

            public int read() {
                return this.byteArrayInputStream.read();
            }

            public boolean isFinished() {
                return this.byteArrayInputStream.available() <= 0;
            }

            public boolean isReady() {
                return this.byteArrayInputStream.available() >= 0;
            }

            public void setReadListener(ReadListener readListener) {
            }
        }
    }
}

