/*
 * Decompiled with CFR 0.152.
 */
package spark.staticfiles;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.resource.AbstractResourceHandler;
import spark.resource.ClassPathResource;
import spark.resource.ClassPathResourceHandler;
import spark.resource.ExternalResource;
import spark.resource.ExternalResourceHandler;
import spark.utils.Assert;

public class ServletStaticFiles {
    private static final Logger LOG = LoggerFactory.getLogger(ServletStaticFiles.class);
    private static List<AbstractResourceHandler> staticResourceHandlers = null;
    private static boolean staticResourcesSet = false;
    private static boolean externalStaticResourcesSet = false;

    public static boolean isStaticResourcesSet() {
        return staticResourcesSet;
    }

    public static boolean isExternalStaticResourcesSet() {
        return externalStaticResourcesSet;
    }

    public static List<AbstractResourceHandler> staticResourceHandlers() {
        return staticResourceHandlers;
    }

    public static void configureStaticResources(String folder) {
        Assert.notNull(folder, "'folder' must not be null");
        if (!ServletStaticFiles.isStaticResourcesSet()) {
            try {
                ClassPathResource resource = new ClassPathResource(folder);
                if (!resource.getFile().isDirectory()) {
                    LOG.error("Static resource location must be a folder");
                    return;
                }
                if (staticResourceHandlers == null) {
                    staticResourceHandlers = new ArrayList<AbstractResourceHandler>();
                }
                staticResourceHandlers.add(new ClassPathResourceHandler(folder, "index.html"));
                LOG.info("StaticResourceHandler configured with folder = " + folder);
            }
            catch (IOException e) {
                LOG.error("Error when creating StaticResourceHandler", (Throwable)e);
            }
            staticResourcesSet = true;
        }
    }

    public static void configureExternalStaticResources(String folder) {
        Assert.notNull(folder, "'folder' must not be null");
        if (!ServletStaticFiles.isExternalStaticResourcesSet()) {
            try {
                ExternalResource resource = new ExternalResource(folder);
                if (!resource.getFile().isDirectory()) {
                    LOG.error("External Static resource location must be a folder");
                    return;
                }
                if (staticResourceHandlers == null) {
                    staticResourceHandlers = new ArrayList<AbstractResourceHandler>();
                }
                staticResourceHandlers.add(new ExternalResourceHandler(folder, "index.html"));
                LOG.info("External StaticResourceHandler configured with folder = " + folder);
            }
            catch (IOException e) {
                LOG.error("Error when creating external StaticResourceHandler", (Throwable)e);
            }
            externalStaticResourcesSet = true;
        }
    }
}

