/*
 * Decompiled with CFR 0.152.
 */
package com.soundcloud.android.crop;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.widget.ImageView;
import com.soundcloud.android.crop.RotateBitmap;

abstract class ImageViewTouchBase
extends ImageView {
    private static final float SCALE_RATE = 1.25f;
    protected Matrix baseMatrix = new Matrix();
    protected Matrix suppMatrix = new Matrix();
    private final Matrix displayMatrix = new Matrix();
    private final float[] matrixValues = new float[9];
    protected final RotateBitmap bitmapDisplayed = new RotateBitmap(null, 0);
    int thisWidth = -1;
    int thisHeight = -1;
    float maxZoom;
    private Runnable onLayoutRunnable;
    protected Handler handler = new Handler();
    private Recycler recycler;

    public ImageViewTouchBase(Context context) {
        super(context);
        this.init();
    }

    public ImageViewTouchBase(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ImageViewTouchBase(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public void setRecycler(Recycler recycler) {
        this.recycler = recycler;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.thisWidth = right - left;
        this.thisHeight = bottom - top;
        Runnable r = this.onLayoutRunnable;
        if (r != null) {
            this.onLayoutRunnable = null;
            r.run();
        }
        if (this.bitmapDisplayed.getBitmap() != null) {
            this.getProperBaseMatrix(this.bitmapDisplayed, this.baseMatrix, true);
            this.setImageMatrix(this.getImageViewMatrix());
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && event.getRepeatCount() == 0) {
            event.startTracking();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 4 && event.isTracking() && !event.isCanceled() && this.getScale() > 1.0f) {
            this.zoomTo(1.0f);
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.setImageBitmap(bitmap, 0);
    }

    private void setImageBitmap(Bitmap bitmap, int rotation) {
        super.setImageBitmap(bitmap);
        Drawable d = this.getDrawable();
        if (d != null) {
            d.setDither(true);
        }
        Bitmap old = this.bitmapDisplayed.getBitmap();
        this.bitmapDisplayed.setBitmap(bitmap);
        this.bitmapDisplayed.setRotation(rotation);
        if (old != null && old != bitmap && this.recycler != null) {
            this.recycler.recycle(old);
        }
    }

    public void clear() {
        this.setImageBitmapResetBase(null, true);
    }

    public void setImageBitmapResetBase(Bitmap bitmap, boolean resetSupp) {
        this.setImageRotateBitmapResetBase(new RotateBitmap(bitmap, 0), resetSupp);
    }

    public void setImageRotateBitmapResetBase(final RotateBitmap bitmap, final boolean resetSupp) {
        int viewWidth = this.getWidth();
        if (viewWidth <= 0) {
            this.onLayoutRunnable = new Runnable(){

                @Override
                public void run() {
                    ImageViewTouchBase.this.setImageRotateBitmapResetBase(bitmap, resetSupp);
                }
            };
            return;
        }
        if (bitmap.getBitmap() != null) {
            this.getProperBaseMatrix(bitmap, this.baseMatrix, true);
            this.setImageBitmap(bitmap.getBitmap(), bitmap.getRotation());
        } else {
            this.baseMatrix.reset();
            this.setImageBitmap(null);
        }
        if (resetSupp) {
            this.suppMatrix.reset();
        }
        this.setImageMatrix(this.getImageViewMatrix());
        this.maxZoom = this.calculateMaxZoom();
    }

    protected void center() {
        Bitmap bitmap = this.bitmapDisplayed.getBitmap();
        if (bitmap == null) {
            return;
        }
        Matrix m = this.getImageViewMatrix();
        RectF rect = new RectF(0.0f, 0.0f, (float)bitmap.getWidth(), (float)bitmap.getHeight());
        m.mapRect(rect);
        float height = rect.height();
        float width = rect.width();
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        deltaY = this.centerVertical(rect, height, deltaY);
        deltaX = this.centerHorizontal(rect, width, deltaX);
        this.postTranslate(deltaX, deltaY);
        this.setImageMatrix(this.getImageViewMatrix());
    }

    private float centerVertical(RectF rect, float height, float deltaY) {
        int viewHeight = this.getHeight();
        if (height < (float)viewHeight) {
            deltaY = ((float)viewHeight - height) / 2.0f - rect.top;
        } else if (rect.top > 0.0f) {
            deltaY = -rect.top;
        } else if (rect.bottom < (float)viewHeight) {
            deltaY = (float)this.getHeight() - rect.bottom;
        }
        return deltaY;
    }

    private float centerHorizontal(RectF rect, float width, float deltaX) {
        int viewWidth = this.getWidth();
        if (width < (float)viewWidth) {
            deltaX = ((float)viewWidth - width) / 2.0f - rect.left;
        } else if (rect.left > 0.0f) {
            deltaX = -rect.left;
        } else if (rect.right < (float)viewWidth) {
            deltaX = (float)viewWidth - rect.right;
        }
        return deltaX;
    }

    private void init() {
        this.setScaleType(ImageView.ScaleType.MATRIX);
    }

    protected float getValue(Matrix matrix, int whichValue) {
        matrix.getValues(this.matrixValues);
        return this.matrixValues[whichValue];
    }

    protected float getScale(Matrix matrix) {
        return this.getValue(matrix, 0);
    }

    protected float getScale() {
        return this.getScale(this.suppMatrix);
    }

    private void getProperBaseMatrix(RotateBitmap bitmap, Matrix matrix, boolean includeRotation) {
        float viewWidth = this.getWidth();
        float viewHeight = this.getHeight();
        float w = bitmap.getWidth();
        float h = bitmap.getHeight();
        matrix.reset();
        float widthScale = Math.min(viewWidth / w, 3.0f);
        float heightScale = Math.min(viewHeight / h, 3.0f);
        float scale = Math.min(widthScale, heightScale);
        if (includeRotation) {
            matrix.postConcat(bitmap.getRotateMatrix());
        }
        matrix.postScale(scale, scale);
        matrix.postTranslate((viewWidth - w * scale) / 2.0f, (viewHeight - h * scale) / 2.0f);
    }

    protected Matrix getImageViewMatrix() {
        this.displayMatrix.set(this.baseMatrix);
        this.displayMatrix.postConcat(this.suppMatrix);
        return this.displayMatrix;
    }

    public Matrix getUnrotatedMatrix() {
        Matrix unrotated = new Matrix();
        this.getProperBaseMatrix(this.bitmapDisplayed, unrotated, false);
        unrotated.postConcat(this.suppMatrix);
        return unrotated;
    }

    protected float calculateMaxZoom() {
        if (this.bitmapDisplayed.getBitmap() == null) {
            return 1.0f;
        }
        float fw = (float)this.bitmapDisplayed.getWidth() / (float)this.thisWidth;
        float fh = (float)this.bitmapDisplayed.getHeight() / (float)this.thisHeight;
        return Math.max(fw, fh) * 4.0f;
    }

    protected void zoomTo(float scale, float centerX, float centerY) {
        if (scale > this.maxZoom) {
            scale = this.maxZoom;
        }
        float oldScale = this.getScale();
        float deltaScale = scale / oldScale;
        this.suppMatrix.postScale(deltaScale, deltaScale, centerX, centerY);
        this.setImageMatrix(this.getImageViewMatrix());
        this.center();
    }

    protected void zoomTo(float scale, final float centerX, final float centerY, final float durationMs) {
        final float incrementPerMs = (scale - this.getScale()) / durationMs;
        final float oldScale = this.getScale();
        final long startTime = System.currentTimeMillis();
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                long now = System.currentTimeMillis();
                float currentMs = Math.min(durationMs, (float)(now - startTime));
                float target = oldScale + incrementPerMs * currentMs;
                ImageViewTouchBase.this.zoomTo(target, centerX, centerY);
                if (currentMs < durationMs) {
                    ImageViewTouchBase.this.handler.post((Runnable)this);
                }
            }
        });
    }

    protected void zoomTo(float scale) {
        float cx = (float)this.getWidth() / 2.0f;
        float cy = (float)this.getHeight() / 2.0f;
        this.zoomTo(scale, cx, cy);
    }

    protected void zoomIn() {
        this.zoomIn(1.25f);
    }

    protected void zoomOut() {
        this.zoomOut(1.25f);
    }

    protected void zoomIn(float rate) {
        if (this.getScale() >= this.maxZoom) {
            return;
        }
        if (this.bitmapDisplayed.getBitmap() == null) {
            return;
        }
        float cx = (float)this.getWidth() / 2.0f;
        float cy = (float)this.getHeight() / 2.0f;
        this.suppMatrix.postScale(rate, rate, cx, cy);
        this.setImageMatrix(this.getImageViewMatrix());
    }

    protected void zoomOut(float rate) {
        if (this.bitmapDisplayed.getBitmap() == null) {
            return;
        }
        float cx = (float)this.getWidth() / 2.0f;
        float cy = (float)this.getHeight() / 2.0f;
        Matrix tmp = new Matrix(this.suppMatrix);
        tmp.postScale(1.0f / rate, 1.0f / rate, cx, cy);
        if (this.getScale(tmp) < 1.0f) {
            this.suppMatrix.setScale(1.0f, 1.0f, cx, cy);
        } else {
            this.suppMatrix.postScale(1.0f / rate, 1.0f / rate, cx, cy);
        }
        this.setImageMatrix(this.getImageViewMatrix());
        this.center();
    }

    protected void postTranslate(float dx, float dy) {
        this.suppMatrix.postTranslate(dx, dy);
    }

    protected void panBy(float dx, float dy) {
        this.postTranslate(dx, dy);
        this.setImageMatrix(this.getImageViewMatrix());
    }

    public static interface Recycler {
        public void recycle(Bitmap var1);
    }
}

