/*
 * Decompiled with CFR 0.152.
 */
package com.soundcloud.android.crop;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.soundcloud.android.crop.CropImageActivity;
import com.soundcloud.android.crop.HighlightView;
import com.soundcloud.android.crop.ImageViewTouchBase;
import java.util.ArrayList;

public class CropImageView
extends ImageViewTouchBase {
    ArrayList<HighlightView> highlightViews = new ArrayList();
    HighlightView motionHighlightView;
    Context context;
    private float lastX;
    private float lastY;
    private int motionEdge;

    public CropImageView(Context context) {
        super(context);
    }

    public CropImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CropImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.bitmapDisplayed.getBitmap() != null) {
            for (HighlightView hv : this.highlightViews) {
                hv.matrix.set(this.getUnrotatedMatrix());
                hv.invalidate();
                if (!hv.hasFocus()) continue;
                this.centerBasedOnHighlightView(hv);
            }
        }
    }

    @Override
    protected void zoomTo(float scale, float centerX, float centerY) {
        super.zoomTo(scale, centerX, centerY);
        for (HighlightView hv : this.highlightViews) {
            hv.matrix.set(this.getUnrotatedMatrix());
            hv.invalidate();
        }
    }

    @Override
    protected void zoomIn() {
        super.zoomIn();
        for (HighlightView hv : this.highlightViews) {
            hv.matrix.set(this.getUnrotatedMatrix());
            hv.invalidate();
        }
    }

    @Override
    protected void zoomOut() {
        super.zoomOut();
        for (HighlightView hv : this.highlightViews) {
            hv.matrix.set(this.getUnrotatedMatrix());
            hv.invalidate();
        }
    }

    @Override
    protected void postTranslate(float deltaX, float deltaY) {
        super.postTranslate(deltaX, deltaY);
        for (HighlightView hv : this.highlightViews) {
            hv.matrix.postTranslate(deltaX, deltaY);
            hv.invalidate();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        CropImageActivity cropImageActivity = (CropImageActivity)this.context;
        if (cropImageActivity.isSaving()) {
            return false;
        }
        block0 : switch (event.getAction()) {
            case 0: {
                for (HighlightView hv : this.highlightViews) {
                    int edge = hv.getHit(event.getX(), event.getY());
                    if (edge == 1) continue;
                    this.motionEdge = edge;
                    this.motionHighlightView = hv;
                    this.lastX = event.getX();
                    this.lastY = event.getY();
                    this.motionHighlightView.setMode(edge == 32 ? HighlightView.ModifyMode.Move : HighlightView.ModifyMode.Grow);
                    break block0;
                }
                break;
            }
            case 1: {
                if (this.motionHighlightView != null) {
                    this.centerBasedOnHighlightView(this.motionHighlightView);
                    this.motionHighlightView.setMode(HighlightView.ModifyMode.None);
                }
                this.motionHighlightView = null;
                break;
            }
            case 2: {
                if (this.motionHighlightView == null) break;
                this.motionHighlightView.handleMotion(this.motionEdge, event.getX() - this.lastX, event.getY() - this.lastY);
                this.lastX = event.getX();
                this.lastY = event.getY();
                this.ensureVisible(this.motionHighlightView);
            }
        }
        switch (event.getAction()) {
            case 1: {
                this.center(true, true);
                break;
            }
            case 2: {
                if (this.getScale() != 1.0f) break;
                this.center(true, true);
            }
        }
        return true;
    }

    private void ensureVisible(HighlightView hv) {
        int panDeltaY;
        Rect r = hv.drawRect;
        int panDeltaX1 = Math.max(0, this.getLeft() - r.left);
        int panDeltaX2 = Math.min(0, this.getRight() - r.right);
        int panDeltaY1 = Math.max(0, this.getTop() - r.top);
        int panDeltaY2 = Math.min(0, this.getBottom() - r.bottom);
        int panDeltaX = panDeltaX1 != 0 ? panDeltaX1 : panDeltaX2;
        int n = panDeltaY = panDeltaY1 != 0 ? panDeltaY1 : panDeltaY2;
        if (panDeltaX != 0 || panDeltaY != 0) {
            this.panBy(panDeltaX, panDeltaY);
        }
    }

    private void centerBasedOnHighlightView(HighlightView hv) {
        Rect drawRect = hv.drawRect;
        float width = drawRect.width();
        float height = drawRect.height();
        float thisWidth = this.getWidth();
        float thisHeight = this.getHeight();
        float z1 = thisWidth / width * 0.6f;
        float z2 = thisHeight / height * 0.6f;
        float zoom = Math.min(z1, z2);
        zoom *= this.getScale();
        if ((double)(Math.abs((zoom = Math.max(1.0f, zoom)) - this.getScale()) / zoom) > 0.1) {
            float[] coordinates = new float[]{hv.cropRect.centerX(), hv.cropRect.centerY()};
            this.getUnrotatedMatrix().mapPoints(coordinates);
            this.zoomTo(zoom, coordinates[0], coordinates[1], 300.0f);
        }
        this.ensureVisible(hv);
    }

    protected void onDraw(@NonNull Canvas canvas) {
        super.onDraw(canvas);
        for (HighlightView mHighlightView : this.highlightViews) {
            mHighlightView.draw(canvas);
        }
    }

    public void add(HighlightView hv) {
        this.highlightViews.add(hv);
        this.invalidate();
    }
}

