/*
 * Decompiled with CFR 0.152.
 */
package com.soundcloud.android.crop;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.widget.Toast;
import com.soundcloud.android.crop.CropImageActivity;
import com.soundcloud.android.crop.R;

public class Crop {
    public static final int REQUEST_CROP = 6709;
    public static final int REQUEST_PICK = 9162;
    public static final int RESULT_ERROR = 404;
    private Intent cropIntent = new Intent();

    public Crop(Uri source) {
        this.cropIntent.setData(source);
    }

    public Crop output(Uri output) {
        this.cropIntent.putExtra("output", (Parcelable)output);
        return this;
    }

    public Crop withAspect(int x, int y) {
        this.cropIntent.putExtra("aspect_x", x);
        this.cropIntent.putExtra("aspect_y", y);
        return this;
    }

    public Crop asSquare() {
        this.cropIntent.putExtra("aspect_x", 1);
        this.cropIntent.putExtra("aspect_y", 1);
        return this;
    }

    public Crop withMaxSize(int width, int height) {
        this.cropIntent.putExtra("max_x", width);
        this.cropIntent.putExtra("max_y", height);
        return this;
    }

    public void start(Activity activity) {
        activity.startActivityForResult(this.getIntent((Context)activity), 6709);
    }

    @TargetApi(value=11)
    public void start(Context context, Fragment fragment) {
        fragment.startActivityForResult(this.getIntent(context), 6709);
    }

    Intent getIntent(Context context) {
        this.cropIntent.setClass(context, CropImageActivity.class);
        return this.cropIntent;
    }

    public static Uri getOutput(Intent result) {
        return (Uri)result.getParcelableExtra("output");
    }

    public static Throwable getError(Intent result) {
        return (Throwable)result.getSerializableExtra("error");
    }

    public static void pickImage(Activity activity) {
        Intent intent = new Intent("android.intent.action.GET_CONTENT").setType("image/*");
        try {
            activity.startActivityForResult(intent, 9162);
        }
        catch (ActivityNotFoundException e) {
            Toast.makeText((Context)activity, (int)R.string.crop__pick_error, (int)0).show();
        }
    }

    static interface Extra {
        public static final String ASPECT_X = "aspect_x";
        public static final String ASPECT_Y = "aspect_y";
        public static final String MAX_X = "max_x";
        public static final String MAX_Y = "max_y";
        public static final String ERROR = "error";
    }
}

