/*
 * Decompiled with CFR 0.152.
 */
package com.sonu.libraries.materialstepper;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.widget.Button;
import com.sonu.libraries.materialstepper.DataTransferCallbacks;
import com.sonu.libraries.materialstepper.MaterialStepper;
import com.sonu.libraries.materialstepper.NavigationCallbacks;
import com.sonu.libraries.materialstepper.R;
import com.sonu.libraries.materialstepper.StatusBarCallbacks;
import com.sonu.libraries.materialstepper.ViewPagerCallbacks;

public abstract class StepFragment
extends Fragment
implements NavigationCallbacks {
    public static final int SKIPPED = 2;
    public static final int INCOMPLETE = 0;
    public static final int COMPLETED = 1;
    private int stepIndex = -1;
    private int status = 0;
    private MaterialStepper parent;
    private Context mContext;
    private DataTransferCallbacks dataTransferCallbacks;
    private ViewPagerCallbacks viewPagerCallbacks;
    private StatusBarCallbacks statusBarCallbacks;

    public void onAttach(Context context) {
        super.onAttach(context);
        this.mContext = context;
    }

    public final MaterialStepper getParent() {
        return this.parent;
    }

    public final void setParent(MaterialStepper parent) {
        this.parent = parent;
        this.dataTransferCallbacks = parent;
        this.viewPagerCallbacks = parent;
        this.statusBarCallbacks = parent;
    }

    public final Context getContext() {
        return this.mContext;
    }

    public boolean canGoBack() {
        return true;
    }

    public boolean canSkip() {
        return true;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public final int getStepIndex() {
        return this.stepIndex;
    }

    protected final void setStepIndex(int stepIndex) {
        this.stepIndex = stepIndex;
    }

    protected final void sendData(Bundle bundle) {
        this.dataTransferCallbacks.sendData(bundle, this.stepIndex + 1);
    }

    protected final Bundle getData() {
        return this.dataTransferCallbacks.getData(this.stepIndex);
    }

    protected final void sendDataTo(Bundle bundle, int stepIndex) {
        this.dataTransferCallbacks.sendData(bundle, stepIndex);
    }

    protected final Bundle getDataOf(int stepIndex) {
        return this.dataTransferCallbacks.getData(stepIndex);
    }

    @Override
    public StepFragment onRightCLicked() {
        this.status = 1;
        this.viewPagerCallbacks.swipeToPage(this, this.stepIndex + 1);
        return this;
    }

    @Override
    public StepFragment onLeftClicked() {
        this.viewPagerCallbacks.swipeToPage(this, this.stepIndex - 1);
        return this;
    }

    @Override
    public StepFragment onSkipClicked() {
        this.status = 2;
        this.viewPagerCallbacks.swipeToPage(this, this.stepIndex + 1);
        return this;
    }

    @Override
    public void onBackPressed() {
        if (this.canGoBack()) {
            this.onLeftClicked();
        }
    }

    @Override
    public void initButtons(Button leftButton, Button rightButton, Button skipButton) {
        if (this.canSkip()) {
            skipButton.setVisibility(0);
        } else {
            skipButton.setVisibility(8);
        }
        if (this.stepIndex == 0 || !this.canGoBack()) {
            leftButton.setVisibility(8);
            rightButton.setTextColor(-16777216);
            rightButton.setText((CharSequence)"NEXT");
            rightButton.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.ic_navigate_next_black_24dp, 0);
        } else {
            if (leftButton.getVisibility() == 8) {
                leftButton.setVisibility(0);
            }
            leftButton.setTextColor(-16777216);
            leftButton.setText((CharSequence)"BACK");
            leftButton.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_navigate_before_black_24dp, 0, 0, 0);
            rightButton.setTextColor(-16777216);
            rightButton.setText((CharSequence)"NEXT");
            rightButton.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.ic_navigate_next_black_24dp, 0);
        }
    }

    public abstract String getStepTitle();
}

