/*
 * Decompiled with CFR 0.152.
 */
package com.somospnt.loaderlib.service;

import com.somospnt.loaderlib.exception.LoaderException;
import com.somospnt.loaderlib.factory.LineMapperFactory;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.file.LineMapper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class LoaderService<T> {
    private final JpaRepository<T, Long> jpaRepository;
    private final LineMapper<T> lineMapper;
    private static final Logger LOG = LoggerFactory.getLogger(LoaderService.class);
    private Runnable callbackBefore;
    @Value(value="${loader.charset.encoding:windows-1252}")
    private Charset charsetEncoding;

    public LoaderService(JpaRepository<T, Long> jpaRepository, Class<T> clase, String ... nombresCampos) {
        this.jpaRepository = jpaRepository;
        this.lineMapper = LineMapperFactory.crear(clase, nombresCampos);
    }

    public void setCallbackBefore(Runnable callbackBefore) {
        this.callbackBefore = callbackBefore;
    }

    @PreAuthorize(value="hasAuthority('EJECUTAR_LOADER')")
    public void cargar(InputStream inputStream) {
        LOG.info("*********** COMIENZO LOADER ******************");
        this.ejecutarCallbackBefore();
        this.cargarInputStream(inputStream);
        LOG.info("*********** FIN LOADER ***********************\n");
    }

    private void ejecutarCallbackBefore() {
        if (this.callbackBefore == null) {
            this.jpaRepository.deleteAllInBatch();
        } else {
            this.callbackBefore.run();
        }
    }

    private void cargarInputStream(InputStream inputStream) {
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(inputStream, this.charsetEncoding));
        reader.lines().forEach(linea -> this.cargarLinea((String)linea, reader.getLineNumber()));
        LOG.info(" Cantidad de lineas insertadas: {}", (Object)reader.getLineNumber());
    }

    private void cargarLinea(String linea, int numeroLinea) {
        try {
            this.jpaRepository.save(this.lineMapper.mapLine(linea, 0));
        }
        catch (Exception ex) {
            throw new LoaderException(ex, numeroLinea);
        }
    }
}

