/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.impl;

import com.solacesystems.jcsmp.Consumer;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPFactory;
import com.solacesystems.jcsmp.Queue;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.TopicEndpoint;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jms.SolCloseableIF;
import com.solacesystems.jms.SolConnectionIF;
import com.solacesystems.jms.SolDestination;
import com.solacesystems.jms.SolDestinationInfo;
import com.solacesystems.jms.impl.ConnectionProperties;
import com.solacesystems.jms.impl.ConsumerFactory;
import com.solacesystems.jms.impl.JCSMPConsumerFactory;
import com.solacesystems.jms.impl.SessionProperties;
import com.solacesystems.jms.impl.Validator;
import java.util.Collection;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TemporaryQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConnectionConsumerTransactionStrategy
implements SolCloseableIF {
    private static final Log log = LogFactory.getLog(ConnectionConsumerTransactionStrategy.class);
    Consumer mConsumer;
    SolDestinationInfo mDestInfo;
    ConsumerFactory mConsumerFactory;
    SessionProperties mSessionProps;
    SolConnectionIF mConnection;
    volatile TransactionState mTxState;

    public ConnectionConsumerTransactionStrategy(InitProperties iprop) {
        this.mDestInfo = iprop.mDestInfo;
        this.mConsumerFactory = iprop.mConsumerFactory;
        this.mSessionProps = iprop.mSessionProps;
        this.mConnection = iprop.mConnection;
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConnectionConsumerTransactionStrategy created");
        }
    }

    public void reset() {
    }

    public void onMessage(Collection<Message> msgs) throws JMSException {
    }

    public void onCommit(Collection<Message> msgs) throws JMSException {
    }

    public void onRollback(Collection<Message> msgs) throws JMSException {
    }

    public void afterDelivery() throws JMSException {
    }

    public boolean tryWaitForUnacked(int millis) throws InterruptedException {
        return true;
    }

    public void createConsumer() throws JMSException {
        this.createConsumerImpl(JCSMPConsumerFactory.connectionConsumer);
    }

    void createConsumerImpl(JCSMPConsumerFactory fac) throws JMSException {
        SolDestination soldest = (SolDestination)this.mDestInfo.destination;
        if (soldest.getJCSMPDestination() instanceof Queue) {
            this.mConsumer = this.createQueueConsumer(fac);
        } else if (soldest.getJCSMPDestination() instanceof Topic) {
            this.mConsumer = this.createTopicConsumer(fac);
        } else {
            throw new IllegalArgumentException("Expected Destination to be Queue or Topic");
        }
    }

    public Consumer getConsumer() {
        return this.mConsumer;
    }

    public void start() throws JMSException {
        if (this.mConsumer != null) {
            try {
                this.mConsumer.startSync();
            }
            catch (JCSMPException e) {
                JMSException jmsEx = Validator.createJMSException("soljms.operation.consumer.start", (Throwable)((Object)e));
                throw jmsEx;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConnectionConsumerTransactionStrategy started");
        }
    }

    public void stop() {
        if (this.mConsumer != null) {
            this.mConsumer.stopSync();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConnectionConsumerTransactionStrategy stopped");
        }
    }

    public void closeConsumer() {
        if (this.mConsumer != null) {
            this.mConsumer.closeSync();
        }
    }

    Consumer createQueueConsumer(JCSMPConsumerFactory consFac) throws JMSException {
        Consumer cons = null;
        Destination dest = this.mDestInfo.destination;
        Queue jcsmpQueue = (Queue)((SolDestination)dest).getJCSMPDestination();
        boolean nonDurable = dest instanceof TemporaryQueue;
        XMLMessageListener listener = null;
        try {
            cons = nonDurable ? this.mConsumerFactory.createNonDurableConsumer(jcsmpQueue, listener, consFac) : this.mConsumerFactory.createDurableConsumer(jcsmpQueue, listener, consFac);
        }
        catch (Exception e) {
            throw Validator.createJMSException("soljms.operation.consumer.create", e);
        }
        return cons;
    }

    Consumer createTopicConsumer(JCSMPConsumerFactory consFac) throws JMSException {
        Consumer cons = null;
        ConnectionProperties connProp = this.mConnection.getProperties();
        Destination dest = this.mDestInfo.destination;
        TopicEndpoint epoint = null;
        Topic topic = (Topic)((SolDestination)dest).getJCSMPDestination();
        XMLMessageListener listener = null;
        boolean nonDurable = this.mDestInfo.subscriptionName == null;
        try {
            if (nonDurable) {
                boolean direct = this.mSessionProps.getConnectionProperties().getPropertyBean().getDirectTransport();
                if (!direct) {
                    epoint = connProp.getJCSMPSession().createNonDurableTopicEndpoint();
                }
                cons = this.mConsumerFactory.createNonDurableConsumer(topic, listener, epoint, consFac);
            } else {
                epoint = JCSMPFactory.onlyInstance().createDurableTopicEndpoint(this.mDestInfo.subscriptionName);
                cons = this.mConsumerFactory.createDurableConsumer(topic, listener, epoint, consFac);
            }
        }
        catch (Exception e) {
            throw Validator.createJMSException("soljms.operation.consumer.create", e);
        }
        return cons;
    }

    public void processRollbackTaskOnPollerThread() throws JMSException {
    }

    public TransactionState getTxState() {
        return this.mTxState;
    }

    public void afterPollLoop() throws JMSException {
    }

    void checkClosed() throws JMSException {
        if (this.getTxState() == TransactionState.CLOSED) {
            throw new IllegalStateException("connection closed", "soljms.error.closed");
        }
    }

    @Override
    public void close() {
        this.closeConsumer();
        this.mTxState = TransactionState.CLOSED;
    }

    public static class InitProperties {
        SolDestinationInfo mDestInfo;
        ConsumerFactory mConsumerFactory;
        SessionProperties mSessionProps;
        SolConnectionIF mConnection;

        public InitProperties withDestinationInfo(SolDestinationInfo di) {
            this.mDestInfo = di;
            return this;
        }

        public InitProperties withConsumerFactory(ConsumerFactory cf) {
            this.mConsumerFactory = cf;
            return this;
        }

        public InitProperties withSessionProperties(SessionProperties sp) {
            this.mSessionProps = sp;
            return this;
        }

        public InitProperties withConnection(SolConnectionIF conn) {
            this.mConnection = conn;
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TransactionState {
        NONTRANSACTED,
        ACTIVE,
        COMMITTING,
        ROLLINGBACK,
        CLOSED;

    }
}

