/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.events;

import com.solacesystems.jms.events.SolConsumerEvent;
import com.solacesystems.jms.events.SolEvent;

public class ActiveFlowIndicationEvent
extends SolConsumerEvent
implements SolEvent {
    public static final int FLOW_INACTIVE = 0;
    public static final int FLOW_ACTIVE = 1;
    public static final int FLOW_STATE_MAX = 2;
    protected int mFlowState;

    public long getEventType() {
        return 1L;
    }

    public String toString() {
        switch (this.mFlowState) {
            case 0: {
                return "FLOW_INACTIVE";
            }
            case 1: {
                return "FLOW_ACTIVE";
            }
        }
        return "Invalid Flow indication event";
    }

    public ActiveFlowIndicationEvent() {
        super(SolConsumerEvent.EventType.ACTIVE_FLOW_INDICATION);
        this.mFlowState = 0;
    }

    public ActiveFlowIndicationEvent(int flowState) throws IllegalArgumentException {
        super(SolConsumerEvent.EventType.ACTIVE_FLOW_INDICATION);
        this.setFlowState(flowState);
    }

    public void setFlowState(int flowState) throws IllegalArgumentException {
        if (flowState < 0 || flowState >= 2) {
            throw new IllegalArgumentException();
        }
        this.mFlowState = flowState;
    }

    public int getFlowState() {
        return this.mFlowState;
    }
}

