/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.common.jndi.JNDIObject;
import com.solacesystems.common.jndi.JNDIUtil;
import com.solacesystems.common.jndi.PropertyNotFoundException;
import com.solacesystems.common.property.Property;
import com.solacesystems.common.property.PropertyConversionException;
import com.solacesystems.common.property.PropertySource;
import com.solacesystems.common.property.PropertyVetoException;
import com.solacesystems.jms.DefaultReferenceableDelegate;
import com.solacesystems.jms.SolConnection;
import com.solacesystems.jms.SolConnectionFactory;
import com.solacesystems.jms.SolJmsUtility;
import com.solacesystems.jms.SolQueueConnection;
import com.solacesystems.jms.SolTopicConnection;
import com.solacesystems.jms.impl.Validator;
import com.solacesystems.jms.property.JMSConnectionFactoryPropertyBean;
import com.solacesystems.jms.property.JMSProperties;
import com.solacesystems.jms.property.JMSProperty;
import com.solacesystems.jms.property.JMSPropertyBean;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.TopicConnection;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolConnectionFactoryImpl
implements SolConnectionFactory,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SolConnectionFactoryImpl.class);
    protected JMSProperties mProperties;
    protected JMSPropertyBean mBean;
    protected JMSConnectionFactoryPropertyBean mCFBean;
    private static final String MESSAGING_PROPERTY_LIST_NAME = "messaging-properties";
    private static final String XA_PROPERTY_NAME = "xa";

    public SolConnectionFactoryImpl() {
        try {
            this.mProperties = new JMSProperties((Hashtable)null);
            this.mProperties.initialize();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize Solace JMS Properties", e);
        }
        this.config();
    }

    public SolConnectionFactoryImpl(JMSProperties properties) {
        this.mProperties = (JMSProperties)properties.clone();
        this.config();
    }

    private void config() {
        this.mBean = new JMSPropertyBean(this.mProperties.getProperties().values());
        this.mCFBean = new JMSConnectionFactoryPropertyBean(this.mProperties.getProperties().values());
        this.updateCFProperty(JMSProperty.Host);
        this.updateCFProperty(JMSProperty.VPN);
        this.updateCFProperty(JMSProperty.Username);
        this.updateCFProperty(JMSProperty.Password);
        this.updateCFProperty(JMSProperty.SSLCipherSuites);
        this.updateCFProperty(JMSProperty.SSLExcludedProtocols);
        this.updateCFProperty(JMSProperty.SSLProtocol);
        this.updateCFProperty(JMSProperty.SSLTrustedCommonNameList);
        this.updateCFProperty(JMSProperty.SSLTrustStore);
        this.updateCFProperty(JMSProperty.SSLTrustStoreFormat);
        this.updateCFProperty(JMSProperty.SSLTrustStorePassword);
        this.updateCFProperty(JMSProperty.SSLValidateCertificate);
        this.updateCFProperty(JMSProperty.SSLValidateCertificateDate);
        this.updateCFProperty(JMSProperty.AuthenticationScheme);
        this.updateCFProperty(JMSProperty.KRBMutualAuthentication);
        this.updateCFProperty(JMSProperty.KRBServiceName);
        this.updateCFProperty(JMSProperty.SSLKeyStore);
        this.updateCFProperty(JMSProperty.SSLKeyStoreFormat);
        this.updateCFProperty(JMSProperty.SSLKeyStoreNormalizedFormat);
        this.updateCFProperty(JMSProperty.SSLKeyStorePassword);
        this.updateCFProperty(JMSProperty.SSLPrivateKeyAlias);
        this.updateCFProperty(JMSProperty.SSLConnectionDowngradeTo);
    }

    public JMSProperties getJMSProperties() {
        return this.mProperties;
    }

    public JMSPropertyBean getJMSPropertyBean() {
        return this.mBean;
    }

    public Connection createConnection() throws JMSException {
        Validator.checkClientId(this.mBean.getJNDIClientID(), this.mBean.getClientID());
        return new SolConnection(this.mProperties, false);
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        Validator.checkClientId(this.mBean.getJNDIClientID(), this.mBean.getClientID());
        return new SolConnection(this.mProperties, false, userName, password);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        Validator.checkClientId(this.mBean.getJNDIClientID(), this.mBean.getClientID());
        return new SolQueueConnection(this.mProperties, false);
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        Validator.checkClientId(this.mBean.getJNDIClientID(), this.mBean.getClientID());
        return new SolQueueConnection(this.mProperties, false, userName, password);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        Validator.checkClientId(this.mBean.getJNDIClientID(), this.mBean.getClientID());
        return new SolTopicConnection(this.mProperties, false);
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        Validator.checkClientId(this.mBean.getJNDIClientID(), this.mBean.getClientID());
        return new SolTopicConnection(this.mProperties, false, userName, password);
    }

    @Override
    public Object getProperty(String name) {
        return this.mCFBean.getValue(name);
    }

    @Override
    public Object getEffectiveProperty(String name) {
        return this.mBean.getValue(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        try {
            this.mCFBean.setValue(name, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.mCFBean.getPropertyMap().keySet();
    }

    @Override
    public String getAuthenticationScheme() {
        return this.mCFBean.getAuthenticationScheme();
    }

    @Override
    public void setAuthenticationScheme(String scheme) {
        try {
            this.mCFBean.setAuthenticationScheme(scheme);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getBrowserTimeoutInMS() {
        return this.mCFBean.getBrowserTimeoutInMS();
    }

    @Override
    public void setBrowserTimeoutInMS(Integer timeout) {
        try {
            this.mCFBean.setBrowserTimeoutInMS(timeout);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Boolean getCallbackOnIOThread() {
        return this.mCFBean.getCallbackOnIOThread();
    }

    @Override
    public void setCallbackOnIOThread(Boolean callbackOnIOThread) {
        try {
            this.mCFBean.setCallbackOnIOThread(callbackOnIOThread);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String getClientDescription() {
        return this.mCFBean.getClientDescription();
    }

    @Override
    public void setClientDescription(String clientDescription) {
        try {
            this.mCFBean.setClientDescription(clientDescription);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String getClientID() {
        return this.mCFBean.getClientID();
    }

    @Override
    public void setClientID(String clientID) {
        try {
            this.mCFBean.setClientID(clientID);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getCompressionLevel() {
        return this.mCFBean.getCompressionLevel();
    }

    @Override
    public void setCompressionLevel(Integer compressionLevel) {
        try {
            this.mCFBean.setCompressionLevel(compressionLevel);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getConnectRetries() {
        return this.mCFBean.getConnectRetries();
    }

    @Override
    public void setConnectRetries(Integer connectRetries) {
        try {
            this.mCFBean.setConnectRetries(connectRetries);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getConnectRetriesPerHost() {
        return this.mCFBean.getConnectRetriesPerHost();
    }

    @Override
    public void setConnectRetriesPerHost(Integer connectRetriesPerHost) {
        try {
            this.mCFBean.setConnectRetriesPerHost(connectRetriesPerHost);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getConnectTimeoutInMillis() {
        return this.mCFBean.getConnectTimeoutInMillis();
    }

    @Override
    public void setConnectTimeoutInMillis(Integer connectTimeoutInMillis) {
        try {
            this.mCFBean.setConnectTimeoutInMillis(connectTimeoutInMillis);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getDeliveryMode() {
        return this.mCFBean.getDeliveryMode();
    }

    @Override
    public void setDeliveryMode(Integer deliveryMode) {
        try {
            this.mCFBean.setDeliveryMode(deliveryMode);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Boolean getDeliverToOne() {
        return this.mCFBean.getDeliverToOne();
    }

    @Override
    public void setDeliverToOne(Boolean deliverToOne) {
        try {
            this.mCFBean.setDeliverToOne(deliverToOne);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Boolean getDeliverToOneOverride() {
        return this.mCFBean.getDeliverToOneOverride();
    }

    @Override
    public void setDeliverToOneOverride(Boolean deliverToOneOverride) {
        try {
            this.mCFBean.setDeliverToOneOverride(deliverToOneOverride);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Boolean getDirectOptimized() {
        return this.mCFBean.getDirectOptimized();
    }

    @Override
    public void setDirectOptimized(Boolean directOptimized) {
        try {
            this.mCFBean.setDirectOptimized(directOptimized);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Boolean getDirectTransport() {
        return this.mCFBean.getDirectTransport();
    }

    @Override
    public Boolean getJMSXUserIDEnabled() {
        return this.mCFBean.getJMSXUserIDEnabled();
    }

    @Override
    public Boolean getAllowDuplicateClientId() {
        return this.mCFBean.getAllowDuplicateClientId();
    }

    @Override
    public void setDirectTransport(Boolean directTransport) {
        try {
            this.mCFBean.setDirectTransport(directTransport);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Boolean getDmqEligible() {
        return this.mCFBean.getDmqEligible();
    }

    @Override
    public void setDmqEligible(Boolean dmqEligible) {
        try {
            this.mCFBean.setDmqEligible(dmqEligible);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Boolean getDynamicDurables() {
        return this.mCFBean.getDynamicDurables();
    }

    @Override
    public void setDynamicDurables(Boolean dynamicDurables) {
        try {
            this.mCFBean.setDynamicDurables(dynamicDurables);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Boolean getElidingEligible() {
        return this.mCFBean.getElidingEligible();
    }

    @Override
    public void setElidingEligible(Boolean elidingEligible) {
        try {
            this.mCFBean.setElidingEligible(elidingEligible);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Hashtable<?, ?> getEnvironment() {
        return this.mProperties.getEnvironment();
    }

    @Override
    public Boolean getGenerateSenderID() {
        return this.mCFBean.getGenerateSenderID();
    }

    @Override
    public void setGenerateSenderID(Boolean generateSenderId) {
        try {
            this.mCFBean.setGenerateSenderID(generateSenderId);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String getHost() {
        return this.mCFBean.getHost();
    }

    @Override
    public void setHost(String host) {
        try {
            this.mCFBean.setHost(host);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getKeepAliveCountMax() {
        return this.mCFBean.getKeepAliveCountMax();
    }

    @Override
    public void setKeepAliveCountMax(Integer keepAliveCountMax) {
        try {
            this.mCFBean.setKeepAliveCountMax(keepAliveCountMax);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getKeepAliveIntervalInMillis() {
        return this.mCFBean.getKeepAliveIntervalInMillis();
    }

    @Override
    public void setKeepAliveIntervalInMillis(Integer keepAliveIntervalInMillis) {
        try {
            this.mCFBean.setKeepAliveIntervalInMillis(keepAliveIntervalInMillis);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Boolean getKeepAlives() {
        return this.mCFBean.getKeepAlives();
    }

    @Override
    public void setKeepAlives(Boolean keepAlives) {
        try {
            this.mCFBean.setKeepAlives(keepAlives);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Boolean getKRBMutualAuthentication() {
        return this.mCFBean.getKRBMutualAuthentication();
    }

    @Override
    public void setKRBMutualAuthentication(Boolean mutualAuth) {
        try {
            this.mCFBean.setKRBMutualAuthentication(mutualAuth);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String getKRBServiceName() {
        return this.mCFBean.getKRBServiceName();
    }

    @Override
    public void setKRBServiceName(String serviceName) {
        try {
            this.mCFBean.setKRBServiceName(serviceName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Boolean getLargeMessaging() {
        return this.mCFBean.getLargeMessaging();
    }

    @Override
    public void setLargeMessaging(Boolean largeMessaging) {
        try {
            this.mCFBean.setLargeMessaging(largeMessaging);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getLargeMessagingSegmentSize() {
        return this.mCFBean.getLargeMessagingSegmentSize();
    }

    @Override
    public void setLargeMessagingSegmentSize(Integer segmentSize) {
        try {
            this.mCFBean.setLargeMessagingSegmentSize(segmentSize);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getLargeMessagingMaximumSize() {
        return this.mCFBean.getLargeMessagingMaximumSize();
    }

    @Override
    public void setLargeMessagingMaximumSize(Integer maxSize) {
        try {
            this.mCFBean.setLargeMessagingMaximumSize(maxSize);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getLargeMessagingConsumeTimeoutInMillis() {
        return this.mCFBean.getLargeMessagingConsumeTimeoutInMillis();
    }

    @Override
    public void setLargeMessagingConsumeTimeoutInMillis(Integer consumeTimeoutInMillis) {
        try {
            this.mCFBean.setLargeMessagingConsumeTimeoutInMillis(consumeTimeoutInMillis);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String getLargeMessagingIncompletePolicy() {
        return this.mCFBean.getLargeMessagingIncompletePolicy();
    }

    @Override
    public void setLargeMessagingIncompletePolicy(String incompletePolicy) {
        try {
            this.mCFBean.setLargeMessagingIncompletePolicy(incompletePolicy);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String getPassword() {
        return this.mCFBean.getPassword();
    }

    @Override
    public void setPassword(String password) {
        try {
            this.mCFBean.setPassword(password);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getPort() {
        return this.mCFBean.getPort();
    }

    @Override
    public void setPort(Integer port) {
        try {
            this.mCFBean.setPort(port);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getReadTimeoutInMillis() {
        return this.mCFBean.getReadTimeoutInMillis();
    }

    @Override
    public void setReadTimeoutInMillis(Integer readTimeoutInMillis) {
        try {
            this.mCFBean.setReadTimeoutInMillis(readTimeoutInMillis);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getReceiveAdAckThreshold() {
        return this.mCFBean.getReceiveADAckThreshold();
    }

    @Override
    public void setReceiveAdAckThreshold(Integer receiveAdAckThreshold) {
        try {
            this.mCFBean.setReceiveADAckThreshold(receiveAdAckThreshold);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getReceiveADAckTimerInMillis() {
        return this.mCFBean.getReceiveADAckTimerInMillis();
    }

    @Override
    public void setReceiveADAckTimerInMillis(Integer receiveADAckTimerInMillis) {
        try {
            this.mCFBean.setReceiveADAckTimerInMillis(receiveADAckTimerInMillis);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getReceiveADWindowSize() {
        return this.mCFBean.getReceiveADWindowSize();
    }

    @Override
    public void setReceiveADWindowSize(Integer receiveADWindowSize) {
        try {
            this.mCFBean.setReceiveADWindowSize(receiveADWindowSize);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getReceiveBufferSize() {
        return this.mCFBean.getReceiveBufferSize();
    }

    @Override
    public void setReceiveBufferSize(Integer receiveBufferSize) {
        try {
            this.mCFBean.setReceiveBufferSize(receiveBufferSize);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getReconnectRetries() {
        return this.mCFBean.getReconnectRetries();
    }

    @Override
    public void setReconnectRetries(Integer reconnectRetries) {
        try {
            this.mCFBean.setReconnectRetries(reconnectRetries);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getReconnectRetryWaitInMillis() {
        return this.mCFBean.getReconnectRetryWaitInMillis();
    }

    @Override
    public void setReconnectRetryWaitInMillis(Integer reconnectRetryWaitInMillis) {
        try {
            this.mCFBean.setReconnectRetryWaitInMillis(reconnectRetryWaitInMillis);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Boolean getRespectTTL() {
        return this.mCFBean.getRespectTTL();
    }

    @Override
    public void setRespectTTL(Boolean respectTTL) {
        try {
            this.mCFBean.setRespectTTL(respectTTL);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getSendADAckTimerInMillis() {
        return this.mCFBean.getSendADAckTimerInMillis();
    }

    @Override
    public void setSendADAckTimerInMillis(Integer sendADAckTimerInMillis) {
        try {
            this.mCFBean.setSendADAckTimerInMillis(sendADAckTimerInMillis);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getSendADMaxResends() {
        return this.mCFBean.getSendADMaxResends();
    }

    @Override
    @Deprecated
    public void setSendADMaxResends(Integer sendADMaxResends) {
        try {
            this.mCFBean.setSendADMaxResends(sendADMaxResends);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getSendADWindowSize() {
        return this.mCFBean.getSendADWindowSize();
    }

    @Override
    public void setSendADWindowSize(Integer sendADWindowSize) {
        try {
            this.mCFBean.setSendADWindowSize(sendADWindowSize);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getSendBufferSize() {
        return this.mCFBean.getSendBufferSize();
    }

    @Override
    public void setSendBufferSize(Integer sendBufferSize) {
        try {
            this.mCFBean.setSendBufferSize(sendBufferSize);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String getSSLExcludedProtocols() {
        return this.mCFBean.getSSLExcludedProtocols();
    }

    @Override
    public void setSSLExcludedProtocols(String protocols) {
        try {
            this.mCFBean.setSSLExcludedProtocols(protocols);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String getSSLConnectionDowngradeTo() {
        return this.mCFBean.getSSLConnectionDowngradeTo();
    }

    @Override
    public void setSSLConnectionDowngradeTo(String protocol) {
        try {
            this.mCFBean.setSSLConnectionDowngradeTo(protocol);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String getSSLProtocol() {
        return this.mCFBean.getSSLProtocol();
    }

    @Override
    public void setSSLProtocol(String protocol) {
        try {
            this.mCFBean.setSSLProtocol(protocol);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Boolean getSSLValidateCertificate() {
        return this.mCFBean.getSSLValidateCertificate();
    }

    @Override
    public void setSSLValidateCertificate(Boolean validate) {
        try {
            this.mCFBean.setSSLValidateCertificate(validate);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Boolean getSSLValidateCertificateDate() {
        return this.mCFBean.getSSLValidateCertificateDate();
    }

    @Override
    public void setSSLValidateCertificateDate(Boolean validateDate) {
        try {
            this.mCFBean.setSSLValidateCertificateDate(validateDate);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String getSSLCipherSuites() {
        return this.mCFBean.getSSLCipherSuites();
    }

    @Override
    public void setSSLCipherSuites(String cipherSuites) {
        try {
            this.mCFBean.setSSLCipherSuites(cipherSuites);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String getSSLTrustStore() {
        return this.mCFBean.getSSLTrustStore();
    }

    @Override
    public void setSSLTrustStore(String truststore) {
        try {
            this.mCFBean.setSSLTrustStore(truststore);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String getSSLTrustStorePassword() {
        return this.mCFBean.getSSLTrustStorePassword();
    }

    @Override
    public void setSSLTrustStorePassword(String password) {
        try {
            this.mCFBean.setSSLTrustStorePassword(password);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String getSSLTrustStoreFormat() {
        return this.mCFBean.getSSLTrustStoreFormat();
    }

    @Override
    public void setSSLTrustStoreFormat(String format) {
        try {
            this.mCFBean.setSSLTrustStoreFormat(format);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String getSSLKeyStore() {
        return this.mCFBean.getSSLKeyStore();
    }

    @Override
    public void setSSLKeyStore(String keystore) {
        try {
            this.mCFBean.setSSLKeyStore(keystore);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String getSSLKeyStorePassword() {
        return this.mCFBean.getSSLKeyStorePassword();
    }

    @Override
    public void setSSLKeyStorePassword(String password) {
        try {
            this.mCFBean.setSSLKeyStorePassword(password);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String getSSLKeyStoreFormat() {
        return this.mCFBean.getSSLKeyStoreFormat();
    }

    @Override
    public void setSSLKeyStoreFormat(String format) {
        try {
            this.mCFBean.setSSLKeyStoreFormat(format);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String getSSLKeyStoreNormalizedFormat() {
        return this.mCFBean.getSSLKeyStoreNormalizedFormat();
    }

    @Override
    public void setSSLKeyStoreNormalizedFormat(String format) {
        try {
            this.mCFBean.setSSLKeyStoreNormalizedFormat(format);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String getSSLPrivateKeyAlias() {
        return this.mCFBean.getSSLPrivateKeyAlias();
    }

    @Override
    public void setSSLPrivateKeyAlias(String alias) {
        try {
            this.mCFBean.setSSLPrivateKeyAlias(alias);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String getSSLPrivateKeyPassword() {
        return this.mCFBean.getSSLPrivateKeyPassword();
    }

    @Override
    public void setSSLPrivateKeyPassword(String password) {
        try {
            this.mCFBean.setSSLPrivateKeyPassword(password);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String getSSLTrustedCommonNameList() {
        return this.mCFBean.getSSLTrustedCommonNameList();
    }

    @Override
    public void setSSLTrustedCommonNameList(String commonNames) {
        try {
            this.mCFBean.setSSLTrustedCommonNameList(commonNames);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getSubscriberLocalPriority() {
        return this.mCFBean.getSubscriberLocalPriority();
    }

    @Override
    public void setSubscriberLocalPriority(Integer subscriberLocalPriority) {
        try {
            this.mCFBean.setSubscriberLocalPriority(subscriberLocalPriority);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getSubscriberNetworkPriority() {
        return this.mCFBean.getSubscriberNetworkPriority();
    }

    @Override
    public void setSubscriberNetworkPriority(Integer subscriberNetworkPriority) {
        try {
            this.mCFBean.setSubscriberNetworkPriority(subscriberNetworkPriority);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Boolean getTcpNoDelay() {
        return this.mCFBean.getTcpNoDelay();
    }

    @Override
    public void setTcpNoDelay(Boolean tcpNoDelay) {
        try {
            this.mCFBean.setTcpNoDelay(tcpNoDelay);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Boolean getUseDefaultContext() {
        return this.mCFBean.getUseDefaultContext();
    }

    @Override
    public void setUseDefaultContext(Boolean useDefaultContext) {
        try {
            this.mCFBean.setUseDefaultContext(useDefaultContext);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String getUsername() {
        return this.mCFBean.getUsername();
    }

    @Override
    public void setUsername(String username) {
        try {
            this.mCFBean.setUsername(username);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String getVPN() {
        return this.mCFBean.getVPN();
    }

    @Override
    public void setVPN(String vpn) {
        try {
            this.mCFBean.setVPN(vpn);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Boolean getXA() {
        return this.mCFBean.getXA();
    }

    public void setXA(Boolean xa) {
        try {
            this.mCFBean.setXA(xa);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Boolean getXmlPayload() {
        return this.mCFBean.getXmlPayload();
    }

    @Override
    public void setXmlPayload(Boolean xmlPayload) {
        try {
            this.mCFBean.setXmlPayload(xmlPayload);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String getUnknownPublisherFlowAction() {
        return this.mCFBean.getUnknownPublisherFlowAction();
    }

    @Override
    public void setUnknownPublisherFlowAction(String action) {
        try {
            this.mCFBean.setUnknownPublisherFlowAction(action);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public void fromJNDIProperties(JNDIObject obj) {
        String propertyList;
        block22: {
            String strProp;
            block21: {
                block20: {
                    block19: {
                        propertyList = "client-properties";
                        strProp = null;
                        try {
                            strProp = JNDIUtil.getProperty(obj, propertyList, "client-id");
                            if (strProp != null && strProp.length() > 0) {
                                this.mCFBean.setClientID(strProp);
                            }
                        }
                        catch (PropertyNotFoundException e) {
                        }
                        catch (Throwable t) {
                            if (!log.isErrorEnabled()) break block19;
                            log.error((Object)("Could not set property clientID from jndi propertyList=" + propertyList + ", property=client-id" + SolConnectionFactoryImpl.describeError(t)));
                        }
                    }
                    if (!this.setPropertyFromJNDI(obj, propertyList, "allow-duplicate-client-id", JMSProperty.AllowDuplicateClientId)) {
                        this.setProperty(JMSProperty.AllowDuplicateClientId, (Object)false);
                    }
                    strProp = null;
                    try {
                        strProp = JNDIUtil.getProperty(obj, propertyList, "client-description");
                        if (strProp != null && strProp.length() > 0) {
                            this.mCFBean.setClientDescription(strProp);
                        }
                    }
                    catch (PropertyNotFoundException e) {
                    }
                    catch (Throwable t) {
                        if (!log.isErrorEnabled()) break block20;
                        log.error((Object)("Could not set property clientDescription from jndi propertyList=" + propertyList + ", property=client-description" + SolConnectionFactoryImpl.describeError(t)));
                    }
                }
                propertyList = MESSAGING_PROPERTY_LIST_NAME;
                this.setPropertyFromJNDI(obj, propertyList, "default-delivery-mode", JMSProperty.DeliveryMode);
                this.setPropertyFromJNDI(obj, propertyList, "text-msg-xml-payload", JMSProperty.XmlPayload);
                this.setPropertyFromJNDI(obj, propertyList, "default-dmq-eligible", JMSProperty.DmqEligible);
                this.setPropertyFromJNDI(obj, propertyList, "default-eliding-eligible", JMSProperty.ElidingEligible);
                this.setPropertyFromJNDI(obj, propertyList, XA_PROPERTY_NAME, JMSProperty.XA);
                if (!this.setPropertyFromJNDI(obj, propertyList, "jmsx-user-id-enabled", JMSProperty.JMSXUserIDEnabled)) {
                    this.setProperty(JMSProperty.JMSXUserIDEnabled, (Object)false);
                }
                propertyList = "transport-properties";
                this.setPropertyFromJNDI(obj, propertyList, "connect-timeout", JMSProperty.ConnectTimeoutInMillis);
                this.setPropertyFromJNDI(obj, propertyList, "read-timeout", JMSProperty.ReadTimeoutInMillis);
                this.setPropertyFromJNDI(obj, propertyList, "connect-retries", JMSProperty.ConnectRetries);
                this.setPropertyFromJNDI(obj, propertyList, "connect-retries-per-host", JMSProperty.ConnectRetriesPerHost);
                this.setPropertyFromJNDI(obj, propertyList, "reconnect-retries", JMSProperty.ReconnectRetries);
                this.setPropertyFromJNDI(obj, propertyList, "reconnect-retry-wait", JMSProperty.ReconnectRetryWaitInMillis);
                this.setPropertyFromJNDI(obj, propertyList, "keep-alive-enabled", JMSProperty.KeepAlives);
                this.setPropertyFromJNDI(obj, propertyList, "keep-alive-interval", JMSProperty.KeepAliveIntervalInMillis);
                this.setPropertyFromJNDI(obj, propertyList, "keep-alive-count-max", JMSProperty.KeepAliveCountMax);
                this.setPropertyFromJNDI(obj, propertyList, "send-buffer", JMSProperty.SendBufferSize);
                this.setPropertyFromJNDI(obj, propertyList, "receive-buffer", JMSProperty.ReceiveBufferSize);
                this.setPropertyFromJNDI(obj, propertyList, "tcp-no-delay", JMSProperty.TcpNoDelay);
                if (!this.setPropertyFromJNDI(obj, propertyList, "reliable-transport", JMSProperty.DirectTransport) && !this.setPropertyFromJNDI(obj, propertyList, "direct-transport", JMSProperty.DirectTransport)) {
                    this.setProperty(JMSProperty.DirectTransport, (Object)false);
                }
                this.setPropertyFromJNDI(obj, propertyList, "msg-callback-on-io-thread", JMSProperty.CallbackOnIOThread);
                strProp = null;
                try {
                    strProp = JNDIUtil.getProperty(obj, propertyList, "compression-level");
                    this.setCompressionLevel(Integer.valueOf(strProp));
                }
                catch (PropertyNotFoundException e) {
                }
                catch (Throwable t) {
                    if (!log.isErrorEnabled()) break block21;
                    log.error((Object)("Could not set property " + (Object)((Object)JMSProperty.CompressionLevel) + " from jndi propertyList=" + propertyList + ", property=compression-level" + SolConnectionFactoryImpl.describeError(t)));
                }
            }
            strProp = null;
            try {
                strProp = JNDIUtil.getProperty(obj, propertyList, "port");
                this.setPort(Integer.valueOf(strProp));
            }
            catch (PropertyNotFoundException e) {
            }
            catch (Throwable t) {
                if (!log.isErrorEnabled()) break block22;
                log.error((Object)("Could not set property " + (Object)((Object)JMSProperty.Port) + " from jndi propertyList=" + propertyList + ", property=port " + SolConnectionFactoryImpl.describeError(t)));
            }
        }
        this.setPropertyFromJNDI(obj, propertyList, "optimize-direct", JMSProperty.DirectOptimized);
        propertyList = "ad-properties";
        this.setPropertyFromJNDI(obj, propertyList, "send-ad-window-size", JMSProperty.SendADWindowSize);
        this.setPropertyFromJNDI(obj, propertyList, "send-ack-timer", JMSProperty.SendADAckTimerInMillis);
        this.setPropertyFromJNDI(obj, propertyList, "send-max-resends", JMSProperty.SendADMaxResends);
        this.setPropertyFromJNDI(obj, propertyList, "receive-ad-window-size", JMSProperty.ReceiveADWindowSize);
        this.setPropertyFromJNDI(obj, propertyList, "receive-ack-timer", JMSProperty.ReceiveADAckTimerInMillis);
        this.setPropertyFromJNDI(obj, propertyList, "receive-ack-threshold", JMSProperty.ReceiveADAckThreshold);
        propertyList = "deliver-to-one-properties";
        this.setPropertyFromJNDI(obj, propertyList, "subscriber-local-priority", JMSProperty.SubscriberLocalPriority);
        this.setPropertyFromJNDI(obj, propertyList, "subscriber-network-priority", JMSProperty.SubscriberNetworkPriority);
        if (!this.setPropertyFromJNDI(obj, propertyList, "deliver-to-one", JMSProperty.DeliverToOne)) {
            this.setProperty(JMSProperty.DeliverToOne, (Object)false);
        }
        if (!this.setPropertyFromJNDI(obj, propertyList, "deliver-to-one-override", JMSProperty.DeliverToOneOverride)) {
            this.setProperty(JMSProperty.DeliverToOneOverride, (Object)false);
        }
        propertyList = "dynamic-endpoint-properties";
        this.setPropertyFromJNDI(obj, propertyList, "dynamic-durables", JMSProperty.DynamicDurables);
        this.setPropertyFromJNDI(obj, propertyList, "respect-ttl", JMSProperty.RespectTTL);
    }

    private static String describeError(Throwable t) {
        if (t == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" Error Stack Trace [");
        StringWriter errors = new StringWriter();
        t.printStackTrace(new PrintWriter(errors));
        sb.append(errors.toString());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Properties toProperties() {
        Properties properties = new Properties();
        for (String name : this.getPropertyNames()) {
            Object value = this.getProperty(name);
            if (value == null) continue;
            properties.setProperty(name, value.toString());
        }
        return properties;
    }

    @Override
    public void fromProperties(Properties properties) {
        for (String name : this.getPropertyNames()) {
            if (!properties.containsKey(name)) continue;
            String value = properties.getProperty(name);
            try {
                this.setProperty(name, (Object)value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error setting property: " + name + " to value: " + value, e);
            }
        }
    }

    @Override
    public Reference getReference() throws NamingException {
        if (SolJmsUtility.getReferenceableDelegate() == null) {
            return DefaultReferenceableDelegate.onlyInstance.getReference(this);
        }
        Reference ref = SolJmsUtility.getReferenceableDelegate().getReference(this);
        if (ref == null) {
            return DefaultReferenceableDelegate.onlyInstance.getReference(this);
        }
        return ref;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SolConnectionFactory) {
            SolConnectionFactory other = (SolConnectionFactory)obj;
            for (String name : this.getPropertyNames()) {
                Object value = this.getProperty(name);
                Object otherValue = other.getProperty(name);
                if (!(value == null ? otherValue != null : !value.equals(otherValue))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append(this.mCFBean);
        return bldr.toString();
    }

    @Override
    public String toEffectiveString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append(this.mBean);
        return bldr.toString();
    }

    public static boolean isXAEnabled(JNDIObject obj, JMSProperties properties) {
        block3: {
            String strProp = null;
            try {
                strProp = JNDIUtil.getProperty(obj, MESSAGING_PROPERTY_LIST_NAME, XA_PROPERTY_NAME);
                return Boolean.valueOf(strProp);
            }
            catch (PropertyNotFoundException e) {
            }
            catch (Throwable t) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)("Could not get property xa from jndi propertyList=messaging-properties" + SolConnectionFactoryImpl.describeError(t)));
            }
        }
        return (Boolean)properties.getProperties().get(JMSProperty.XA.toString()).getValue();
    }

    private boolean setPropertyFromJNDI(JNDIObject obj, String jndiPropertyList, String jndiProperty, JMSProperty property) {
        block3: {
            String strProp = null;
            try {
                strProp = JNDIUtil.getProperty(obj, jndiPropertyList, jndiProperty);
                this.mCFBean.setValue(property.toString(), strProp);
                return true;
            }
            catch (PropertyNotFoundException e) {
            }
            catch (Throwable t) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)("Could not set property " + (Object)((Object)property) + " from jndi propertyList=" + jndiPropertyList + ", property=" + jndiProperty + SolConnectionFactoryImpl.describeError(t)));
            }
        }
        return false;
    }

    private void setProperty(JMSProperty property, Object value) {
        try {
            this.mCFBean.setValue(property.toString(), value);
        }
        catch (PropertyConversionException e) {
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.toProperties());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.mProperties = new JMSProperties((Hashtable)null);
            this.mProperties.initialize();
            this.mBean = new JMSPropertyBean(this.mProperties.getProperties().values());
            this.mCFBean = new JMSConnectionFactoryPropertyBean(this.mProperties.getProperties().values());
            Properties properties = (Properties)in.readObject();
            this.fromProperties(properties);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw (IOException)new IOException("Error in serializable readObject()").initCause(e);
        }
    }

    private void updateCFProperty(JMSProperty property) {
        Property<?> prop = this.mProperties.getProperties().get(property.toString());
        PropertySource<?> propSrc = prop.getSource("Connection Factory");
        if (!propSrc.isSet() && prop.isSet()) {
            try {
                propSrc.setObjectValue(prop.getValue());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

