/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf.impl;

import com.solacesystems.common.util.BitTwiddleUtil;
import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.jcsmp.protocol.HeaderDescriptionBean;
import com.solacesystems.jcsmp.protocol.WireEncoder;
import com.solacesystems.jcsmp.protocol.smf.SMFPubMsgHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.impl.SMFHeaderFieldConstants;
import com.solacesystems.jcsmp.protocol.smf.impl.SMFNumericConstants;
import java.io.IOException;
import java.io.OutputStream;

public class SMFPubMsgHeaderEncoder
implements SMFHeaderFieldConstants,
SMFNumericConstants,
WireEncoder {
    private static long _smf2_word1 = 0L;
    private static long _smf2_word2 = 0L;
    private static long _smf3_word1 = 0L;
    private byte[] paramData = new byte[4096];

    public int encodeHeader(byte[] out, HeaderDescriptionBean headerBean, int smfVersion) {
        if (smfVersion != 3) {
            throw new IllegalArgumentException("Must be SMFv3");
        }
        return this.encSmfV3(out, 0, headerBean);
    }

    private void encSmfV2(OutputStream out, HeaderDescriptionBean headerBean) throws IOException {
        SMFPubMsgHeaderBean h = (SMFPubMsgHeaderBean)headerBean;
        long word1 = _smf2_word1;
        long word2 = _smf2_word2;
        int smfHeaderLenBytes = h.getSmfEncodedLength(2);
        word1 = BitTwiddleUtil.setBits(word1, h.getSmfProtocol(), 6, 16);
        word1 = BitTwiddleUtil.setBits(word1, h.getUserCosValue(), 4, 12);
        word1 = BitTwiddleUtil.setBits(word1, smfHeaderLenBytes / 4, 12, 0);
        word2 = BitTwiddleUtil.setBits(word2, h.getMsgLen() + smfHeaderLenBytes, 24, 0);
        int paramDataLen = smfHeaderLenBytes - 8;
        if (paramDataLen > this.paramData.length) {
            this.paramData = new byte[paramDataLen];
        }
        if (paramDataLen > 0) {
            int copiedlen;
            for (int i = copiedlen = h.getEncodedParams(this.paramData); i < paramDataLen; ++i) {
                this.paramData[i] = 0;
            }
        }
        out.write(NetworkByteOrderNumberUtil.intToFourByte(word1));
        out.write(NetworkByteOrderNumberUtil.intToFourByte(word2));
        if (paramDataLen > 0) {
            out.write(this.paramData, 0, paramDataLen);
        }
    }

    private int encSmfV3(byte[] out, int offset, HeaderDescriptionBean headerBean) {
        SMFPubMsgHeaderBean h = (SMFPubMsgHeaderBean)headerBean;
        long word1 = _smf3_word1;
        long word2 = 0L;
        long word3 = 0L;
        int smfHeaderLenBytes = h.getSmfEncodedLength(3);
        word1 = BitTwiddleUtil.setBits(word1, h.getElidingEligible(), 1, 30);
        word1 = BitTwiddleUtil.setBits(word1, h.getDto(), 1, 29);
        word1 = BitTwiddleUtil.setBits(word1, h.getAdf(), 1, 28);
        word1 = BitTwiddleUtil.setBits(word1, h.getDmqEligible(), 1, 27);
        word1 = BitTwiddleUtil.setBits(word1, h.getSmfProtocol(), 6, 16);
        word1 = BitTwiddleUtil.setBits(word1, h.getUserCosValue(), 4, 12);
        word2 = smfHeaderLenBytes;
        word3 = smfHeaderLenBytes + h.getMsgLen();
        int paramDataLen = smfHeaderLenBytes - 12;
        if (paramDataLen > this.paramData.length) {
            this.paramData = new byte[paramDataLen];
        }
        NetworkByteOrderNumberUtil.intToFourByte(word1, out, 0);
        NetworkByteOrderNumberUtil.intToFourByte(word2, out, 4);
        NetworkByteOrderNumberUtil.intToFourByte(word3, out, 8);
        if (paramDataLen > 0) {
            System.arraycopy(h.getParamContainer().getBuffer(), 0, out, 12, paramDataLen);
        }
        return paramDataLen + 12;
    }

    public void encodeHeader(OutputStream out, HeaderDescriptionBean headerBean) throws IOException {
        throw new AssertionError((Object)"No longer implemented");
    }

    static {
        _smf2_word1 = BitTwiddleUtil.setBits(_smf2_word1, 0L, 1, 31);
        _smf2_word1 = BitTwiddleUtil.setBits(_smf2_word1, 0L, 1, 30);
        _smf2_word1 = BitTwiddleUtil.setBits(_smf2_word1, 2L, 3, 24);
        _smf2_word1 = BitTwiddleUtil.setBits(_smf2_word1, 0L, 2, 22);
        _smf2_word1 = BitTwiddleUtil.setBits(_smf2_word1, 3L, 6, 16);
        _smf2_word1 = BitTwiddleUtil.setBits(_smf2_word1, 0L, 4, 12);
        _smf2_word2 = BitTwiddleUtil.setBits(_smf2_word2, 255L, 8, 24);
        _smf3_word1 = BitTwiddleUtil.setBits(_smf3_word1, 0L, 1, 31);
        _smf3_word1 = BitTwiddleUtil.setBits(_smf3_word1, 3L, 3, 24);
        _smf3_word1 = BitTwiddleUtil.setBits(_smf3_word1, 0L, 2, 22);
        _smf3_word1 = BitTwiddleUtil.setBits(_smf3_word1, 3L, 6, 16);
        _smf3_word1 = BitTwiddleUtil.setBits(_smf3_word1, 0L, 4, 12);
        _smf3_word1 = BitTwiddleUtil.setBits(_smf3_word1, 255L, 8, 0);
    }
}

