/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.jcsmp.JCSMPChannelProperties;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimeoutHandler;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimer;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimerQueue;
import com.solacesystems.jcsmp.protocol.impl.TcpChannel;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class RequestResponseTask
implements JCSMPTimeoutHandler {
    protected CountDownLatch responseLatch;
    protected JCSMPException opEx;
    protected JCSMPException retryableError;
    final JCSMPTimerQueue _timerQueue;
    JCSMPTimer _timeoutTimer;
    volatile boolean _startTimerFlag;
    long timeout;
    int submitCount;
    final int maxSubmitCount;
    final int resubmitDelay;
    private static final Log Trace = LogFactory.getLog(RequestResponseTask.class);

    public RequestResponseTask(JCSMPBasicSession session, JCSMPChannelProperties ch_props) {
        this.timeout = ch_props.getReadTimeoutInMillis();
        this.resubmitDelay = ch_props.getReconnectRetryWaitInMillis();
        this.maxSubmitCount = session.getJCSMPProperties().getIntegerProperty("max_ad_flowctrl_retries");
        this._timerQueue = session.getContext().getIOReactor();
        this.submitCount = 0;
        this.responseLatch = new CountDownLatch(1);
        this._startTimerFlag = false;
    }

    public abstract void cancel_cleanupTasks();

    public void cancel(JCSMPException e) {
        Trace.debug((Object)("RequestResponseTask:cancel() " + this.toString()));
        this.cancel_cleanupTasks();
        this.opEx = e;
        this._startTimerFlag = false;
        this.responseLatch.countDown();
    }

    protected void initTimerFlag() {
        this._startTimerFlag = true;
    }

    public synchronized void startTimer() {
        if (this.timeout > 0L && this._startTimerFlag) {
            Trace.debug((Object)String.format("RequestResponseTask (%s) startTimer ", this));
            this._timeoutTimer = this._timerQueue.schedule_relative(this.timeout, this);
        } else {
            Trace.info((Object)String.format("RequestResponseTask: skipped startTimer(), timeout:%s startTimerFlag:%s", this.timeout, this._startTimerFlag));
        }
    }

    public synchronized void cancelTimer() {
        this._startTimerFlag = false;
        Trace.debug((Object)String.format("RequestResponseTask (%s) cancelTimer ", this));
        if (this._timeoutTimer != null && this._timeoutTimer.isActive()) {
            this._timerQueue.cancelTimer(this._timeoutTimer);
        }
    }

    public Exception getOpEx() {
        return this.opEx;
    }

    public void setRetryableLastError(JCSMPException ex) {
        this.retryableError = ex;
    }

    public void resend(boolean allowOnStateSub, TcpChannel.WriteBlockPolicy wpolicy, boolean isReactorResend) {
        if (++this.submitCount > this.maxSubmitCount) {
            String msg = JCSMPRB.BUNDLE.getStringSafely("TcpSubscriberChannel.ExceededMaxAdctrlRetries");
            msg = msg + (this.retryableError == null ? "" : " [Caused by " + this.retryableError.getMessage() + "]");
            this.cancel(new JCSMPTransportException(msg, (Throwable)((Object)this.retryableError)));
        } else {
            Trace.debug((Object)("Resubmitting request task: " + this.toString()));
            this.resendImpl(allowOnStateSub, wpolicy, isReactorResend);
        }
    }

    public abstract void resendImpl(boolean var1, TcpChannel.WriteBlockPolicy var2, boolean var3);

    public void scheduleResubmit(JCSMPException retryableCause) {
        Trace.debug((Object)String.format("Scheduling request %s resubmit in %s ms.", this.toString(), this.resubmitDelay));
        this.cancelTimer();
        this.setRetryableLastError(retryableCause);
        this._timerQueue.schedule_relative(this.resubmitDelay, new TaskResubmit());
    }

    public class TaskResubmit
    implements JCSMPTimeoutHandler {
        public void handleTimeout() {
            Trace.debug((Object)"Timer expired: resending FlowTask");
            RequestResponseTask.this.resend(false, TcpChannel.WriteBlockPolicy.DROP_AND_THROW, true);
        }
    }
}

