/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.XMLMessageConsumer;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jcsmp.impl.DefaultFlowQueueHookImpl;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;
import com.solacesystems.jcsmp.impl.flow.LiveMessageController;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JCSMPXMLMessageConsumer
implements XMLMessageConsumer {
    private static final Log Trace = LogFactory.getLog(JCSMPXMLMessageConsumer.class);
    private FlowHandleImpl flowHandle;

    public JCSMPXMLMessageConsumer(FlowHandleImpl classicFlowHandle, JCSMPBasicSession session) {
        this.flowHandle = classicFlowHandle;
        this.flowHandle.setSubQueueHooks(new DefaultFlowQueueHookImpl(this.flowHandle));
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)"Created XMLMessageConsumer");
        }
    }

    public FlowHandleImpl getFlowHandle() {
        return this.flowHandle;
    }

    public LiveMessageController getLiveMessageController() {
        return this.flowHandle.getLiveMessageController();
    }

    public synchronized void start() throws JCSMPException {
        this.flowHandle.start();
    }

    public synchronized void startSync() throws JCSMPException {
        this.flowHandle.startSync();
    }

    public synchronized void stop() {
        this.flowHandle.stop();
    }

    public synchronized void stopSync() {
        this.flowHandle.stopSync();
    }

    public synchronized void close() {
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)"Consumer about to close");
        }
        this.flowHandle.close();
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)"Closed XMLMessageConsumer");
        }
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void closeSync() {
        this.flowHandle.closeSync();
    }

    public synchronized void closeSync(boolean linger) {
        this.flowHandle.closeSync(linger);
    }

    public XMLMessageListener getMessageListener() {
        return this.flowHandle.getMessageListener();
    }

    public void setMessageListener(XMLMessageListener listener) {
        this.flowHandle.setMessageListener(listener);
    }

    public BytesXMLMessage receive() throws JCSMPException {
        return this.flowHandle.receive();
    }

    public BytesXMLMessage receiveNoWait() throws JCSMPException {
        return this.flowHandle.receiveNoWait();
    }

    public BytesXMLMessage receive(int timeoutInMillis) throws JCSMPException {
        return this.flowHandle.receive(timeoutInMillis);
    }

    public boolean stopSyncStart() {
        return this.flowHandle.stopSyncStart();
    }

    public void stopSyncWait() {
        this.flowHandle.stopSyncWait();
    }
}

