/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.jcsmp.JCSMPChannelProperties;
import com.solacesystems.jcsmp.JCSMPProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JCSMPPropertiesTextMarshaling {
    private static final Log Trace = LogFactory.getLog(JCSMPPropertiesTextMarshaling.class);
    static ValueParser BOOLPARSER = new ValueParser(){

        public Object parse(String v) {
            return Boolean.parseBoolean(v);
        }
    };
    static ValueParser INTPARSER = new ValueParser(){

        public Object parse(String v) {
            return Integer.parseInt(v);
        }
    };
    static ValueParser STRINGPARSER = new ValueParser(){

        public Object parse(String v) {
            return v;
        }
    };
    static ValueParser MESSAGEACKMODEPARSER = new ValueParser(){

        public Object parse(String v) {
            if ("SUPPORTED_MESSAGE_ACK_AUTO".equalsIgnoreCase(v)) {
                return "auto_ack";
            }
            if ("auto_ack".equalsIgnoreCase(v)) {
                return "auto_ack";
            }
            if ("SUPPORTED_MESSAGE_ACK_CLIENT".equalsIgnoreCase(v)) {
                return "client_ack";
            }
            if ("client_ack".equalsIgnoreCase(v)) {
                return "client_ack";
            }
            if ("SUPPORTED_MESSAGE_ACK_CLIENT_WINDOWED".equalsIgnoreCase(v)) {
                return "client_ack_windowed";
            }
            if ("client_ack_windowed".equalsIgnoreCase(v)) {
                return "client_ack_windowed";
            }
            throw new IllegalArgumentException("Invalid message ack mode " + v);
        }
    };
    static ValueParser ACKEVENTMODEPARSER = new ValueParser(){

        public Object parse(String v) {
            if ("SUPPORTED_ACK_EVENT_MODE_PER_MSG".equalsIgnoreCase(v)) {
                return "SUPPORTED_ACK_EVENT_MODE_PER_MSG";
            }
            if ("SUPPORTED_ACK_EVENT_MODE_PER_MSG".equalsIgnoreCase(v)) {
                return "SUPPORTED_ACK_EVENT_MODE_PER_MSG";
            }
            if ("SUPPORTED_ACK_EVENT_MODE_WINDOWED".equalsIgnoreCase(v)) {
                return "SUPPORTED_ACK_EVENT_MODE_WINDOWED";
            }
            if ("SUPPORTED_ACK_EVENT_MODE_WINDOWED".equalsIgnoreCase(v)) {
                return "SUPPORTED_ACK_EVENT_MODE_WINDOWED";
            }
            throw new IllegalArgumentException("Invalid ack event mode " + v);
        }
    };
    static ValueParser CHANNELSTACKPARSER = new ValueParser(){

        public Object parse(String v) {
            if ("SUPPORTED_PROTOCOL_STACK_SMF_TCP".equalsIgnoreCase(v)) {
                return "csmp.smf.tcp";
            }
            if ("csmp.smf.tcp".equalsIgnoreCase(v)) {
                return "csmp.smf.tcp";
            }
            if ("SUPPORTED_PROTOCOL_STACK_SMFS_TCP".equalsIgnoreCase(v)) {
                return "csmp.smfs.tcp";
            }
            if ("csmp.smfs.tcp".equalsIgnoreCase(v)) {
                return "csmp.smfs.tcp";
            }
            throw new IllegalArgumentException("Invalid stack " + v);
        }
    };
    static ValueParser CONNECTIONTYPEPARSER = new ValueParser(){

        public Object parse(String v) {
            if ("CONNECTION_TYPE_BASIC".equalsIgnoreCase(v)) {
                return "CONNECTION_TYPE_BASIC";
            }
            if ("CONNECTION_TYPE_XA".equalsIgnoreCase(v)) {
                return "CONNECTION_TYPE_XA";
            }
            throw new IllegalArgumentException("Invalid connection type " + v);
        }
    };
    static final String pv_prefix_jcsmp = "jcsmp";
    static final Map<String, PropertySetter> pv_psetters = new HashMap<String, PropertySetter>();

    public static JCSMPProperties fromProperties(Properties p_in) {
        PropertyVisitor visitor = new PropertyVisitor();
        for (Object o_key : p_in.keySet()) {
            String key = (String)o_key;
            visitor.visit(key, p_in.getProperty(key));
        }
        return visitor.s_prop;
    }

    public static Properties toProperties(JCSMPProperties p_in) {
        PropertyToTextVisitor visitor = new PropertyToTextVisitor();
        for (PropertySetter ps : pv_psetters.values()) {
            visitor.visit(ps.key, p_in.getProperty(ps.propertyKey));
        }
        return visitor.p;
    }

    static {
        ArrayList<PropertySetter> L = new ArrayList<PropertySetter>();
        L.add(new BasicPropertySetter("session_name", "SESSION_NAME", STRINGPARSER));
        L.add(new BasicPropertySetter("localhost", "LOCALHOST", STRINGPARSER));
        L.add(new BasicPropertySetter("host", "HOST", STRINGPARSER));
        L.add(new BasicPropertySetter("username", "USERNAME", STRINGPARSER));
        L.add(new BasicPropertySetter("password", "PASSWORD", STRINGPARSER));
        L.add(new BasicPropertySetter("message_ack_mode", "MESSAGE_ACK_MODE", MESSAGEACKMODEPARSER));
        L.add(new BasicPropertySetter("application_description", "APPLICATION_DESCRIPTION", STRINGPARSER));
        L.add(new BasicPropertySetter("client_name", "CLIENT_NAME", STRINGPARSER));
        L.add(new BasicPropertySetter("generate_sender_id", "GENERATE_SENDER_ID", BOOLPARSER));
        L.add(new BasicPropertySetter("generate_send_timestamps", "GENERATE_SEND_TIMESTAMPS", BOOLPARSER));
        L.add(new BasicPropertySetter("generate_rcv_timestamps", "GENERATE_RCV_TIMESTAMPS", BOOLPARSER));
        L.add(new BasicPropertySetter("generate_sequence_numbers", "GENERATE_SEQUENCE_NUMBERS", BOOLPARSER));
        L.add(new BasicPropertySetter("vpn_name", "VPN_NAME", STRINGPARSER));
        L.add(new BasicPropertySetter("subscriber_local_priority", "SUBSCRIBER_LOCAL_PRIORITY", INTPARSER));
        L.add(new BasicPropertySetter("subscriber_network_priority", "SUBSCRIBER_NETWORK_PRIORITY", INTPARSER));
        L.add(new BasicPropertySetter("reapply_subscriptions", "REAPPLY_SUBSCRIPTIONS", BOOLPARSER));
        L.add(new BasicPropertySetter("pub_multi_thread", "PUB_MULTI_THREAD", BOOLPARSER));
        L.add(new BasicPropertySetter("pub_use_intermediate_direct_buf", "PUB_USE_INTERMEDIATE_DIRECT_BUF", BOOLPARSER));
        L.add(new BasicPropertySetter("MESSAGE_CALLBACK_ON_REACTOR", "MESSAGE_CALLBACK_ON_REACTOR", BOOLPARSER));
        L.add(new BasicPropertySetter("IGNORE_DUPLICATE_SUBSCRIPTION_ERROR", "IGNORE_DUPLICATE_SUBSCRIPTION_ERROR", BOOLPARSER));
        L.add(new BasicPropertySetter("IGNORE_SUBSCRIPTION_NOT_FOUND_ERROR", "IGNORE_SUBSCRIPTION_NOT_FOUND_ERROR", BOOLPARSER));
        L.add(new BasicPropertySetter("calculate_message_expiration", "CALCULATE_MESSAGE_EXPIRATION", BOOLPARSER));
        L.add(new BasicPropertySetter("NO_LOCAL", "NO_LOCAL", BOOLPARSER));
        L.add(new BasicPropertySetter("topic_dispatch", "TOPIC_DISPATCH", BOOLPARSER));
        L.add(new BasicPropertySetter("topic_dispatch_optimize_direct", "TOPIC_DISPATCH_OPTIMIZE_DIRECT", BOOLPARSER));
        L.add(new BasicPropertySetter("ad_pub_router_windowed_ack", "AD_PUB_ROUTER_WINDOWED_ACK", BOOLPARSER));
        L.add(new BasicPropertySetter("sub_ack_window_size", "SUB_ACK_WINDOW_SIZE", INTPARSER));
        L.add(new BasicPropertySetter("pub_ack_window_size", "PUB_ACK_WINDOW_SIZE", INTPARSER));
        L.add(new BasicPropertySetter("sub_ack_time", "SUB_ACK_TIME", INTPARSER));
        L.add(new BasicPropertySetter("pub_ack_time", "PUB_ACK_TIME", INTPARSER));
        L.add(new BasicPropertySetter("sub_ack_window_threshold", "SUB_ACK_WINDOW_THRESHOLD", INTPARSER));
        L.add(new BasicPropertySetter("max_resends", "MAX_RESENDS", INTPARSER));
        L.add(new BasicPropertySetter("ACK_EVENT_MODE", "ACK_EVENT_MODE", ACKEVENTMODEPARSER));
        L.add(new BasicPropertySetter("large_messaging", "LARGE_MESSAGING", BOOLPARSER));
        L.add(new BasicPropertySetter("large_message_segment_size", "LARGE_MESSAGING_SEGMENT_SIZE", INTPARSER));
        L.add(new BasicPropertySetter("large_message_consume_timeout", "LARGE_MESSAGING_CONSUME_TIMEOUT", INTPARSER));
        L.add(new BasicPropertySetter("large_message_max_size", "LARGE_MESSAGING_MAX_MSG_SIZE", INTPARSER));
        L.add(new BasicPropertySetter("SSL_PROTOCOL", "SSL_PROTOCOL", STRINGPARSER));
        L.add(new BasicPropertySetter("SSL_EXCLUDED_PROTOCOLS", "SSL_EXCLUDED_PROTOCOLS", STRINGPARSER));
        L.add(new BasicPropertySetter("SSL_VALIDATE_CERTIFICATE", "SSL_VALIDATE_CERTIFICATE", BOOLPARSER));
        L.add(new BasicPropertySetter("SSL_VALIDATE_CERTIFICATE_DATE", "SSL_VALIDATE_CERTIFICATE_DATE", BOOLPARSER));
        L.add(new BasicPropertySetter("SSL_CIPHER_SUITES", "SSL_CIPHER_SUITES", STRINGPARSER));
        L.add(new BasicPropertySetter("SSL_TRUST_STORE", "SSL_TRUST_STORE", STRINGPARSER));
        L.add(new BasicPropertySetter("SSL_TRUST_STORE_PASSWORD", "SSL_TRUST_STORE_PASSWORD", STRINGPARSER));
        L.add(new BasicPropertySetter("SSL_TRUST_STORE_FORMAT", "SSL_TRUST_STORE_FORMAT", STRINGPARSER));
        L.add(new BasicPropertySetter("SSL_TRUSTED_COMMON_NAME_LIST", "SSL_TRUSTED_COMMON_NAME_LIST", STRINGPARSER));
        L.add(new BasicPropertySetter("SSL_KEY_STORE", "SSL_KEY_STORE", STRINGPARSER));
        L.add(new BasicPropertySetter("SSL_KEY_STORE_PASSWORD", "SSL_KEY_STORE_PASSWORD", STRINGPARSER));
        L.add(new BasicPropertySetter("SSL_KEY_STORE_FORMAT", "SSL_KEY_STORE_FORMAT", STRINGPARSER));
        L.add(new BasicPropertySetter("SSL_KEY_STORE_NORMALIZED_FORMAT", "SSL_INTERNAL_KEY_STORE_FORMAT", STRINGPARSER));
        L.add(new BasicPropertySetter("SSL_PRIVATE_KEY_ALIAS", "SSL_PRIVATE_KEY_ALIAS", STRINGPARSER));
        L.add(new BasicPropertySetter("SSL_PRIVATE_KEY_PASSWORD", "SSL_PRIVATE_KEY_PASSWORD", STRINGPARSER));
        L.add(new BasicPropertySetter("SSL_CONNECTION_DOWNGRADE_TO", "SSL_CONNECTION_DOWNGRADE_TO", STRINGPARSER));
        L.add(new BasicPropertySetter("AUTHENTICATION_SCHEME", "AUTHENTICATION_SCHEME", STRINGPARSER));
        L.add(new BasicPropertySetter("KRB_MUTUAL_AUTHENTICATION", "KRB_MUTUAL_AUTHENTICATION", BOOLPARSER));
        L.add(new BasicPropertySetter("KRB_SERVICE_NAME", "KRB_SERVICE_NAME", STRINGPARSER));
        L.add(new ChannelPropertySetter("client_channel", "CLIENT_CHANNEL_PROPERTIES"));
        L.add(new BasicPropertySetter("connection_type", "CONNECTION_TYPE", CONNECTIONTYPEPARSER));
        L.add(new BasicPropertySetter("gd_reconnect_fail_action", "GD_RECONNECT_FAIL_ACTION", STRINGPARSER));
        for (PropertySetter ps : L) {
            pv_psetters.put(ps.key.toUpperCase(), ps);
        }
    }

    static class PropertyToTextVisitor {
        public Properties p = new Properties();

        public void visit(String k, Object v) {
            if (v == null || k == null) {
                return;
            }
            String keyname = k.toUpperCase();
            PropertySetter ps = pv_psetters.get(keyname);
            if (ps instanceof BasicPropertySetter) {
                String propkey = String.format("%s.%s", JCSMPPropertiesTextMarshaling.pv_prefix_jcsmp, keyname);
                this.p.setProperty(propkey, String.valueOf(v));
            } else if (ps instanceof ChannelPropertySetter) {
                String propkey = String.format("%s.%s.", JCSMPPropertiesTextMarshaling.pv_prefix_jcsmp, keyname);
                JCSMPChannelProperties cprop = (JCSMPChannelProperties)v;
                this.p.setProperty(propkey + "ConnectTimeoutInMillis", String.valueOf(cprop.getConnectTimeoutInMillis()));
                this.p.setProperty(propkey + "SmfPort", String.valueOf(cprop.getSmfPort()));
                this.p.setProperty(propkey + "KeepAliveIntervalInMillis", String.valueOf(cprop.getKeepAliveIntervalInMillis()));
                this.p.setProperty(propkey + "KeepAliveLimit", String.valueOf(cprop.getKeepAliveLimit()));
                this.p.setProperty(propkey + "ReadTimeoutInMillis", String.valueOf(cprop.getReadTimeoutInMillis()));
                this.p.setProperty(propkey + "ConnectRetries", String.valueOf(cprop.getConnectRetries()));
                this.p.setProperty(propkey + "ReconnectRetries", String.valueOf(cprop.getReconnectRetries()));
                this.p.setProperty(propkey + "ReconnectRetryWaitInMillis", String.valueOf(cprop.getReconnectRetryWaitInMillis()));
                this.p.setProperty(propkey + "Stack", String.valueOf(cprop.getStack()));
                this.p.setProperty(propkey + "TcpNoDelay", String.valueOf(cprop.isTcpNoDelay()));
                this.p.setProperty(propkey + "SendBuffer", String.valueOf(cprop.getSendBuffer()));
                this.p.setProperty(propkey + "ReceiveBuffer", String.valueOf(cprop.getReceiveBuffer()));
                this.p.setProperty(propkey + "CompressionLevel", String.valueOf(cprop.getCompressionLevel()));
                this.p.setProperty(propkey + "ConnectRetriesPerHost", String.valueOf(cprop.getConnectRetriesPerHost()));
            } else {
                Trace.info((Object)String.format("Skipping property key '%s', unknown", k));
            }
        }
    }

    static class PropertyVisitor {
        JCSMPProperties s_prop = new JCSMPProperties();

        public void visit(String k, String v) {
            if (k == null) {
                return;
            }
            String[] k_levels = k.split("\\.");
            if (!k_levels[0].equalsIgnoreCase(JCSMPPropertiesTextMarshaling.pv_prefix_jcsmp)) {
                Trace.info((Object)String.format("Skipping property key '%s', not in JCSMP namespace", k));
                return;
            }
            PropertySetter ps = pv_psetters.get(k_levels[1].toUpperCase());
            if (ps instanceof BasicPropertySetter) {
                BasicPropertySetter bps = (BasicPropertySetter)ps;
                bps.set(this.s_prop, v);
            } else if (ps instanceof ChannelPropertySetter) {
                if (k_levels[2] == null) {
                    throw new IllegalArgumentException(String.format("Missing level in property key '%s'", k));
                }
                ChannelPropertySetter cps = (ChannelPropertySetter)ps;
                JCSMPChannelProperties cprop = (JCSMPChannelProperties)this.s_prop.getProperty(cps.propertyKey);
                cps.set(cprop, k_levels[2], v);
            } else {
                Trace.info((Object)String.format("Skipping property key '%s', unknown", k));
                return;
            }
        }
    }

    static class ChannelPropertySetter
    extends PropertySetter {
        public ChannelPropertySetter(String cKey, String k) {
            super(cKey, k);
        }

        void set(JCSMPChannelProperties p, String key, String v) {
            if ("ConnectTimeoutInMillis".equalsIgnoreCase(key)) {
                p.setConnectTimeoutInMillis(Integer.parseInt(v));
            } else if ("SmfPort".equalsIgnoreCase(key)) {
                p.setSmfPort(Integer.parseInt(v));
            } else if ("KeepAliveIntervalInMillis".equalsIgnoreCase(key)) {
                p.setKeepAliveIntervalInMillis(Integer.parseInt(v));
            } else if ("KeepAliveLimit".equalsIgnoreCase(key)) {
                p.setKeepAliveLimit(Integer.parseInt(v));
            } else if ("SmfPort".equalsIgnoreCase(key)) {
                p.setSmfPort(Integer.parseInt(v));
            } else if ("ReadTimeoutInMillis".equalsIgnoreCase(key)) {
                p.setReadTimeoutInMillis(Integer.parseInt(v));
            } else if ("ConnectRetries".equalsIgnoreCase(key)) {
                p.setConnectRetries(Integer.parseInt(v));
            } else if ("ReconnectRetries".equalsIgnoreCase(key)) {
                p.setReconnectRetries(Integer.parseInt(v));
            } else if ("ReconnectRetryWaitInMillis".equalsIgnoreCase(key)) {
                p.setReconnectRetryWaitInMillis(Integer.parseInt(v));
            } else if ("Stack".equalsIgnoreCase(key)) {
                p.setStack((String)CHANNELSTACKPARSER.parse(v));
            } else if ("TcpNoDelay".equalsIgnoreCase(key)) {
                p.setTcpNoDelay(Boolean.parseBoolean(v));
            } else if ("SendBuffer".equalsIgnoreCase(key)) {
                p.setSendBuffer(Integer.parseInt(v));
            } else if ("ReceiveBuffer".equalsIgnoreCase(key)) {
                p.setReceiveBuffer(Integer.parseInt(v));
            } else if ("CompressionLevel".equalsIgnoreCase(key)) {
                p.setCompressionLevel(Integer.parseInt(v));
            } else if ("ConnectRetriesPerHost".equalsIgnoreCase(key)) {
                p.setConnectRetriesPerHost(Integer.parseInt(v));
            } else {
                Trace.info((Object)String.format("Invalid channel property '%s', skipping", key));
            }
        }
    }

    static class BasicPropertySetter
    extends PropertySetter {
        final ValueParser vparser;

        public BasicPropertySetter(String propKey, String k, ValueParser v) {
            super(propKey, k);
            this.vparser = v;
        }

        public void set(JCSMPProperties p, String value) {
            p.setProperty(this.propertyKey, this.vparser.parse(value));
        }
    }

    static abstract class PropertySetter {
        public final String key;
        public final String propertyKey;

        PropertySetter(String propKey, String k) {
            this.key = k;
            this.propertyKey = propKey;
        }
    }

    static abstract class ValueParser {
        ValueParser() {
        }

        public abstract Object parse(String var1);
    }
}

