/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp;

import com.solacesystems.jcsmp.JCSMPFactory;
import com.solacesystems.jcsmp.Topic;

public class CacheSessionProperties
implements Cloneable {
    public static final String CachePrefix = "#P2P/CACHEINST/";
    private String mCacheName;
    private int mMaxAge;
    private int mMaxMsgs;
    private int mTimeout;
    private Topic mCacheTopic;
    private boolean mDeliverEvtsThruBlockingRecv;

    public CacheSessionProperties(String cacheName) {
        this(cacheName, 1, 0, 10000);
    }

    public CacheSessionProperties(String cacheName, int maxMsgsPerTopic, int maxMsgAge, int timeout) {
        this(cacheName, maxMsgsPerTopic, maxMsgAge, timeout, false);
    }

    public CacheSessionProperties(String cacheName, int maxMsgsPerTopic, int maxMsgAge, int timeout, boolean deliverEvtsThruBlockingRecv) {
        this.setCacheName(cacheName);
        this.setMaxMsgs(maxMsgsPerTopic);
        this.setMaxAge(maxMsgAge);
        this.setTimeout(timeout);
        this.setDeliverEvtsThruBlockingRecv(deliverEvtsThruBlockingRecv);
    }

    public int getMaxAge() {
        return this.mMaxAge;
    }

    public void setMaxAge(int maxMsgAge) {
        if (maxMsgAge < 0) {
            throw new IllegalArgumentException("maximum message age cannot be less than 0");
        }
        this.mMaxAge = maxMsgAge;
    }

    public int getMaxMsgs() {
        return this.mMaxMsgs;
    }

    public void setMaxMsgs(int maxMsgsPerTopic) {
        if (maxMsgsPerTopic < 0) {
            throw new IllegalArgumentException("maximum messages per topic cannot be less than 0");
        }
        this.mMaxMsgs = maxMsgsPerTopic;
    }

    public String getCacheName() {
        return this.mCacheName;
    }

    public void setCacheName(String cacheName) {
        if (cacheName == null || cacheName.length() == 0) {
            throw new IllegalArgumentException("cacheName cannot be null or empty");
        }
        this.mCacheTopic = JCSMPFactory.onlyInstance().createTopic(CachePrefix + cacheName);
        this.mCacheName = cacheName;
    }

    public Topic getCacheTopic() {
        return this.mCacheTopic;
    }

    public int getTimeout() {
        return this.mTimeout;
    }

    public void setTimeout(int timeout) {
        if (timeout < 3000) {
            throw new IllegalArgumentException("timeout cannot be less than 3000ms");
        }
        this.mTimeout = timeout;
    }

    public boolean deliverEvtsThruBlockingRecv() {
        return this.mDeliverEvtsThruBlockingRecv;
    }

    public void setDeliverEvtsThruBlockingRecv(boolean deliverEvtsThruBlockingRecv) {
        this.mDeliverEvtsThruBlockingRecv = deliverEvtsThruBlockingRecv;
    }

    public Object clone() {
        return new CacheSessionProperties(this.mCacheName, this.mMaxMsgs, this.mMaxAge, this.mTimeout, this.mDeliverEvtsThruBlockingRecv);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CacheSessionProperties) {
            CacheSessionProperties other = (CacheSessionProperties)obj;
            return this.mCacheName.equals(other.mCacheName) && this.mMaxMsgs == other.mMaxMsgs && this.mMaxAge == other.mMaxAge && this.mTimeout == other.mTimeout && this.mDeliverEvtsThruBlockingRecv == other.mDeliverEvtsThruBlockingRecv;
        }
        return false;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder("cacheName=");
        bldr.append(this.mCacheName);
        bldr.append(", maxMsgsPerTopic=");
        bldr.append(this.mMaxMsgs);
        bldr.append(", maxMsgAge=");
        bldr.append(this.mMaxAge);
        bldr.append(", timeout=");
        bldr.append(this.mTimeout);
        bldr.append(", deliverEvtsThruBlockingRecv=");
        bldr.append(this.mDeliverEvtsThruBlockingRecv);
        return bldr.toString();
    }
}

