/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.RowColumnResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.http.HttpEntity;
import com.smartsheet.api.internal.http.HttpMethod;
import com.smartsheet.api.internal.http.HttpRequest;
import com.smartsheet.api.internal.http.HttpResponse;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.CellHistory;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PaginationParameters;
import com.smartsheet.api.models.enums.CellHistoryInclusion;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class RowColumnResourcesImpl
extends AbstractResources
implements RowColumnResources {
    private static final String SHEETS_PATH = "sheets/";
    private static final String ROWS_PATH = "/rows/";
    private static final String COLUMNS_PATH = "/columns/";
    private static final String CELL_IMAGES_PATH = "/cellimages";

    public RowColumnResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
    }

    @Override
    public PagedResult<CellHistory> getCellHistory(long sheetId, long rowId, long columnId, PaginationParameters parameters) throws SmartsheetException {
        return this.getCellHistory(sheetId, rowId, columnId, parameters, null, null);
    }

    @Override
    public PagedResult<CellHistory> getCellHistory(long sheetId, long rowId, long columnId, PaginationParameters pagination, EnumSet<CellHistoryInclusion> includes, Integer level) throws SmartsheetException {
        String path = SHEETS_PATH + sheetId + ROWS_PATH + rowId + COLUMNS_PATH + columnId + "/history";
        Map<Object, Object> parameters = new HashMap();
        if (pagination != null) {
            parameters = pagination.toHashMap();
        }
        if (level != null) {
            parameters.put("level", level);
        }
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.listResourcesWithWrapper(path, CellHistory.class);
    }

    @Override
    public void addImageToCell(long sheetId, long rowId, long columnId, String file, String contentType) throws FileNotFoundException, SmartsheetException {
        Util.throwIfNull(file);
        File f = new File(file);
        String path = SHEETS_PATH + sheetId + ROWS_PATH + rowId + COLUMNS_PATH + columnId + CELL_IMAGES_PATH;
        this.addImage(path, new FileInputStream(f), contentType, f.length(), false, null, file);
    }

    @Override
    public void addImageToCell(long sheetId, long rowId, long columnId, String file, String contentType, boolean overrideValidation, String altText) throws FileNotFoundException, SmartsheetException {
        Util.throwIfNull(file);
        File f = new File(file);
        String path = SHEETS_PATH + sheetId + ROWS_PATH + rowId + COLUMNS_PATH + columnId + CELL_IMAGES_PATH;
        this.addImage(path, new FileInputStream(f), contentType, f.length(), overrideValidation, altText, file);
    }

    @Override
    public void addImageToCell(long sheetId, long rowId, long columnId, File file, String contentType, boolean overrideValidation, String altText) throws FileNotFoundException, SmartsheetException {
        Util.throwIfNull(file);
        String path = SHEETS_PATH + sheetId + ROWS_PATH + rowId + COLUMNS_PATH + columnId + CELL_IMAGES_PATH;
        this.addImage(path, new FileInputStream(file), contentType, file.length(), overrideValidation, altText, file.getName());
    }

    @Override
    public void addImageToCell(long sheetId, long rowId, long columnId, InputStream inputStream, String contentType, long contentLength, boolean overrideValidation, String altText) throws SmartsheetException {
        Util.throwIfNull(inputStream);
        String path = SHEETS_PATH + sheetId + ROWS_PATH + rowId + COLUMNS_PATH + columnId + CELL_IMAGES_PATH;
        this.addImage(path, inputStream, contentType, contentLength, overrideValidation, altText, altText);
    }

    private void addImage(String path, InputStream inputStream, String contentType, long contentLength, boolean overrideValidation, String altText, String imageName) throws SmartsheetException {
        if (imageName == null) {
            inputStream.toString();
        }
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (altText != null) {
            parameters.put("altText", altText);
        }
        if (overrideValidation) {
            parameters.put("overrideValidation", "true");
        }
        path = (String)path + QueryUtil.generateUrl(null, parameters);
        HttpRequest request = this.createHttpRequest(this.smartsheet.getBaseURI().resolve((String)path), HttpMethod.POST);
        String contentDispositionValue = "attachment; filename=\"" + URLEncoder.encode(imageName, StandardCharsets.UTF_8) + "\"";
        request.getHeaders().put("Content-Disposition", contentDispositionValue);
        HttpEntity entity = new HttpEntity();
        entity.setContentType(contentType);
        entity.setContent(inputStream);
        entity.setContentLength(contentLength);
        request.setEntity(entity);
        HttpResponse response = this.smartsheet.getHttpClient().request(request);
        switch (response.getStatusCode()) {
            case 200: {
                break;
            }
            default: {
                this.handleError(response);
            }
        }
        this.smartsheet.getHttpClient().releaseConnection();
    }
}

