/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.smartsheet.api.internal.json.JSONSerializerException;
import com.smartsheet.api.models.BulkItemResult;
import com.smartsheet.api.models.CopyOrMoveRowResult;
import com.smartsheet.api.models.EventResult;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.Result;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public interface JsonSerializer {
    public <T> void serialize(T var1, OutputStream var2) throws JSONSerializerException;

    public <T> String serialize(T var1) throws JSONSerializerException;

    public <T> PagedResult<T> deserializeDataWrapper(Class<T> var1, InputStream var2) throws JSONSerializerException;

    public <T> T deserialize(Class<T> var1, InputStream var2) throws JsonParseException, JsonMappingException, IOException;

    public <T> List<T> deserializeList(Class<T> var1, InputStream var2) throws JSONSerializerException;

    public Map<String, Object> deserializeMap(InputStream var1) throws JSONSerializerException;

    public <T> Result<T> deserializeResult(Class<T> var1, InputStream var2) throws JSONSerializerException;

    public <T> Result<List<T>> deserializeListResult(Class<T> var1, InputStream var2) throws JSONSerializerException;

    public <T> BulkItemResult<T> deserializeBulkItemResult(Class<T> var1, InputStream var2) throws JSONSerializerException;

    public CopyOrMoveRowResult deserializeCopyOrMoveRow(InputStream var1) throws JSONSerializerException;

    public EventResult deserializeEventResult(InputStream var1) throws JSONSerializerException;
}

