/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.smartsheet.api.internal.json.CellSerializerModifier;
import com.smartsheet.api.internal.json.ErrorDeserializer;
import com.smartsheet.api.internal.json.FormatDeserializer;
import com.smartsheet.api.internal.json.HyperlinkSerializer;
import com.smartsheet.api.internal.json.JSONSerializerException;
import com.smartsheet.api.internal.json.JsonSerializer;
import com.smartsheet.api.internal.json.ObjectValueDeserializer;
import com.smartsheet.api.internal.json.PrimitiveObjectValueSerializer;
import com.smartsheet.api.internal.json.RecipientDeserializer;
import com.smartsheet.api.internal.json.WidgetContentDeserializer;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.BulkItemResult;
import com.smartsheet.api.models.CopyOrMoveRowResult;
import com.smartsheet.api.models.Error;
import com.smartsheet.api.models.EventResult;
import com.smartsheet.api.models.Hyperlink;
import com.smartsheet.api.models.IdentifiableModel;
import com.smartsheet.api.models.IdentifiableModelMixin;
import com.smartsheet.api.models.ListAssetSharesResponse;
import com.smartsheet.api.models.ObjectValue;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PrimitiveObjectValue;
import com.smartsheet.api.models.Recipient;
import com.smartsheet.api.models.Result;
import com.smartsheet.api.models.TokenPaginatedResult;
import com.smartsheet.api.models.WidgetContent;
import com.smartsheet.api.models.format.Format;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class JacksonJsonSerializer
implements JsonSerializer {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void setFailOnUnknownProperties(boolean value) {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, value);
    }

    @Override
    public <T> void serialize(T object, OutputStream outputStream) throws JSONSerializerException {
        Util.throwIfNull(object, (Object)outputStream);
        try {
            OBJECT_MAPPER.writeValue(outputStream, object);
        }
        catch (JsonGenerationException e) {
            throw new JSONSerializerException((Exception)((Object)e));
        }
        catch (JsonMappingException e) {
            throw new JSONSerializerException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new JSONSerializerException(e);
        }
    }

    @Override
    public <T> String serialize(T object) throws JSONSerializerException {
        String value;
        Util.throwIfNull(object);
        try {
            value = OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonGenerationException e) {
            throw new JSONSerializerException((Exception)((Object)e));
        }
        catch (JsonMappingException e) {
            throw new JSONSerializerException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new JSONSerializerException(e);
        }
        return value;
    }

    @Override
    public <T> T deserialize(Class<T> objectClass, InputStream inputStream) throws IOException {
        Util.throwIfNull(objectClass, (Object)inputStream);
        return (T)OBJECT_MAPPER.readValue(inputStream, objectClass);
    }

    @Override
    public <T> List<T> deserializeList(Class<T> objectClass, InputStream inputStream) throws JSONSerializerException {
        Util.throwIfNull(objectClass, (Object)inputStream);
        List list = null;
        try {
            list = (List)OBJECT_MAPPER.readValue(inputStream, (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, objectClass));
        }
        catch (JsonParseException e) {
            throw new JSONSerializerException((Exception)((Object)e));
        }
        catch (JsonMappingException e) {
            throw new JSONSerializerException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new JSONSerializerException(e);
        }
        return list;
    }

    @Override
    public <T> PagedResult<T> deserializeDataWrapper(Class<T> objectClass, InputStream inputStream) throws JSONSerializerException {
        Util.throwIfNull(objectClass, (Object)inputStream);
        PagedResult rw = null;
        try {
            rw = (PagedResult)OBJECT_MAPPER.readValue(inputStream, OBJECT_MAPPER.getTypeFactory().constructParametrizedType(PagedResult.class, PagedResult.class, new Class[]{objectClass}));
        }
        catch (JsonParseException e) {
            throw new JSONSerializerException((Exception)((Object)e));
        }
        catch (JsonMappingException e) {
            throw new JSONSerializerException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new JSONSerializerException(e);
        }
        return rw;
    }

    @Override
    public Map<String, Object> deserializeMap(InputStream inputStream) throws JSONSerializerException {
        Util.throwIfNull(inputStream);
        Map map = null;
        try {
            map = (Map)OBJECT_MAPPER.readValue(inputStream, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (JsonParseException e) {
            throw new JSONSerializerException((Exception)((Object)e));
        }
        catch (JsonMappingException e) {
            throw new JSONSerializerException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new JSONSerializerException(e);
        }
        return map;
    }

    @Override
    public <T> Result<T> deserializeResult(Class<T> objectClass, InputStream inputStream) throws JSONSerializerException {
        Util.throwIfNull(objectClass, (Object)inputStream);
        Result result = null;
        try {
            result = (Result)OBJECT_MAPPER.readValue(inputStream, OBJECT_MAPPER.getTypeFactory().constructParametrizedType(Result.class, Result.class, new Class[]{objectClass}));
        }
        catch (JsonParseException e) {
            throw new JSONSerializerException((Exception)((Object)e));
        }
        catch (JsonMappingException e) {
            throw new JSONSerializerException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new JSONSerializerException(e);
        }
        return result;
    }

    @Override
    public <T> Result<List<T>> deserializeListResult(Class<T> objectClass, InputStream inputStream) throws JSONSerializerException {
        Util.throwIfNull(objectClass, (Object)inputStream);
        Result result = null;
        try {
            result = (Result)OBJECT_MAPPER.readValue(inputStream, OBJECT_MAPPER.getTypeFactory().constructParametrizedType(Result.class, Result.class, new JavaType[]{OBJECT_MAPPER.getTypeFactory().constructParametrizedType(List.class, List.class, new Class[]{objectClass})}));
        }
        catch (JsonParseException e) {
            throw new JSONSerializerException((Exception)((Object)e));
        }
        catch (JsonMappingException e) {
            throw new JSONSerializerException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new JSONSerializerException(e);
        }
        return result;
    }

    @Override
    public <T> BulkItemResult<T> deserializeBulkItemResult(Class<T> objectClass, InputStream inputStream) throws JSONSerializerException {
        BulkItemResult result = null;
        try {
            result = (BulkItemResult)OBJECT_MAPPER.readValue(inputStream, OBJECT_MAPPER.getTypeFactory().constructParametrizedType(BulkItemResult.class, BulkItemResult.class, new Class[]{objectClass}));
        }
        catch (JsonParseException e) {
            throw new JSONSerializerException((Exception)((Object)e));
        }
        catch (JsonMappingException e) {
            throw new JSONSerializerException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new JSONSerializerException(e);
        }
        return result;
    }

    @Override
    public CopyOrMoveRowResult deserializeCopyOrMoveRow(InputStream inputStream) throws JSONSerializerException {
        Util.throwIfNull(inputStream);
        CopyOrMoveRowResult rw = null;
        try {
            rw = (CopyOrMoveRowResult)OBJECT_MAPPER.readValue(inputStream, CopyOrMoveRowResult.class);
        }
        catch (JsonParseException e) {
            throw new JSONSerializerException((Exception)((Object)e));
        }
        catch (JsonMappingException e) {
            throw new JSONSerializerException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new JSONSerializerException(e);
        }
        return rw;
    }

    @Override
    public EventResult deserializeEventResult(InputStream inputStream) throws JSONSerializerException {
        Util.throwIfNull(inputStream);
        EventResult rw = null;
        try {
            rw = (EventResult)OBJECT_MAPPER.readValue(inputStream, EventResult.class);
        }
        catch (JsonParseException e) {
            throw new JSONSerializerException((Exception)((Object)e));
        }
        catch (JsonMappingException e) {
            throw new JSONSerializerException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new JSONSerializerException(e);
        }
        return rw;
    }

    @Override
    public <T> TokenPaginatedResult<T> deserializeTokenPaginatedResult(JsonDeserializer<List<T>> deserializer, InputStream inputStream) throws JSONSerializerException {
        Util.throwIfNull(deserializer, (Object)inputStream);
        TokenPaginatedResult result = null;
        try {
            ObjectMapper tempMapper = OBJECT_MAPPER.copy();
            SimpleModule module = new SimpleModule("TokenPaginatedResultDeserializerModule", Version.unknownVersion());
            module.addDeserializer(List.class, deserializer);
            tempMapper.registerModule((Module)module);
            result = (TokenPaginatedResult)tempMapper.readValue(inputStream, tempMapper.getTypeFactory().constructParametricType(TokenPaginatedResult.class, new Class[]{Object.class}));
        }
        catch (IOException e) {
            throw new JSONSerializerException(e);
        }
        return result;
    }

    @Override
    public <T> TokenPaginatedResult<T> deserializeTokenPaginatedResult(Class<T> objectClass, InputStream inputStream) throws JSONSerializerException {
        Util.throwIfNull(inputStream);
        TokenPaginatedResult result = null;
        try {
            result = (TokenPaginatedResult)OBJECT_MAPPER.readValue(inputStream, OBJECT_MAPPER.getTypeFactory().constructParametricType(TokenPaginatedResult.class, new Class[]{objectClass}));
        }
        catch (IOException e) {
            throw new JSONSerializerException(e);
        }
        return result;
    }

    @Override
    public <T> ListAssetSharesResponse<T> listAssetSharesTokenPaginatedResult(Class<T> objectClass, InputStream inputStream) throws JSONSerializerException {
        Util.throwIfNull(inputStream);
        ListAssetSharesResponse result = null;
        try {
            result = (ListAssetSharesResponse)OBJECT_MAPPER.readValue(inputStream, OBJECT_MAPPER.getTypeFactory().constructParametricType(ListAssetSharesResponse.class, new Class[]{objectClass}));
        }
        catch (IOException e) {
            throw new JSONSerializerException(e);
        }
        return result;
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OBJECT_MAPPER.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        OBJECT_MAPPER.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        OBJECT_MAPPER.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        OBJECT_MAPPER.setDateFormat((DateFormat)df);
        SimpleModule module = new SimpleModule("FormatDeserializerModule", Version.unknownVersion());
        module.addDeserializer(Format.class, (JsonDeserializer)new FormatDeserializer());
        module.setMixInAnnotation(IdentifiableModel.class, IdentifiableModelMixin.class);
        OBJECT_MAPPER.registerModule((Module)module);
        module = new SimpleModule("ObjectValueDeserializerModule", Version.unknownVersion());
        module.addDeserializer(ObjectValue.class, (JsonDeserializer)new ObjectValueDeserializer());
        OBJECT_MAPPER.registerModule((Module)module);
        module = new SimpleModule("PrimitiveObjectValueSerializerModule", Version.unknownVersion());
        module.addSerializer(PrimitiveObjectValue.class, (com.fasterxml.jackson.databind.JsonSerializer)new PrimitiveObjectValueSerializer());
        OBJECT_MAPPER.registerModule((Module)module);
        module = new SimpleModule("RecipientDeserializerModule", Version.unknownVersion());
        module.addDeserializer(Recipient.class, (JsonDeserializer)new RecipientDeserializer());
        OBJECT_MAPPER.registerModule((Module)module);
        module = new SimpleModule("WidgetContentDeserializerModule", Version.unknownVersion());
        module.addDeserializer(WidgetContent.class, (JsonDeserializer)new WidgetContentDeserializer());
        OBJECT_MAPPER.registerModule((Module)module);
        module = new SimpleModule("HyperlinkSerializerModule", Version.unknownVersion());
        module.addSerializer(Hyperlink.class, (com.fasterxml.jackson.databind.JsonSerializer)new HyperlinkSerializer());
        OBJECT_MAPPER.registerModule((Module)module);
        module = new SimpleModule("CellSerializerModule", Version.unknownVersion());
        module.setSerializerModifier((BeanSerializerModifier)new CellSerializerModifier());
        OBJECT_MAPPER.registerModule((Module)module);
        module = new SimpleModule("ErrorDetailDeserializerModule", Version.unknownVersion());
        module.addDeserializer(Error.class, (JsonDeserializer)new ErrorDeserializer());
        OBJECT_MAPPER.registerModule((Module)module);
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
    }
}

