/*
 * Copyright (C) 2025 Smartsheet
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.smartsheet.api.models.format;

/**
 * An enumeration representing the state of the Thousands separator.
 */
public enum ThousandsSeparator {
    NONE(false),
    ON(true),
    ;
    private final boolean separated;

    ThousandsSeparator(boolean separated) {
        this.separated = separated;
    }

    /**
     * The default setting when the {@link Format} for {@link ThousandsSeparator} is null;
     */
    public static final ThousandsSeparator DEFAULT = NONE;

    /**
     * @return the separated
     */
    public boolean isSeparated() {
        return separated;
    }
}
