/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk.exceptions;

import com.smartling.api.sdk.file.response.Error;
import com.smartling.api.sdk.util.HttpUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;

public class SmartlingApiException
extends Exception {
    private static final long serialVersionUID = -397098626101615761L;
    private final List<Error> originalErrors;
    private final String requestId;
    private final int statusCode;
    private final Map<String, String> responseHeaders;

    public SmartlingApiException(String message, Throwable cause, List<Error> originalErrors) {
        super(message, cause);
        this.originalErrors = originalErrors;
        this.requestId = HttpUtils.getRequestId().get() == null ? "N/A" : HttpUtils.getRequestId().get();
        HttpUtils.ResponseDetails responseDetails = HttpUtils.getResponseDetails().get();
        if (responseDetails != null) {
            this.statusCode = responseDetails.getStatusCode();
            this.responseHeaders = Collections.unmodifiableMap(this.convertHeadersToMap(responseDetails));
        } else {
            this.statusCode = 0;
            this.responseHeaders = Collections.emptyMap();
        }
    }

    private Map<String, String> convertHeadersToMap(HttpUtils.ResponseDetails responseDetails) {
        Header[] headers = responseDetails.getHeaders();
        HashMap<String, String> headersMap = new HashMap<String, String>(headers.length);
        for (Header header : headers) {
            headersMap.put(header.getName(), header.getValue());
        }
        return headersMap;
    }

    public SmartlingApiException(String message, List<Error> originalErrors) {
        this(message, null, originalErrors);
    }

    public SmartlingApiException(String message, Throwable cause) {
        this(message, cause, Collections.emptyList());
    }

    public SmartlingApiException(Exception e) {
        this("", e, Collections.emptyList());
    }

    public SmartlingApiException(String message) {
        this(message, null, Collections.emptyList());
    }

    public List<Error> getOriginalErrors() {
        return this.originalErrors;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }
}

