/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk;

import com.google.gson.reflect.TypeToken;
import com.smartling.api.sdk.BaseApiClientAdapter;
import com.smartling.api.sdk.FileApiClientAdapter;
import com.smartling.api.sdk.ProxyConfiguration;
import com.smartling.api.sdk.dto.ApiResponse;
import com.smartling.api.sdk.dto.ApiResponseWrapper;
import com.smartling.api.sdk.dto.Data;
import com.smartling.api.sdk.dto.EmptyResponse;
import com.smartling.api.sdk.dto.file.FileLastModified;
import com.smartling.api.sdk.dto.file.FileList;
import com.smartling.api.sdk.dto.file.FileStatus;
import com.smartling.api.sdk.dto.file.StringResponse;
import com.smartling.api.sdk.dto.file.UploadFileData;
import com.smartling.api.sdk.exceptions.ApiException;
import com.smartling.api.sdk.exceptions.AuthenticationException;
import com.smartling.api.sdk.exceptions.AuthorizationException;
import com.smartling.api.sdk.exceptions.MaintenanceModeException;
import com.smartling.api.sdk.exceptions.OperationsLimitExceeded;
import com.smartling.api.sdk.exceptions.ResourceLockedException;
import com.smartling.api.sdk.exceptions.UnexpectedException;
import com.smartling.api.sdk.exceptions.ValidationException;
import com.smartling.api.sdk.file.FileListSearchParams;
import com.smartling.api.sdk.file.FileType;
import com.smartling.api.sdk.file.RetrievalType;
import com.smartling.api.sdk.file.parameters.FileUploadParameterBuilder;
import com.smartling.api.sdk.file.parameters.GetFileParameterBuilder;
import com.smartling.api.sdk.util.DateFormatter;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.message.BasicNameValuePair;

public class FileApiClientAdapterImpl
extends BaseApiClientAdapter
implements FileApiClientAdapter {
    private static final Log logger = LogFactory.getLog(FileApiClientAdapterImpl.class);
    private static final String UPLOAD_FILE_API_URL = "%s/file/upload?";
    private static final String GET_FILE_API_URL = "%s/file/get?";
    private static final String GET_FILE_LIST_API_URL = "%s/file/list?";
    private static final String GET_FILE_STATUS_API_URL = "%s/file/status?";
    private static final String GET_FILE_LAST_MODIFIED = "%s/file/last_modified?";
    private static final String RENAME_FILE_URL = "%s/file/rename?";
    private static final String DELETE_FILE_URL = "%s/file/delete?";

    public FileApiClientAdapterImpl(String apiKey, String projectId) {
        super(apiKey, projectId);
    }

    public FileApiClientAdapterImpl(String apiKey, String projectId, ProxyConfiguration proxyConfiguration) {
        super(apiKey, projectId, proxyConfiguration);
    }

    public FileApiClientAdapterImpl(boolean productionMode, String apiKey, String projectId) {
        super(productionMode, apiKey, projectId);
    }

    public FileApiClientAdapterImpl(boolean productionMode, String apiKey, String projectId, ProxyConfiguration proxyConfiguration) {
        super(productionMode, apiKey, projectId, proxyConfiguration);
    }

    public FileApiClientAdapterImpl(String baseApiUrl, String apiKey, String projectId) {
        super(baseApiUrl, apiKey, projectId);
    }

    public FileApiClientAdapterImpl(String baseApiUrl, String apiKey, String projectId, ProxyConfiguration proxyConfiguration) {
        super(baseApiUrl, apiKey, projectId, proxyConfiguration);
    }

    @Override
    public StringResponse getFile(String fileUri, String locale, RetrievalType retrievalType) throws ApiException {
        GetFileParameterBuilder getFileParameterBuilder = new GetFileParameterBuilder().fileUri(fileUri).locale(locale).retrievalType(retrievalType);
        return this.getFile(getFileParameterBuilder);
    }

    @Override
    public StringResponse getFile(GetFileParameterBuilder getFileParameterBuilder) throws ApiException {
        logger.debug((Object)String.format("Get file: fileUri = %s, projectId = %s, apiKey = %s, locale = %s", getFileParameterBuilder.getFileUri(), this.projectId, this.maskApiKey(this.apiKey), getFileParameterBuilder.getLocale()));
        List<NameValuePair> paramsList = getFileParameterBuilder.getNameValueList();
        String params = this.buildParamsQuery(paramsList.toArray(new NameValuePair[paramsList.size()]));
        HttpGet getRequest = new HttpGet(this.buildUrl(GET_FILE_API_URL, params));
        StringResponse stringResponse = this.getStringResponse((HttpRequestBase)getRequest);
        logger.debug((Object)String.format("Get file: %s", "SUCCESS"));
        return stringResponse;
    }

    @Override
    public ApiResponse<FileList> getFilesList(FileListSearchParams fileListSearchParams) throws ApiException {
        logger.debug((Object)String.format("Get files list: fileUriMask = %s, projectId = %s, apiKey = %s, locale = %s", fileListSearchParams.getUriMask(), this.projectId, this.maskApiKey(this.apiKey), fileListSearchParams.getLocale()));
        String params = this.buildFileListParams(fileListSearchParams);
        HttpGet getRequest = new HttpGet(this.buildUrl(GET_FILE_LIST_API_URL, params));
        ApiResponse<FileList> apiResponse = this.getResponse((HttpRequestBase)getRequest, new TypeToken<ApiResponseWrapper<FileList>>(){});
        logger.debug((Object)String.format("Get files list: %s. %s", apiResponse.getCode(), this.getApiResponseMessages(apiResponse)));
        return apiResponse;
    }

    @Override
    public ApiResponse<FileStatus> getFileStatus(String fileUri, String locale) throws ApiException {
        logger.debug((Object)String.format("Get file status: fileUri = %s, projectId = %s, apiKey = %s, locale = %s", fileUri, this.projectId, this.maskApiKey(this.apiKey), locale));
        String params = this.buildParamsQuery(new NameValuePair[]{new BasicNameValuePair("fileUri", fileUri), new BasicNameValuePair("locale", locale)});
        HttpGet getRequest = new HttpGet(this.buildUrl(GET_FILE_STATUS_API_URL, params));
        ApiResponse<FileStatus> apiResponse = this.getResponse((HttpRequestBase)getRequest, new TypeToken<ApiResponseWrapper<FileStatus>>(){});
        logger.debug((Object)String.format("Get file status: %s. %s", apiResponse.getCode(), this.getApiResponseMessages(apiResponse)));
        return apiResponse;
    }

    @Override
    public ApiResponse<UploadFileData> uploadFile(File fileToUpload, String charsetName, FileUploadParameterBuilder fileUploadParameterBuilder) throws ApiException {
        FileBody fileBody = new FileBody(fileToUpload, this.createContentType(fileUploadParameterBuilder.getFileType(), Charset.forName(charsetName)), fileToUpload.getName());
        return this.uploadFile(fileUploadParameterBuilder, (ContentBody)fileBody);
    }

    @Override
    public ApiResponse<UploadFileData> uploadFile(InputStream inputStream, String fileName, String charsetName, FileUploadParameterBuilder fileUploadParameterBuilder) throws ApiException {
        InputStreamBody inputStreamBody = new InputStreamBody(inputStream, this.createContentType(fileUploadParameterBuilder.getFileType(), Charset.forName(charsetName)), fileName);
        return this.uploadFile(fileUploadParameterBuilder, (ContentBody)inputStreamBody);
    }

    @Override
    public ApiResponse<EmptyResponse> deleteFile(String fileUri) throws ApiException {
        logger.debug((Object)String.format("Delete file: fileUri = %s, projectId = %s, apiKey = %s", fileUri, this.projectId, this.maskApiKey(this.apiKey)));
        String params = this.buildParamsQuery(new NameValuePair[]{new BasicNameValuePair("fileUri", fileUri)});
        HttpDelete httpDeleteFileRequest = new HttpDelete(this.buildUrl(DELETE_FILE_URL, params));
        ApiResponse<EmptyResponse> apiResponse = this.getResponse((HttpRequestBase)httpDeleteFileRequest, new TypeToken<ApiResponseWrapper<EmptyResponse>>(){});
        logger.debug((Object)String.format("Delete file: %s. %s", apiResponse.getCode(), this.getApiResponseMessages(apiResponse)));
        return apiResponse;
    }

    @Override
    public ApiResponse<EmptyResponse> renameFile(String fileUri, String newFileUri) throws ApiException {
        logger.debug((Object)String.format("Rename file: fileUri = %s, projectId = %s, apiKey = %s", fileUri, this.projectId, this.maskApiKey(this.apiKey)));
        String params = this.buildParamsQuery(new NameValuePair[]{new BasicNameValuePair("fileUri", fileUri), new BasicNameValuePair("newFileUri", newFileUri)});
        HttpPost httpPostRequest = new HttpPost(this.buildUrl(RENAME_FILE_URL, params));
        ApiResponse<EmptyResponse> apiResponse = this.getResponse((HttpRequestBase)httpPostRequest, new TypeToken<ApiResponseWrapper<EmptyResponse>>(){});
        logger.debug((Object)String.format("Rename file: %s. %s", apiResponse.getCode(), this.getApiResponseMessages(apiResponse)));
        return apiResponse;
    }

    @Override
    public ApiResponse<FileLastModified> getLastModified(String fileUri, Date lastModifiedAfter, String locale) throws ApiException {
        logger.debug((Object)String.format("Get last modified: fileUri = %s, projectId = %s, apiKey = %s, locale = %s", fileUri, this.projectId, this.maskApiKey(this.apiKey), locale));
        String params = this.buildParamsQuery(new NameValuePair[]{new BasicNameValuePair("fileUri", fileUri), new BasicNameValuePair("lastModifiedAfter", DateFormatter.format(lastModifiedAfter)), new BasicNameValuePair("locale", locale)});
        HttpGet getRequest = new HttpGet(this.buildUrl(GET_FILE_LAST_MODIFIED, params));
        ApiResponse<FileLastModified> apiResponse = this.getResponse((HttpRequestBase)getRequest, new TypeToken<ApiResponseWrapper<FileLastModified>>(){});
        logger.debug((Object)String.format("Get last modified: %s. %s", apiResponse.getCode(), this.getApiResponseMessages(apiResponse)));
        return apiResponse;
    }

    private ApiResponse<UploadFileData> uploadFile(FileUploadParameterBuilder fileUploadParameterBuilder, ContentBody contentBody) throws ApiException {
        logger.debug((Object)String.format("Upload file: fileUri = %s, projectId = %s, apiKey = %s, localesToApprove = %s", fileUploadParameterBuilder.getFileUri(), this.projectId, this.maskApiKey(this.apiKey), StringUtils.join(fileUploadParameterBuilder.getLocalesToApprove(), (String)", ")));
        List<NameValuePair> paramsList = fileUploadParameterBuilder.getNameValueList();
        String params = this.buildParamsQuery(paramsList.toArray(new NameValuePair[paramsList.size()]));
        HttpPost httpPostFile = this.createFileUploadHttpPostRequest(params, contentBody);
        ApiResponse<UploadFileData> apiResponse = this.getResponse((HttpRequestBase)httpPostFile, new TypeToken<ApiResponseWrapper<UploadFileData>>(){});
        logger.debug((Object)String.format("Upload file: %s. %s", apiResponse.getCode(), this.getApiResponseMessages(apiResponse)));
        return apiResponse;
    }

    private <T extends Data> ApiResponse<T> getResponse(HttpRequestBase executeRequest, TypeToken<ApiResponseWrapper<T>> typeToken) throws ApiException {
        StringResponse response = this.getStringResponse(executeRequest);
        return this.parseApiResponse(response.getContents(), typeToken);
    }

    private StringResponse getStringResponse(HttpRequestBase httpRequest) throws ApiException {
        StringResponse stringResponse = this.getHttpUtils().executeHttpCall(httpRequest, this.proxyConfiguration);
        if (stringResponse.isSuccess()) {
            return stringResponse;
        }
        String contents = stringResponse.getContents();
        logger.error((Object)String.format("Non-successful response: \n contents: %s", contents));
        throw this.newApiException(contents);
    }

    private ApiException newApiException(String contents) {
        ApiResponse<EmptyResponse> emptyResponseApiResponse = this.parseApiResponse(contents, new TypeToken<ApiResponseWrapper<EmptyResponse>>(){});
        String apiCode = emptyResponseApiResponse.getCode();
        List<String> messages = emptyResponseApiResponse.getMessages();
        switch (apiCode) {
            case "VALIDATION_ERROR": {
                return new ValidationException(contents, messages);
            }
            case "AUTHENTICATION_ERROR": {
                return new AuthenticationException(contents, messages);
            }
            case "AUTHORIZATION_ERROR": {
                return new AuthorizationException(contents, messages);
            }
            case "RESOURCE_LOCKED": {
                return new ResourceLockedException(contents, messages);
            }
            case "MAX_OPERATIONS_LIMIT_EXCEEDED": {
                return new OperationsLimitExceeded(contents, messages);
            }
            case "GENERAL_ERROR": {
                return new UnexpectedException(contents, messages);
            }
            case "MAINTENANCE_MODE_ERROR": {
                return new MaintenanceModeException(contents, messages);
            }
        }
        return new ApiException(contents, messages);
    }

    private HttpPost createFileUploadHttpPostRequest(String apiParameters, ContentBody contentBody) {
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().addPart("file", contentBody);
        HttpPost httpPost = new HttpPost(String.format(UPLOAD_FILE_API_URL, this.baseApiUrl) + apiParameters);
        httpPost.setEntity(multipartEntityBuilder.build());
        return httpPost;
    }

    private String buildFileListParams(FileListSearchParams fileListSearchParams) {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("locale", fileListSearchParams.getLocale()));
        nameValuePairs.add(new BasicNameValuePair("uriMask", fileListSearchParams.getUriMask()));
        nameValuePairs.add(new BasicNameValuePair("lastUploadedAfter", DateFormatter.format(fileListSearchParams.getLastUploadedAfter())));
        nameValuePairs.add(new BasicNameValuePair("lastUploadedBefore", DateFormatter.format(fileListSearchParams.getLastUploadedBefore())));
        nameValuePairs.add(new BasicNameValuePair("offset", null == fileListSearchParams.getOffset() ? null : String.valueOf(fileListSearchParams.getOffset())));
        nameValuePairs.add(new BasicNameValuePair("limit", null == fileListSearchParams.getLimit() ? null : String.valueOf(fileListSearchParams.getLimit())));
        nameValuePairs.addAll(this.getNameValuePairs("fileTypes", fileListSearchParams.getFileTypes()));
        nameValuePairs.addAll(this.getNameValuePairs("conditions", fileListSearchParams.getConditions()));
        nameValuePairs.addAll(this.getNameValuePairs("orderBy", fileListSearchParams.getOrderBy()));
        return this.buildParamsQuery(nameValuePairs.toArray(new NameValuePair[nameValuePairs.size()]));
    }

    private ContentType createContentType(FileType fileType, Charset charset) {
        return fileType.isTextFormat() ? ContentType.create((String)fileType.getMimeType(), (Charset)charset) : ContentType.create((String)fileType.getMimeType());
    }
}

