/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.v2.response;

import com.smartling.api.v2.response.EmptyData;
import com.smartling.api.v2.response.Error;
import com.smartling.api.v2.response.ErrorResponse;
import com.smartling.api.v2.response.ListResponse;
import com.smartling.api.v2.response.Response;
import com.smartling.api.v2.response.ResponseCode;
import com.smartling.api.v2.response.ResponseData;
import com.smartling.api.v2.response.RestApiResponse;
import com.smartling.api.v2.response.SuccessResponse;
import java.util.Arrays;
import java.util.List;

public class ResponseBuilders {
    public static <T extends ResponseData> RestApiResponse<T> respondWith(T data) {
        return ResponseBuilders.wrap(new SuccessResponse<T>(data));
    }

    public static <T extends ResponseData> RestApiResponse<ListResponse<T>> respondWith(List<T> data) {
        return ResponseBuilders.wrap(new SuccessResponse<ListResponse<T>>(new ListResponse<T>(data)));
    }

    public static RestApiResponse<EmptyData> respondWith(ResponseCode code, Error ... errors) {
        return ResponseBuilders.respondWith(code, Arrays.asList(errors));
    }

    public static RestApiResponse<EmptyData> respondWith(ResponseCode code, List<Error> errors) {
        return ResponseBuilders.wrap(new ErrorResponse(code, errors));
    }

    public static RestApiResponse<EmptyData> respondWith(ResponseCode code, Exception ex) {
        return ResponseBuilders.respondWith(code, new Error(ex));
    }

    private static <T extends ResponseData> RestApiResponse<T> wrap(Response<T> response) {
        return new RestApiResponse<T>(response);
    }
}

