/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.v2.client.auth;

import com.smartling.api.v2.authentication.AuthenticationApi;
import com.smartling.api.v2.authentication.pto.Authentication;
import com.smartling.api.v2.authentication.pto.AuthenticationRefreshRequest;
import com.smartling.api.v2.authentication.pto.AuthenticationRequest;
import com.smartling.api.v2.client.auth.Clock;
import com.smartling.api.v2.client.auth.SystemClock;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Authenticator {
    private static final Logger log = LoggerFactory.getLogger(Authenticator.class);
    static final int REFRESH_BEFORE_EXPIRES_MS = 90000;
    private final AuthenticationApi api;
    private final Clock clock;
    private final String userIdentifier;
    private final String userSecret;
    private Authentication authentication;
    private volatile long expiresAt = -1L;
    private volatile long refreshExpiresAt = -1L;

    public Authenticator(String userIdentifier, String userSecret, AuthenticationApi authenticationApi) {
        this(userIdentifier, userSecret, authenticationApi, new SystemClock());
    }

    Authenticator(String userIdentifier, String userSecret, AuthenticationApi api, Clock clock) {
        Objects.requireNonNull(userIdentifier, "userIdentifier required");
        Objects.requireNonNull(userSecret, "userSecret required");
        Objects.requireNonNull(api, "authentication API required");
        Objects.requireNonNull(clock, "clock required");
        this.userIdentifier = userIdentifier;
        this.userSecret = userSecret;
        this.api = api;
        this.clock = clock;
    }

    public String getAccessToken() {
        if (this.authentication != null && this.isValid()) {
            log.debug("current token valid");
            return this.authentication.getAccessToken();
        }
        return this.refreshOrRequestNewAccessToken(false);
    }

    synchronized String refreshOrRequestNewAccessToken(boolean forceRefresh) {
        if (!forceRefresh && this.authentication != null && this.isValid()) {
            log.debug("using current token");
            return this.authentication.getAccessToken();
        }
        if (this.authentication != null && this.isRefreshable()) {
            log.debug("Going to refresh access token.");
            try {
                return this.refreshAccessToken();
            }
            catch (Exception e) {
                log.info("Failed to refresh accessToken. Requesting new token.");
            }
        }
        log.debug("Requesting new token.");
        return this.getAccessTokenInternal();
    }

    boolean isValid() {
        if (this.authentication == null) {
            return false;
        }
        return this.expiresAt > this.clock.currentTimeMillis() + 90000L;
    }

    boolean isRefreshable() {
        if (this.authentication == null) {
            return false;
        }
        return this.refreshExpiresAt > this.clock.currentTimeMillis();
    }

    private synchronized String getAccessTokenInternal() {
        this.authentication = this.api.authenticate(new AuthenticationRequest(this.userIdentifier, this.userSecret));
        this.expiresAt = (long)(this.authentication.getExpiresIn() * 1000) + System.currentTimeMillis();
        this.refreshExpiresAt = (long)(this.authentication.getRefreshExpiresIn() * 100) + System.currentTimeMillis();
        return this.authentication.getAccessToken();
    }

    private synchronized String refreshAccessToken() {
        this.authentication = this.api.refresh(new AuthenticationRefreshRequest(this.authentication.getRefreshToken()));
        this.expiresAt = (long)(this.authentication.getExpiresIn() * 1000) + System.currentTimeMillis();
        this.refreshExpiresAt = (long)(this.authentication.getRefreshExpiresIn() * 100) + System.currentTimeMillis();
        return this.authentication.getAccessToken();
    }
}

