/*
 * Decompiled with CFR 0.152.
 */
package com.sloop.view.loading;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.ViewGroup;
import com.sloop.view.loading.R;
import com.sloop.view.utils.UiUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class LeafLoading
extends View {
    private static final String TAG = "SloopLeafLoading";
    private int mDefaultWidth = 300;
    private int mDefaultHeight = 60;
    private static final int COLOR_WHITE = -204652;
    private static final int COLOR_ORANGE = -22528;
    private static final int MIDDLE_AMPLITUDE = 13;
    private static final int AMPLITUDE_DISPARITY = 5;
    private static final int TOTAL_PROGRESS = 100;
    private static final long LEAF_FLOAT_TIME = 3000L;
    private static final long LEAF_ROTATE_TIME = 2000L;
    private int mLeftMargin;
    private int mRightMargin;
    private int mMiddleAmplitude = 13;
    private int mAmplitudeDisparity = 5;
    private long mLeafFloatTime = 3000L;
    private long mLeafRotateTime = 2000L;
    private Paint mBitmapPaint;
    private Paint mWhitePaint;
    private Paint mOrangePaint;
    private RectF mWhiteRectF;
    private RectF mOrangeRectF;
    private RectF mArcRectF;
    private int mCurrentProgress;
    private int mProgressWidth;
    private int mCurrentProgressPosition;
    private int mArcRadius;
    private int mArcRightLocation;
    private Resources mResources;
    private int mAddTime;
    private Bitmap mLeafBitmap;
    private List<Leaf> mLeafInfos;
    private LeafFactory mLeafFactory;
    private float mLeafBitmapWidth;
    private float mLeafBitmapHeight;
    private float mLeafPaintWidth;
    private float mLeafPaintHeight;
    private Bitmap mOuterBitmap;
    private int mOuterWidth;
    private int mOuterHeight;
    private Rect mOuterSrcRect;
    private Rect mOuterDestRect;
    private Fan mFan;
    private static final long FAN_SPEED = 6L;
    private static final long FAN_SPEED_DISPARITY = 150L;
    private Bitmap mFanBitmap;
    private float mFanBitmapSideLength;
    private float mFanPaintSideLength;
    private long mFanSpeed = 6L;
    private ProgressChangedListener mListener;

    public LeafLoading(Context context) {
        super(context);
        this.init((ContextThemeWrapper)context);
    }

    public LeafLoading(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init((ContextThemeWrapper)context);
    }

    private void init(ContextThemeWrapper context) {
        this.initResources(context);
        this.initBitmap();
        this.initPaint();
        this.mLeafFactory = new LeafFactory();
        this.mLeafInfos = this.mLeafFactory.generateLeafs();
        this.mFan = new FanFactory().generateFan();
    }

    private void initResources(ContextThemeWrapper context) {
        this.mResources = this.getResources();
        this.mLeafFloatTime = 3000L;
        this.mLeafRotateTime = 2000L;
        this.mDefaultWidth = UiUtils.dip2px(context, this.mDefaultWidth);
        this.mDefaultHeight = UiUtils.dip2px(context, this.mDefaultHeight);
    }

    private void initBitmap() {
        this.mLeafBitmap = ((BitmapDrawable)this.mResources.getDrawable(R.drawable.leaf_xxhdpi)).getBitmap();
        this.mLeafBitmapWidth = this.mLeafBitmap.getWidth();
        this.mLeafBitmapHeight = this.mLeafBitmap.getHeight();
        this.mOuterBitmap = ((BitmapDrawable)this.mResources.getDrawable(R.drawable.outer_xxhdpi)).getBitmap();
        this.mOuterWidth = this.mOuterBitmap.getWidth();
        this.mOuterHeight = this.mOuterBitmap.getHeight();
        this.mFanBitmap = ((BitmapDrawable)this.mResources.getDrawable(R.drawable.fan_xxhdpi)).getBitmap();
        this.mFanBitmapSideLength = this.mFanBitmap.getWidth();
    }

    private void initPaint() {
        this.mBitmapPaint = new Paint();
        this.mBitmapPaint.setAntiAlias(true);
        this.mBitmapPaint.setDither(true);
        this.mBitmapPaint.setFilterBitmap(true);
        this.mWhitePaint = new Paint();
        this.mWhitePaint.setAntiAlias(true);
        this.mWhitePaint.setColor(-204652);
        this.mOrangePaint = new Paint();
        this.mOrangePaint.setAntiAlias(true);
        this.mOrangePaint.setColor(-22528);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measureHeight;
        ViewGroup.LayoutParams params = this.getLayoutParams();
        int measureWidth = this.getMeasureWidth(widthMeasureSpec, params);
        measureWidth = measureWidth > (measureHeight = this.getMeasureHeight(heightMeasureSpec, params)) * 5 ? measureHeight * 5 : measureWidth;
        measureHeight = measureWidth / 5;
        this.setMeasuredDimension(measureWidth, measureHeight);
    }

    private int getMeasureWidth(int widthMeasureSpec, ViewGroup.LayoutParams params) {
        int measureWidth = params.width == -1 ? View.MeasureSpec.getSize((int)widthMeasureSpec) : (params.width >= 0 ? params.width : this.mDefaultWidth);
        return measureWidth;
    }

    private int getMeasureHeight(int heightMeasureSpec, ViewGroup.LayoutParams params) {
        int measureHeight = params.height == -1 ? View.MeasureSpec.getSize((int)heightMeasureSpec) : (params.height >= 0 ? params.height : this.mDefaultHeight);
        return measureHeight;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        int mTotalWidth = w > h * 5 ? h * 5 : w;
        int mTotalHeight = mTotalWidth / 5;
        this.mLeftMargin = mTotalHeight / 12;
        this.mRightMargin = mTotalHeight / 2;
        this.mProgressWidth = mTotalWidth - this.mLeftMargin - this.mRightMargin;
        this.mArcRadius = (mTotalHeight - 2 * this.mLeftMargin) / 2;
        this.mOuterSrcRect = new Rect(0, 0, this.mOuterWidth, this.mOuterHeight);
        this.mOuterDestRect = new Rect(0, 0, mTotalWidth, mTotalHeight);
        this.mFan.x = (float)mTotalWidth * 49.0f / 60.0f;
        this.mFan.y = (float)mTotalHeight / 12.0f;
        this.mFanPaintSideLength = (float)mTotalWidth / 6.0f;
        this.mLeafPaintWidth = (float)mTotalHeight / 3.0f;
        this.mLeafPaintHeight = (float)mTotalHeight / 6.0f;
        this.mWhiteRectF = new RectF((float)(this.mLeftMargin + this.mCurrentProgressPosition), (float)this.mLeftMargin, (float)(mTotalWidth - this.mRightMargin), (float)(mTotalHeight - this.mLeftMargin));
        this.mOrangeRectF = new RectF((float)(this.mLeftMargin + this.mArcRadius), (float)this.mLeftMargin, (float)this.mCurrentProgressPosition, (float)(mTotalHeight - this.mLeftMargin));
        this.mArcRectF = new RectF((float)this.mLeftMargin, (float)this.mLeftMargin, (float)(this.mLeftMargin + 2 * this.mArcRadius), (float)(mTotalHeight - this.mLeftMargin));
        this.mArcRightLocation = this.mLeftMargin + this.mArcRadius;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawProgressAndLeafs(canvas);
        canvas.drawBitmap(this.mOuterBitmap, this.mOuterSrcRect, this.mOuterDestRect, this.mBitmapPaint);
        this.drawFan(canvas);
        this.postInvalidate();
    }

    private void drawProgressAndLeafs(Canvas canvas) {
        if (this.mCurrentProgress >= 100) {
            this.mCurrentProgress = 100;
        }
        this.mCurrentProgressPosition = this.mProgressWidth * this.mCurrentProgress / 100;
        if (this.mCurrentProgressPosition < this.mArcRadius) {
            canvas.drawArc(this.mArcRectF, 90.0f, 180.0f, false, this.mWhitePaint);
            this.mWhiteRectF.left = this.mArcRightLocation;
            canvas.drawRect(this.mWhiteRectF, this.mWhitePaint);
            this.drawLeafs(canvas);
            int angle = (int)Math.toDegrees(Math.acos((float)(this.mArcRadius - this.mCurrentProgressPosition) / (float)this.mArcRadius));
            int startAngle = 180 - angle;
            int sweepAngle = 2 * angle;
            canvas.drawArc(this.mArcRectF, (float)startAngle, (float)sweepAngle, false, this.mOrangePaint);
        } else {
            this.mWhiteRectF.left = this.mCurrentProgressPosition;
            canvas.drawRect(this.mWhiteRectF, this.mWhitePaint);
            this.drawLeafs(canvas);
            canvas.drawArc(this.mArcRectF, 90.0f, 180.0f, false, this.mOrangePaint);
            this.mOrangeRectF.left = this.mArcRightLocation;
            this.mOrangeRectF.right = this.mCurrentProgressPosition;
            canvas.drawRect(this.mOrangeRectF, this.mOrangePaint);
        }
    }

    private void drawLeafs(Canvas canvas) {
        this.mLeafRotateTime = this.mLeafRotateTime <= 0L ? 2000L : this.mLeafRotateTime;
        long currentTime = System.currentTimeMillis();
        for (int i = 0; i < this.mLeafInfos.size(); ++i) {
            Leaf leaf = this.mLeafInfos.get(i);
            if (currentTime <= leaf.startTime || leaf.startTime == 0L) continue;
            this.getLeafLocation(leaf, currentTime);
            canvas.save();
            Matrix matrix = new Matrix();
            float scaleX = this.mLeafPaintWidth / this.mLeafBitmapWidth;
            float scaleY = this.mLeafPaintHeight / this.mLeafBitmapHeight;
            matrix.postScale(scaleX, scaleY);
            float transX = (float)this.mLeftMargin + leaf.x;
            float transY = (float)this.mLeftMargin + leaf.y;
            matrix.postTranslate(transX, transY);
            float rotateFraction = (float)((currentTime - leaf.startTime) % this.mLeafRotateTime) / (float)this.mLeafRotateTime;
            int angle = (int)(rotateFraction * 360.0f);
            int rotate = leaf.rotateDirection == 0 ? angle + leaf.rotateAngle : -angle + leaf.rotateAngle;
            matrix.postRotate((float)rotate, transX + this.mLeafBitmapWidth / 2.0f, transY + this.mLeafBitmapHeight / 2.0f);
            canvas.drawBitmap(this.mLeafBitmap, matrix, this.mBitmapPaint);
            canvas.restore();
        }
    }

    private void getLeafLocation(Leaf leaf, long currentTime) {
        this.mLeafFloatTime = this.mLeafFloatTime <= 0L ? 3000L : this.mLeafFloatTime;
        long intervalTime = currentTime - leaf.startTime;
        if (intervalTime <= 0L) {
            return;
        }
        if (intervalTime > this.mLeafFloatTime) {
            leaf.startTime = System.currentTimeMillis() + (long)new Random().nextInt((int)this.mLeafFloatTime);
        }
        float fraction = (float)intervalTime / (float)this.mLeafFloatTime;
        leaf.x = (float)this.mProgressWidth - (float)this.mProgressWidth * fraction;
        leaf.y = this.getLeafLocationY(leaf);
    }

    private float getLeafLocationY(Leaf leaf) {
        float \u03c9 = (float)(Math.PI * 2 / (double)this.mProgressWidth);
        float A = this.mMiddleAmplitude;
        if (leaf.type == StartType.LITTLE) {
            A = this.mMiddleAmplitude - this.mAmplitudeDisparity;
        } else if (leaf.type == StartType.BIG) {
            A = this.mMiddleAmplitude + this.mAmplitudeDisparity;
        }
        float y = (float)((double)A * Math.sin(\u03c9 * leaf.x + (float)leaf.\u03c6) + (double)(this.mArcRadius * 2 / 3));
        return y;
    }

    private void drawFan(Canvas canvas) {
        long currentTime = System.currentTimeMillis();
        long mFanRotateTime = (10L - this.mFanSpeed) * 150L + 500L;
        canvas.save();
        Matrix matrix = new Matrix();
        float transX = this.mFan.x;
        float transY = this.mFan.y;
        float scale = this.mFanPaintSideLength / this.mFanBitmapSideLength;
        matrix.postScale(scale, scale);
        matrix.postTranslate(transX, transY);
        float rotateFraction = (float)((currentTime - this.mFan.startTime) % mFanRotateTime) / (float)mFanRotateTime;
        int angle = (int)(rotateFraction * 360.0f);
        int rotate = this.mFan.rotateDirection == 0 ? angle + this.mFan.rotateAngle : -angle + this.mFan.rotateAngle;
        matrix.postRotate((float)rotate, transX + this.mFanPaintSideLength / 2.0f, transY + this.mFanPaintSideLength / 2.0f);
        canvas.drawBitmap(this.mFanBitmap, matrix, this.mBitmapPaint);
        canvas.restore();
    }

    public void setMiddleAmplitude(int amplitude) {
        this.mMiddleAmplitude = amplitude;
    }

    public void setMplitudeDisparity(int disparity) {
        this.mAmplitudeDisparity = disparity;
    }

    public int getMiddleAmplitude() {
        return this.mMiddleAmplitude;
    }

    public int getMplitudeDisparity() {
        return this.mAmplitudeDisparity;
    }

    public void setProgress(int progress) {
        this.mCurrentProgress = progress;
        if (this.mListener != null) {
            this.mListener.onProgressChanged(progress, 100);
        }
        this.postInvalidate();
    }

    public void setLeafFloatTime(long time) {
        this.mLeafFloatTime = time;
    }

    public void setLeafRotateTime(long time) {
        this.mLeafRotateTime = time;
    }

    public long getLeafFloatTime() {
        this.mLeafFloatTime = this.mLeafFloatTime == 0L ? 3000L : this.mLeafFloatTime;
        return this.mLeafFloatTime;
    }

    public long getLeafRotateTime() {
        this.mLeafRotateTime = this.mLeafRotateTime == 0L ? 2000L : this.mLeafRotateTime;
        return this.mLeafRotateTime;
    }

    public long getmFanSpeed() {
        return this.mFanSpeed;
    }

    public void setmFanSpeed(long mFanSpeed) {
        if (mFanSpeed < 0L) {
            return;
        }
        if (mFanSpeed > 10L) {
            return;
        }
        this.mFanSpeed = mFanSpeed;
    }

    public void setListener(ProgressChangedListener mListener) {
        this.mListener = mListener;
    }

    public static interface ProgressChangedListener {
        public void onProgressChanged(int var1, int var2);
    }

    private class LeafFactory {
        private static final int MAX_LEAFS = 8;
        Random random = new Random();

        private LeafFactory() {
        }

        public List<Leaf> generateLeafs() {
            return this.generateLeafs(8);
        }

        public List<Leaf> generateLeafs(int leafSize) {
            LinkedList<Leaf> leafs = new LinkedList<Leaf>();
            for (int i = 0; i < leafSize; ++i) {
                leafs.add(this.generateLeaf());
            }
            return leafs;
        }

        public Leaf generateLeaf() {
            Leaf leaf = new Leaf();
            int tempType = this.random.nextInt(3);
            StartType type = StartType.MIDDLE;
            switch (tempType) {
                case 0: {
                    type = StartType.LITTLE;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    type = StartType.BIG;
                }
            }
            leaf.type = type;
            leaf.\u03c6 = this.random.nextInt(20);
            leaf.rotateAngle = this.random.nextInt(360);
            leaf.rotateDirection = this.random.nextInt(2);
            LeafLoading.this.mLeafFloatTime = LeafLoading.this.mLeafFloatTime <= 0L ? 3000L : LeafLoading.this.mLeafFloatTime;
            LeafLoading.this.mAddTime = LeafLoading.this.mAddTime + this.random.nextInt((int)(LeafLoading.this.mLeafFloatTime * 2L));
            leaf.startTime = System.currentTimeMillis() + (long)LeafLoading.this.mAddTime;
            return leaf;
        }
    }

    private class Leaf {
        float x;
        float y;
        StartType type;
        int rotateAngle;
        int rotateDirection;
        long startTime;
        int \u03c6;

        private Leaf() {
        }
    }

    private static enum StartType {
        LITTLE,
        MIDDLE,
        BIG;

    }

    private class FanFactory {
        private FanFactory() {
        }

        public Fan generateFan() {
            Fan fan = new Fan();
            fan.startTime = System.currentTimeMillis();
            fan.rotateDirection = -1;
            fan.rotateAngle = 0;
            return fan;
        }
    }

    private class Fan {
        float x;
        float y;
        int rotateAngle;
        int rotateDirection;
        long startTime;

        private Fan() {
        }
    }
}

