/*
 * Decompiled with CFR 0.152.
 */
package com.sloop.fonts;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.sloop.fonts.ActionBarHelper;
import java.io.File;

public class FontsManager {
    public static final String TAG = "FontsManagerException";
    public static final String INIT_EXCEPTION = "FontsManager\u4f7f\u7528\u8be5\u51fd\u6570\u524d\u5fc5\u987b\u5148\u8fdb\u884c\u521d\u59cb\u5316";
    public static Typeface defaultTypeface = null;

    private FontsManager() {
    }

    public static void init(Typeface typeface) {
        if (typeface == null) {
            Log.e((String)TAG, (String)"typeface\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            throw new IllegalStateException("typeface\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        defaultTypeface = typeface;
    }

    public static void initFormAssets(Context context, String fontPath) {
        try {
            defaultTypeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)fontPath);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5fontsPath\u662f\u5426\u9519\u8bef");
            throw new IllegalStateException("\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5fontsPath\u662f\u5426\u9519\u8bef");
        }
    }

    public static void initFormFile(String fontPath) {
        try {
            defaultTypeface = Typeface.createFromFile((String)fontPath);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5fontsPath\u662f\u5426\u9519\u8bef");
            throw new IllegalStateException("\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5fontsPath\u662f\u5426\u9519\u8bef");
        }
    }

    public static void initFormFile(File fontFile) {
        try {
            defaultTypeface = Typeface.createFromFile((File)fontFile);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5fontFile\u662f\u5426\u662f\u5b57\u4f53\u6587\u4ef6");
            throw new IllegalStateException("\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5fontFile\u662f\u5426\u662f\u5b57\u4f53\u6587\u4ef6");
        }
    }

    public static void changeFonts(Activity activity) {
        if (defaultTypeface == null) {
            Log.e((String)TAG, (String)INIT_EXCEPTION);
            throw new IllegalStateException(INIT_EXCEPTION);
        }
        ActionBarHelper.changeTitleFonts(activity, defaultTypeface);
        FontsManager.changeFonts((ViewGroup)activity.findViewById(0x1020002), defaultTypeface);
    }

    public static void changeFonts(View view) {
        if (defaultTypeface == null) {
            Log.e((String)TAG, (String)INIT_EXCEPTION);
            throw new IllegalStateException(INIT_EXCEPTION);
        }
        FontsManager.changeFonts(view, defaultTypeface);
    }

    public static void changeFonts(ViewGroup viewGroup) {
        if (defaultTypeface == null) {
            Log.e((String)TAG, (String)INIT_EXCEPTION);
            throw new IllegalStateException(INIT_EXCEPTION);
        }
        FontsManager.changeFonts(viewGroup, defaultTypeface);
    }

    public static void changeFonts(ViewGroup viewGroup, Typeface typeface) {
        try {
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                View v = viewGroup.getChildAt(i);
                if (v instanceof ViewGroup) {
                    FontsManager.changeFonts((ViewGroup)v, typeface);
                    continue;
                }
                if (v == null) continue;
                FontsManager.changeFonts(v, typeface);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.toString());
        }
    }

    public static void changeFonts(View view, Typeface typeface) {
        try {
            if (view instanceof ViewGroup) {
                FontsManager.changeFonts((ViewGroup)view, typeface);
            } else if (view instanceof TextView) {
                ((TextView)view).setTypeface(typeface);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.toString());
        }
    }
}

