/*
 * Decompiled with CFR 0.152.
 */
package com.sloop.fonts;

import android.app.ActionBar;
import android.app.Activity;
import android.graphics.Typeface;
import android.os.Build;
import android.support.v7.app.ActionBarActivity;
import android.support.v7.app.AppCompatActivity;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;
import android.util.Log;

public class ActionBarHelper {
    private static final String TAG = "ABHException";

    public static void changeTitleFonts(Activity activity, Typeface typeface) {
        if (typeface == null || activity == null) {
            Log.e((String)TAG, (String)"activity\u6216 typeface\u7b49\u4e8e\u7a7a!");
            return;
        }
        if (activity instanceof ActionBarActivity || activity instanceof AppCompatActivity) {
            try {
                android.support.v7.app.ActionBar actionBar = ((ActionBarActivity)activity).getSupportActionBar();
                if (actionBar != null) {
                    ActionBarHelper.setTitle(actionBar, typeface, actionBar.getTitle().toString());
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.toString());
            }
        } else {
            try {
                ActionBar actionBar = null;
                if (Build.VERSION.SDK_INT >= 11 && (actionBar = activity.getActionBar()) != null) {
                    ActionBarHelper.setTitle(actionBar, typeface, actionBar.getTitle().toString());
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.toString());
            }
        }
    }

    public static void setTitle(Activity activity, Typeface typeface, String title) {
        if (activity instanceof ActionBarActivity) {
            try {
                android.support.v7.app.ActionBar actionBar = ((ActionBarActivity)activity).getSupportActionBar();
                ActionBarHelper.setTitle(actionBar, typeface, title);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.toString());
            }
        } else if (activity instanceof Activity) {
            try {
                ActionBar actionBar = null;
                if (Build.VERSION.SDK_INT >= 11) {
                    actionBar = activity.getActionBar();
                }
                ActionBarHelper.setTitle(actionBar, typeface, title);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.toString());
            }
        }
    }

    public static void setTitle(android.support.v7.app.ActionBar actionBar, Typeface typeface, String title) {
        if (typeface == null || actionBar == null) {
            Log.e((String)TAG, (String)"typeface\u6216actionbar\u4e3a\u7a7a");
            return;
        }
        SpannableString sp = new SpannableString((CharSequence)title);
        sp.setSpan((Object)new TypefaceSpan(typeface), 0, sp.length(), 33);
        ActionBarHelper.setTitle(actionBar, sp);
    }

    public static void setTitle(ActionBar actionBar, Typeface typeface, String title) {
        if (typeface == null || actionBar == null) {
            Log.e((String)TAG, (String)"typeface\u6216actionbar\u4e3a\u7a7a");
            return;
        }
        SpannableString sp = new SpannableString((CharSequence)title);
        sp.setSpan((Object)new TypefaceSpan(typeface), 0, sp.length(), 33);
        ActionBarHelper.setTitle(actionBar, sp);
    }

    public static void setTitle(android.support.v7.app.ActionBar actionBar, SpannableString spannableString) {
        if (Build.VERSION.SDK_INT == 16 && Build.MANUFACTURER.toUpperCase().equals("LGE")) {
            actionBar.setTitle((CharSequence)spannableString.toString());
        } else {
            actionBar.setTitle((CharSequence)spannableString);
        }
    }

    public static void setTitle(ActionBar actionBar, SpannableString spannableString) {
        if (Build.VERSION.SDK_INT == 16 && Build.MANUFACTURER.toUpperCase().equals("LGE")) {
            actionBar.setTitle((CharSequence)spannableString.toString());
        } else if (Build.VERSION.SDK_INT >= 11) {
            actionBar.setTitle((CharSequence)spannableString);
        }
    }

    private static class TypefaceSpan
    extends MetricAffectingSpan {
        Typeface typeface;

        TypefaceSpan(Typeface typeface) {
            this.typeface = typeface;
        }

        public void updateMeasureState(TextPaint p) {
            p.setTypeface(this.typeface);
            p.setFlags(p.getFlags() | 0x80);
        }

        public void updateDrawState(TextPaint tp) {
            tp.setTypeface(this.typeface);
            tp.setFlags(tp.getFlags() | 0x80);
        }
    }
}

