/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.util.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.slack.api.model.block.element.RichTextElement;
import com.slack.api.model.block.element.RichTextSectionElement;
import com.slack.api.model.block.element.RichTextUnknownElement;
import java.lang.reflect.Type;

public class GsonRichTextElementFactory
implements JsonDeserializer<RichTextElement>,
JsonSerializer<RichTextElement> {
    private final boolean failOnUnknownProperties;
    private static final GsonRichTextElementFactory LEGACY_SINGLETON = new GsonRichTextElementFactory(true);

    public GsonRichTextElementFactory() {
        this(false);
    }

    public GsonRichTextElementFactory(boolean failOnUnknownProperties) {
        this.failOnUnknownProperties = failOnUnknownProperties;
    }

    public RichTextElement deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        JsonPrimitive prim = (JsonPrimitive)jsonObject.get("type");
        String typeName = prim.getAsString();
        Class<? extends RichTextElement> clazz = this.detectElementClassFromType(typeName);
        return (RichTextElement)context.deserialize((JsonElement)jsonObject, clazz);
    }

    public JsonElement serialize(RichTextElement src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize((Object)src);
    }

    @Deprecated
    public static Class<? extends RichTextElement> detectElementClass(String className) {
        return LEGACY_SINGLETON.detectElementClassFromType(className);
    }

    private Class<? extends RichTextElement> detectElementClassFromType(String typeName) {
        switch (typeName) {
            case "rich_text_section": {
                return RichTextSectionElement.class;
            }
            case "text": {
                return RichTextSectionElement.Text.class;
            }
            case "channel": {
                return RichTextSectionElement.Channel.class;
            }
            case "user": {
                return RichTextSectionElement.User.class;
            }
            case "emoji": {
                return RichTextSectionElement.Emoji.class;
            }
            case "link": {
                return RichTextSectionElement.Link.class;
            }
            case "team": {
                return RichTextSectionElement.Team.class;
            }
            case "usergroup": {
                return RichTextSectionElement.UserGroup.class;
            }
            case "date": {
                return RichTextSectionElement.Date.class;
            }
            case "broadcast": {
                return RichTextSectionElement.Broadcast.class;
            }
            case "color": {
                return RichTextSectionElement.Color.class;
            }
            case "canvas": {
                return RichTextSectionElement.Canvas.class;
            }
        }
        if (this.failOnUnknownProperties) {
            throw new JsonParseException("Unknown RichTextSectionElement type: " + typeName);
        }
        return RichTextUnknownElement.class;
    }
}

