/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api;

import com.slack.api.audit.AuditConfig;
import com.slack.api.methods.MethodsConfig;
import com.slack.api.scim.SCIMConfig;
import com.slack.api.util.http.listener.DetailedLoggingListener;
import com.slack.api.util.http.listener.HttpResponseListener;
import com.slack.api.util.http.listener.ResponsePrettyPrintingListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class SlackConfig {
    public static final SlackConfig DEFAULT = new SlackConfig(){

        void throwException() {
            throw new UnsupportedOperationException("This config is immutable");
        }

        @Override
        public void setFailOnUnknownProperties(boolean failOnUnknownProperties) {
            this.throwException();
        }

        @Override
        public void setPrettyResponseLoggingEnabled(boolean prettyResponseLoggingEnabled) {
            this.throwException();
        }

        @Override
        public void setLibraryMaintainerMode(boolean libraryMaintainerMode) {
            this.throwException();
        }

        @Override
        public void setTokenExistenceVerificationEnabled(boolean tokenExistenceVerificationEnabled) {
            this.throwException();
        }

        @Override
        public void setHttpClientResponseHandlers(List<HttpResponseListener> httpClientResponseHandlers) {
            this.throwException();
        }

        @Override
        public void setAuditEndpointUrlPrefix(String auditEndpointUrlPrefix) {
            this.throwException();
        }

        @Override
        public void setMethodsEndpointUrlPrefix(String methodsEndpointUrlPrefix) {
            this.throwException();
        }

        @Override
        public void setScimEndpointUrlPrefix(String scimEndpointUrlPrefix) {
            this.throwException();
        }

        @Override
        public void setStatusEndpointUrlPrefix(String statusEndpointUrlPrefix) {
            this.throwException();
        }

        @Override
        public void setLegacyStatusEndpointUrlPrefix(String legacyStatusEndpointUrlPrefix) {
            this.throwException();
        }

        @Override
        public void setMethodsConfig(MethodsConfig methodsConfig) {
            this.throwException();
        }

        @Override
        public void setAuditConfig(AuditConfig auditConfig) {
            this.throwException();
        }

        @Override
        public void setSCIMConfig(SCIMConfig sCIMConfig) {
            this.throwException();
        }

        @Override
        public void setProxyUrl(String proxyUrl) {
            this.throwException();
        }

        @Override
        public void setProxyHeaders(Map<String, String> proxyHeaders) {
            this.throwException();
        }

        @Override
        public void setHttpClientCallTimeoutMillis(Integer httpClientCallTimeoutMillis) {
            this.throwException();
        }

        @Override
        public void setHttpClientWriteTimeoutMillis(Integer httpClientWriteTimeoutMillis) {
            this.throwException();
        }

        @Override
        public void setHttpClientReadTimeoutMillis(Integer httpClientReadTimeoutMillis) {
            this.throwException();
        }
    };
    private Integer httpClientReadTimeoutMillis;
    private Integer httpClientWriteTimeoutMillis;
    private Integer httpClientCallTimeoutMillis;
    private String proxyUrl = SlackConfig.initProxyUrl();
    private Map<String, String> proxyHeaders;
    private boolean prettyResponseLoggingEnabled = false;
    private boolean libraryMaintainerMode = false;
    private boolean failOnUnknownProperties = false;
    private boolean tokenExistenceVerificationEnabled = false;
    private List<HttpResponseListener> httpClientResponseHandlers = new ArrayList<HttpResponseListener>();
    private String auditEndpointUrlPrefix = "https://api.slack.com/audit/v1/";
    private String methodsEndpointUrlPrefix = "https://slack.com/api/";
    private String scimEndpointUrlPrefix = "https://api.slack.com/scim/v1/";
    private String statusEndpointUrlPrefix = "https://status.slack.com/api/v2.0.0/";
    private String legacyStatusEndpointUrlPrefix = "https://status.slack.com/api/v1.0.0/";
    private MethodsConfig methodsConfig = MethodsConfig.DEFAULT_SINGLETON;
    private AuditConfig auditConfig = AuditConfig.DEFAULT_SINGLETON;
    private SCIMConfig sCIMConfig = SCIMConfig.DEFAULT_SINGLETON;

    public SlackConfig() {
        this.getHttpClientResponseHandlers().add(new DetailedLoggingListener());
        this.getHttpClientResponseHandlers().add(new ResponsePrettyPrintingListener());
    }

    private static String initProxyUrl() {
        String host = System.getProperty("http.proxyHost");
        if (host != null) {
            String port = System.getProperty("http.proxyPort");
            if (port != null) {
                return "http://" + host + ":" + port;
            }
            return "http://" + host;
        }
        return null;
    }

    @Generated
    public Integer getHttpClientReadTimeoutMillis() {
        return this.httpClientReadTimeoutMillis;
    }

    @Generated
    public Integer getHttpClientWriteTimeoutMillis() {
        return this.httpClientWriteTimeoutMillis;
    }

    @Generated
    public Integer getHttpClientCallTimeoutMillis() {
        return this.httpClientCallTimeoutMillis;
    }

    @Generated
    public String getProxyUrl() {
        return this.proxyUrl;
    }

    @Generated
    public Map<String, String> getProxyHeaders() {
        return this.proxyHeaders;
    }

    @Generated
    public boolean isPrettyResponseLoggingEnabled() {
        return this.prettyResponseLoggingEnabled;
    }

    @Generated
    public boolean isLibraryMaintainerMode() {
        return this.libraryMaintainerMode;
    }

    @Generated
    public boolean isFailOnUnknownProperties() {
        return this.failOnUnknownProperties;
    }

    @Generated
    public boolean isTokenExistenceVerificationEnabled() {
        return this.tokenExistenceVerificationEnabled;
    }

    @Generated
    public List<HttpResponseListener> getHttpClientResponseHandlers() {
        return this.httpClientResponseHandlers;
    }

    @Generated
    public String getAuditEndpointUrlPrefix() {
        return this.auditEndpointUrlPrefix;
    }

    @Generated
    public String getMethodsEndpointUrlPrefix() {
        return this.methodsEndpointUrlPrefix;
    }

    @Generated
    public String getScimEndpointUrlPrefix() {
        return this.scimEndpointUrlPrefix;
    }

    @Generated
    public String getStatusEndpointUrlPrefix() {
        return this.statusEndpointUrlPrefix;
    }

    @Generated
    public String getLegacyStatusEndpointUrlPrefix() {
        return this.legacyStatusEndpointUrlPrefix;
    }

    @Generated
    public MethodsConfig getMethodsConfig() {
        return this.methodsConfig;
    }

    @Generated
    public AuditConfig getAuditConfig() {
        return this.auditConfig;
    }

    @Generated
    public SCIMConfig getSCIMConfig() {
        return this.sCIMConfig;
    }

    @Generated
    public void setHttpClientReadTimeoutMillis(Integer httpClientReadTimeoutMillis) {
        this.httpClientReadTimeoutMillis = httpClientReadTimeoutMillis;
    }

    @Generated
    public void setHttpClientWriteTimeoutMillis(Integer httpClientWriteTimeoutMillis) {
        this.httpClientWriteTimeoutMillis = httpClientWriteTimeoutMillis;
    }

    @Generated
    public void setHttpClientCallTimeoutMillis(Integer httpClientCallTimeoutMillis) {
        this.httpClientCallTimeoutMillis = httpClientCallTimeoutMillis;
    }

    @Generated
    public void setProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
    }

    @Generated
    public void setProxyHeaders(Map<String, String> proxyHeaders) {
        this.proxyHeaders = proxyHeaders;
    }

    @Generated
    public void setPrettyResponseLoggingEnabled(boolean prettyResponseLoggingEnabled) {
        this.prettyResponseLoggingEnabled = prettyResponseLoggingEnabled;
    }

    @Generated
    public void setLibraryMaintainerMode(boolean libraryMaintainerMode) {
        this.libraryMaintainerMode = libraryMaintainerMode;
    }

    @Generated
    public void setFailOnUnknownProperties(boolean failOnUnknownProperties) {
        this.failOnUnknownProperties = failOnUnknownProperties;
    }

    @Generated
    public void setTokenExistenceVerificationEnabled(boolean tokenExistenceVerificationEnabled) {
        this.tokenExistenceVerificationEnabled = tokenExistenceVerificationEnabled;
    }

    @Generated
    public void setHttpClientResponseHandlers(List<HttpResponseListener> httpClientResponseHandlers) {
        this.httpClientResponseHandlers = httpClientResponseHandlers;
    }

    @Generated
    public void setAuditEndpointUrlPrefix(String auditEndpointUrlPrefix) {
        this.auditEndpointUrlPrefix = auditEndpointUrlPrefix;
    }

    @Generated
    public void setMethodsEndpointUrlPrefix(String methodsEndpointUrlPrefix) {
        this.methodsEndpointUrlPrefix = methodsEndpointUrlPrefix;
    }

    @Generated
    public void setScimEndpointUrlPrefix(String scimEndpointUrlPrefix) {
        this.scimEndpointUrlPrefix = scimEndpointUrlPrefix;
    }

    @Generated
    public void setStatusEndpointUrlPrefix(String statusEndpointUrlPrefix) {
        this.statusEndpointUrlPrefix = statusEndpointUrlPrefix;
    }

    @Generated
    public void setLegacyStatusEndpointUrlPrefix(String legacyStatusEndpointUrlPrefix) {
        this.legacyStatusEndpointUrlPrefix = legacyStatusEndpointUrlPrefix;
    }

    @Generated
    public void setMethodsConfig(MethodsConfig methodsConfig) {
        this.methodsConfig = methodsConfig;
    }

    @Generated
    public void setAuditConfig(AuditConfig auditConfig) {
        this.auditConfig = auditConfig;
    }

    @Generated
    public void setSCIMConfig(SCIMConfig sCIMConfig) {
        this.sCIMConfig = sCIMConfig;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SlackConfig)) {
            return false;
        }
        SlackConfig other = (SlackConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPrettyResponseLoggingEnabled() != other.isPrettyResponseLoggingEnabled()) {
            return false;
        }
        if (this.isLibraryMaintainerMode() != other.isLibraryMaintainerMode()) {
            return false;
        }
        if (this.isFailOnUnknownProperties() != other.isFailOnUnknownProperties()) {
            return false;
        }
        if (this.isTokenExistenceVerificationEnabled() != other.isTokenExistenceVerificationEnabled()) {
            return false;
        }
        Integer this$httpClientReadTimeoutMillis = this.getHttpClientReadTimeoutMillis();
        Integer other$httpClientReadTimeoutMillis = other.getHttpClientReadTimeoutMillis();
        if (this$httpClientReadTimeoutMillis == null ? other$httpClientReadTimeoutMillis != null : !((Object)this$httpClientReadTimeoutMillis).equals(other$httpClientReadTimeoutMillis)) {
            return false;
        }
        Integer this$httpClientWriteTimeoutMillis = this.getHttpClientWriteTimeoutMillis();
        Integer other$httpClientWriteTimeoutMillis = other.getHttpClientWriteTimeoutMillis();
        if (this$httpClientWriteTimeoutMillis == null ? other$httpClientWriteTimeoutMillis != null : !((Object)this$httpClientWriteTimeoutMillis).equals(other$httpClientWriteTimeoutMillis)) {
            return false;
        }
        Integer this$httpClientCallTimeoutMillis = this.getHttpClientCallTimeoutMillis();
        Integer other$httpClientCallTimeoutMillis = other.getHttpClientCallTimeoutMillis();
        if (this$httpClientCallTimeoutMillis == null ? other$httpClientCallTimeoutMillis != null : !((Object)this$httpClientCallTimeoutMillis).equals(other$httpClientCallTimeoutMillis)) {
            return false;
        }
        String this$proxyUrl = this.getProxyUrl();
        String other$proxyUrl = other.getProxyUrl();
        if (this$proxyUrl == null ? other$proxyUrl != null : !this$proxyUrl.equals(other$proxyUrl)) {
            return false;
        }
        Map<String, String> this$proxyHeaders = this.getProxyHeaders();
        Map<String, String> other$proxyHeaders = other.getProxyHeaders();
        if (this$proxyHeaders == null ? other$proxyHeaders != null : !((Object)this$proxyHeaders).equals(other$proxyHeaders)) {
            return false;
        }
        List<HttpResponseListener> this$httpClientResponseHandlers = this.getHttpClientResponseHandlers();
        List<HttpResponseListener> other$httpClientResponseHandlers = other.getHttpClientResponseHandlers();
        if (this$httpClientResponseHandlers == null ? other$httpClientResponseHandlers != null : !((Object)this$httpClientResponseHandlers).equals(other$httpClientResponseHandlers)) {
            return false;
        }
        String this$auditEndpointUrlPrefix = this.getAuditEndpointUrlPrefix();
        String other$auditEndpointUrlPrefix = other.getAuditEndpointUrlPrefix();
        if (this$auditEndpointUrlPrefix == null ? other$auditEndpointUrlPrefix != null : !this$auditEndpointUrlPrefix.equals(other$auditEndpointUrlPrefix)) {
            return false;
        }
        String this$methodsEndpointUrlPrefix = this.getMethodsEndpointUrlPrefix();
        String other$methodsEndpointUrlPrefix = other.getMethodsEndpointUrlPrefix();
        if (this$methodsEndpointUrlPrefix == null ? other$methodsEndpointUrlPrefix != null : !this$methodsEndpointUrlPrefix.equals(other$methodsEndpointUrlPrefix)) {
            return false;
        }
        String this$scimEndpointUrlPrefix = this.getScimEndpointUrlPrefix();
        String other$scimEndpointUrlPrefix = other.getScimEndpointUrlPrefix();
        if (this$scimEndpointUrlPrefix == null ? other$scimEndpointUrlPrefix != null : !this$scimEndpointUrlPrefix.equals(other$scimEndpointUrlPrefix)) {
            return false;
        }
        String this$statusEndpointUrlPrefix = this.getStatusEndpointUrlPrefix();
        String other$statusEndpointUrlPrefix = other.getStatusEndpointUrlPrefix();
        if (this$statusEndpointUrlPrefix == null ? other$statusEndpointUrlPrefix != null : !this$statusEndpointUrlPrefix.equals(other$statusEndpointUrlPrefix)) {
            return false;
        }
        String this$legacyStatusEndpointUrlPrefix = this.getLegacyStatusEndpointUrlPrefix();
        String other$legacyStatusEndpointUrlPrefix = other.getLegacyStatusEndpointUrlPrefix();
        if (this$legacyStatusEndpointUrlPrefix == null ? other$legacyStatusEndpointUrlPrefix != null : !this$legacyStatusEndpointUrlPrefix.equals(other$legacyStatusEndpointUrlPrefix)) {
            return false;
        }
        MethodsConfig this$methodsConfig = this.getMethodsConfig();
        MethodsConfig other$methodsConfig = other.getMethodsConfig();
        if (this$methodsConfig == null ? other$methodsConfig != null : !((Object)this$methodsConfig).equals(other$methodsConfig)) {
            return false;
        }
        AuditConfig this$auditConfig = this.getAuditConfig();
        AuditConfig other$auditConfig = other.getAuditConfig();
        if (this$auditConfig == null ? other$auditConfig != null : !((Object)this$auditConfig).equals(other$auditConfig)) {
            return false;
        }
        SCIMConfig this$sCIMConfig = this.getSCIMConfig();
        SCIMConfig other$sCIMConfig = other.getSCIMConfig();
        return !(this$sCIMConfig == null ? other$sCIMConfig != null : !((Object)this$sCIMConfig).equals(other$sCIMConfig));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SlackConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPrettyResponseLoggingEnabled() ? 79 : 97);
        result = result * 59 + (this.isLibraryMaintainerMode() ? 79 : 97);
        result = result * 59 + (this.isFailOnUnknownProperties() ? 79 : 97);
        result = result * 59 + (this.isTokenExistenceVerificationEnabled() ? 79 : 97);
        Integer $httpClientReadTimeoutMillis = this.getHttpClientReadTimeoutMillis();
        result = result * 59 + ($httpClientReadTimeoutMillis == null ? 43 : ((Object)$httpClientReadTimeoutMillis).hashCode());
        Integer $httpClientWriteTimeoutMillis = this.getHttpClientWriteTimeoutMillis();
        result = result * 59 + ($httpClientWriteTimeoutMillis == null ? 43 : ((Object)$httpClientWriteTimeoutMillis).hashCode());
        Integer $httpClientCallTimeoutMillis = this.getHttpClientCallTimeoutMillis();
        result = result * 59 + ($httpClientCallTimeoutMillis == null ? 43 : ((Object)$httpClientCallTimeoutMillis).hashCode());
        String $proxyUrl = this.getProxyUrl();
        result = result * 59 + ($proxyUrl == null ? 43 : $proxyUrl.hashCode());
        Map<String, String> $proxyHeaders = this.getProxyHeaders();
        result = result * 59 + ($proxyHeaders == null ? 43 : ((Object)$proxyHeaders).hashCode());
        List<HttpResponseListener> $httpClientResponseHandlers = this.getHttpClientResponseHandlers();
        result = result * 59 + ($httpClientResponseHandlers == null ? 43 : ((Object)$httpClientResponseHandlers).hashCode());
        String $auditEndpointUrlPrefix = this.getAuditEndpointUrlPrefix();
        result = result * 59 + ($auditEndpointUrlPrefix == null ? 43 : $auditEndpointUrlPrefix.hashCode());
        String $methodsEndpointUrlPrefix = this.getMethodsEndpointUrlPrefix();
        result = result * 59 + ($methodsEndpointUrlPrefix == null ? 43 : $methodsEndpointUrlPrefix.hashCode());
        String $scimEndpointUrlPrefix = this.getScimEndpointUrlPrefix();
        result = result * 59 + ($scimEndpointUrlPrefix == null ? 43 : $scimEndpointUrlPrefix.hashCode());
        String $statusEndpointUrlPrefix = this.getStatusEndpointUrlPrefix();
        result = result * 59 + ($statusEndpointUrlPrefix == null ? 43 : $statusEndpointUrlPrefix.hashCode());
        String $legacyStatusEndpointUrlPrefix = this.getLegacyStatusEndpointUrlPrefix();
        result = result * 59 + ($legacyStatusEndpointUrlPrefix == null ? 43 : $legacyStatusEndpointUrlPrefix.hashCode());
        MethodsConfig $methodsConfig = this.getMethodsConfig();
        result = result * 59 + ($methodsConfig == null ? 43 : ((Object)$methodsConfig).hashCode());
        AuditConfig $auditConfig = this.getAuditConfig();
        result = result * 59 + ($auditConfig == null ? 43 : ((Object)$auditConfig).hashCode());
        SCIMConfig $sCIMConfig = this.getSCIMConfig();
        result = result * 59 + ($sCIMConfig == null ? 43 : ((Object)$sCIMConfig).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SlackConfig(httpClientReadTimeoutMillis=" + this.getHttpClientReadTimeoutMillis() + ", httpClientWriteTimeoutMillis=" + this.getHttpClientWriteTimeoutMillis() + ", httpClientCallTimeoutMillis=" + this.getHttpClientCallTimeoutMillis() + ", proxyUrl=" + this.getProxyUrl() + ", proxyHeaders=" + this.getProxyHeaders() + ", prettyResponseLoggingEnabled=" + this.isPrettyResponseLoggingEnabled() + ", libraryMaintainerMode=" + this.isLibraryMaintainerMode() + ", failOnUnknownProperties=" + this.isFailOnUnknownProperties() + ", tokenExistenceVerificationEnabled=" + this.isTokenExistenceVerificationEnabled() + ", httpClientResponseHandlers=" + this.getHttpClientResponseHandlers() + ", auditEndpointUrlPrefix=" + this.getAuditEndpointUrlPrefix() + ", methodsEndpointUrlPrefix=" + this.getMethodsEndpointUrlPrefix() + ", scimEndpointUrlPrefix=" + this.getScimEndpointUrlPrefix() + ", statusEndpointUrlPrefix=" + this.getStatusEndpointUrlPrefix() + ", legacyStatusEndpointUrlPrefix=" + this.getLegacyStatusEndpointUrlPrefix() + ", methodsConfig=" + this.getMethodsConfig() + ", auditConfig=" + this.getAuditConfig() + ", sCIMConfig=" + this.getSCIMConfig() + ")";
    }
}

