/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.methods.impl;

import com.slack.api.methods.MethodsConfig;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;

public class ThreadPools {
    private static final ConcurrentMap<String, ExecutorService> ALL_DEFAULT = new ConcurrentHashMap<String, ExecutorService>();
    private static final ConcurrentMap<String, ConcurrentMap<String, ExecutorService>> TEAM_CUSTOM = new ConcurrentHashMap<String, ConcurrentMap<String, ExecutorService>>();

    private ThreadPools() {
    }

    public static ExecutorService getDefault(MethodsConfig config) {
        return ThreadPools.getOrCreate(config, null);
    }

    public static ExecutorService getOrCreate(MethodsConfig config, String teamId) {
        Integer customPoolSize;
        String executorName = config.getExecutorName();
        Integer n = customPoolSize = teamId != null ? config.getCustomThreadPoolSizes().get(teamId) : null;
        if (customPoolSize != null) {
            ExecutorService teamExecutor;
            ConcurrentHashMap<String, ExecutorService> allTeams = (ConcurrentHashMap<String, ExecutorService>)TEAM_CUSTOM.get(executorName);
            if (allTeams == null) {
                allTeams = new ConcurrentHashMap<String, ExecutorService>();
                TEAM_CUSTOM.put(executorName, allTeams);
            }
            if ((teamExecutor = (ExecutorService)allTeams.get(teamId)) == null) {
                String threadGroupName = "slack-methods-" + config.getExecutorName() + "-" + teamId;
                teamExecutor = config.getExecutorServiceProvider().createThreadPoolExecutor(threadGroupName, customPoolSize.intValue());
                allTeams.put(teamId, teamExecutor);
            }
            return teamExecutor;
        }
        ExecutorService defaultExecutor = (ExecutorService)ALL_DEFAULT.get(executorName);
        if (defaultExecutor == null) {
            String threadGroupName = "slack-methods-" + config.getExecutorName();
            int poolSize = config.getDefaultThreadPoolSize();
            defaultExecutor = config.getExecutorServiceProvider().createThreadPoolExecutor(threadGroupName, poolSize);
            ALL_DEFAULT.put(config.getExecutorName(), defaultExecutor);
        }
        return defaultExecutor;
    }
}

