/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.util.http;

import java.io.IOException;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAgentInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(UserAgentInterceptor.class);
    private final String userAgent;

    public UserAgentInterceptor(Map<String, String> additionalInfo) {
        this.userAgent = UserAgentInterceptor.buildDefaultUserAgent(additionalInfo);
    }

    public static String buildDefaultUserAgent(Map<String, String> additionalInfo) {
        String libraryVersion = UserAgentInterceptor.loadLibraryVersion();
        String library = "slack-api-client/" + libraryVersion + "";
        String jvm = "" + System.getProperty("java.vm.name") + "/" + System.getProperty("java.version") + "";
        String os = "" + System.getProperty("os.name") + "/" + System.getProperty("os.version") + "";
        String lastPart = "";
        for (Map.Entry<String, String> each : additionalInfo.entrySet()) {
            lastPart = lastPart + " " + each.getKey() + "/" + each.getValue() + ";";
        }
        return library + "; " + jvm + "; " + os + ";" + lastPart;
    }

    private static String loadLibraryVersion() {
        String artifactId = "slack-api-client";
        String libraryVersion = "unknown";
        try {
            String parsedVersion = UserAgentInterceptor.class.getPackage().getImplementationVersion();
            if (parsedVersion != null) {
                libraryVersion = parsedVersion;
            }
        }
        catch (Exception e) {
            log.info("Failed to parse {}.jar to fetch the library version", (Object)artifactId);
        }
        return libraryVersion;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request().newBuilder().header("User-Agent", this.userAgent).build();
        return chain.proceed(request);
    }
}

