/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt;

import com.slack.api.Slack;
import com.slack.api.SlackConfig;
import com.slack.api.bolt.meta.BoltLibraryVersion;
import com.slack.api.bolt.service.builtin.oauth.view.OAuthInstallPageRenderer;
import com.slack.api.bolt.service.builtin.oauth.view.OAuthRedirectUriPageRenderer;
import com.slack.api.bolt.service.builtin.oauth.view.default_impl.OAuthDefaultInstallPageRenderer;
import com.slack.api.bolt.service.builtin.oauth.view.default_impl.OAuthDefaultRedirectUriPageRenderer;
import com.slack.api.util.http.SlackHttpClient;
import java.util.HashMap;
import java.util.Optional;
import lombok.Generated;

public class AppConfig {
    private transient Slack slack;
    private String singleTeamBotToken;
    private String signingSecret;
    @Deprecated
    private String verificationToken;
    private boolean oAuthInstallPathEnabled;
    @Deprecated
    private boolean oAuthStartEnabled;
    private boolean oAuthRedirectUriPathEnabled;
    @Deprecated
    private boolean oAuthCallbackEnabled;
    private boolean oAuthInstallPageRenderingEnabled;
    private transient OAuthInstallPageRenderer oAuthInstallPageRenderer;
    private transient OAuthRedirectUriPageRenderer oAuthRedirectUriPageRenderer;
    private boolean authTestCacheEnabled;
    private long authTestCacheExpirationMillis;
    private boolean classicAppPermissionsEnabled;
    private int threadPoolSize;
    private String clientId;
    private String clientSecret;
    private String redirectUri;
    private String scope;
    private String userScope;
    private String appPath;
    private static final String DEFAULT_OAUTH_INSTALL_PATH = "start";
    @Deprecated
    private String oauthStartPath;
    private String oauthInstallPath;
    private static final String DEFAULT_OAUTH_REDIRECT_URI_PATH = "callback";
    @Deprecated
    private String oauthCallbackPath;
    private String oauthRedirectUriPath;
    private String oauthCancellationUrl;
    private String oauthCompletionUrl;
    private boolean alwaysRequestUserTokenNeeded;
    private boolean appInitializersEnabled;

    private static SlackHttpClient buildSlackHttpClient() {
        HashMap<String, String> userAgentCustomInfo = new HashMap<String, String>();
        userAgentCustomInfo.put("bolt", BoltLibraryVersion.get());
        SlackHttpClient client = new SlackHttpClient(SlackConfig.DEFAULT, userAgentCustomInfo);
        return client;
    }

    public boolean isDistributedApp() {
        return this.clientId != null && this.clientSecret != null;
    }

    public boolean isOAuthInstallPathEnabled() {
        return this.oAuthInstallPathEnabled || this.oAuthStartEnabled;
    }

    @Deprecated
    public boolean isOAuthStartEnabled() {
        return this.isOAuthInstallPathEnabled();
    }

    @Deprecated
    public void setOAuthStartEnabled(boolean enabled) {
        this.setOAuthInstallPathEnabled(enabled);
    }

    public boolean isOAuthRedirectUriPathEnabled() {
        return this.oAuthRedirectUriPathEnabled || this.oAuthCallbackEnabled;
    }

    @Deprecated
    public boolean isOAuthCallbackEnabled() {
        return this.isOAuthRedirectUriPathEnabled();
    }

    @Deprecated
    public void setOAuthCallbackEnabled(boolean enabled) {
        this.setOAuthRedirectUriPathEnabled(enabled);
    }

    @Deprecated
    public String getOauthStartRequestURI() {
        return this.getOauthInstallRequestURI();
    }

    public String getOauthInstallRequestURI() {
        if (this.appPath == null) {
            return this.getOauthInstallPath();
        }
        return this.appPath + this.getOauthInstallPath();
    }

    @Deprecated
    public String getOauthCallbackRequestURI() {
        return this.getOauthRedirectUriRequestURI();
    }

    public String getOauthRedirectUriRequestURI() {
        if (this.appPath == null) {
            return this.getOauthRedirectUriPath();
        }
        return this.appPath + this.getOauthRedirectUriPath();
    }

    @Deprecated
    public String getOauthStartPath() {
        return this.getOauthInstallPath();
    }

    @Deprecated
    public void setOauthStartPath(String oauthStartPath) {
        this.setOauthInstallPath(oauthStartPath);
    }

    public String getOauthInstallPath() {
        String path = this.oauthInstallPath;
        String legacyPath = this.oauthStartPath;
        if (path != null && !path.equals(DEFAULT_OAUTH_INSTALL_PATH) && legacyPath.equals(DEFAULT_OAUTH_INSTALL_PATH)) {
            return path;
        }
        return legacyPath;
    }

    public void setOauthInstallPath(String oauthInstallPath) {
        this.oauthInstallPath = oauthInstallPath;
        this.oAuthInstallPathEnabled = oauthInstallPath != null;
    }

    @Deprecated
    public String getOauthCallbackPath() {
        return this.getOauthRedirectUriPath();
    }

    @Deprecated
    public void setOauthCallbackPath(String oauthCallbackPath) {
        this.setOauthRedirectUriPath(oauthCallbackPath);
    }

    public String getOauthRedirectUriPath() {
        String path = this.oauthRedirectUriPath;
        String legacyPath = this.oauthCallbackPath;
        if (path != null && !path.equals(DEFAULT_OAUTH_REDIRECT_URI_PATH) && legacyPath.equals(DEFAULT_OAUTH_REDIRECT_URI_PATH)) {
            return path;
        }
        return legacyPath;
    }

    public void setOauthRedirectUriPath(String oauthRedirectUriPath) {
        this.oauthRedirectUriPath = oauthRedirectUriPath;
        this.oAuthRedirectUriPathEnabled = oauthRedirectUriPath != null;
    }

    @Generated
    private static Slack $default$slack() {
        return Slack.getInstance((SlackConfig)SlackConfig.DEFAULT, (SlackHttpClient)AppConfig.buildSlackHttpClient());
    }

    @Generated
    private static String $default$singleTeamBotToken() {
        return System.getenv("SLACK_BOT_TOKEN");
    }

    @Generated
    private static String $default$signingSecret() {
        return System.getenv("SLACK_SIGNING_SECRET");
    }

    @Generated
    private static String $default$verificationToken() {
        return System.getenv("SLACK_VERIFICATION_TOKEN");
    }

    @Generated
    private static boolean $default$oAuthInstallPathEnabled() {
        return false;
    }

    @Generated
    private static boolean $default$oAuthStartEnabled() {
        return false;
    }

    @Generated
    private static boolean $default$oAuthRedirectUriPathEnabled() {
        return false;
    }

    @Generated
    private static boolean $default$oAuthCallbackEnabled() {
        return false;
    }

    @Generated
    private static boolean $default$oAuthInstallPageRenderingEnabled() {
        return true;
    }

    @Generated
    private static OAuthInstallPageRenderer $default$oAuthInstallPageRenderer() {
        return new OAuthDefaultInstallPageRenderer();
    }

    @Generated
    private static OAuthRedirectUriPageRenderer $default$oAuthRedirectUriPageRenderer() {
        return new OAuthDefaultRedirectUriPageRenderer();
    }

    @Generated
    private static boolean $default$authTestCacheEnabled() {
        return false;
    }

    @Generated
    private static long $default$authTestCacheExpirationMillis() {
        return 600000L;
    }

    @Generated
    private static boolean $default$classicAppPermissionsEnabled() {
        return false;
    }

    @Generated
    private static int $default$threadPoolSize() {
        return 10;
    }

    @Generated
    private static String $default$clientId() {
        return Optional.ofNullable(System.getenv("SLACK_CLIENT_ID")).orElse(System.getenv("SLACK_APP_CLIENT_ID"));
    }

    @Generated
    private static String $default$clientSecret() {
        return Optional.ofNullable(System.getenv("SLACK_CLIENT_SECRET")).orElse(System.getenv("SLACK_APP_CLIENT_SECRET"));
    }

    @Generated
    private static String $default$redirectUri() {
        return Optional.ofNullable(System.getenv("SLACK_REDIRECT_URI")).orElse(System.getenv("SLACK_APP_REDIRECT_URI"));
    }

    @Generated
    private static String $default$scope() {
        return Optional.ofNullable(System.getenv("SLACK_SCOPES")).orElse(System.getenv("SLACK_APP_SCOPE"));
    }

    @Generated
    private static String $default$userScope() {
        return Optional.ofNullable(System.getenv("SLACK_USER_SCOPES")).orElse(System.getenv("SLACK_APP_USER_SCOPE"));
    }

    @Generated
    private static String $default$oauthStartPath() {
        return Optional.ofNullable(System.getenv("SLACK_INSTALL_PATH")).orElse(Optional.ofNullable(System.getenv("SLACK_APP_OAUTH_START_PATH")).orElse(DEFAULT_OAUTH_INSTALL_PATH));
    }

    @Generated
    private static String $default$oauthInstallPath() {
        return Optional.ofNullable(System.getenv("SLACK_INSTALL_PATH")).orElse(Optional.ofNullable(System.getenv("SLACK_APP_OAUTH_START_PATH")).orElse(DEFAULT_OAUTH_INSTALL_PATH));
    }

    @Generated
    private static String $default$oauthCallbackPath() {
        return Optional.ofNullable(System.getenv("SLACK_REDIRECT_URI_PATH")).orElse(Optional.ofNullable(System.getenv("SLACK_APP_OAUTH_CALLBACK_PATH")).orElse(DEFAULT_OAUTH_REDIRECT_URI_PATH));
    }

    @Generated
    private static String $default$oauthRedirectUriPath() {
        return Optional.ofNullable(System.getenv("SLACK_REDIRECT_URI_PATH")).orElse(Optional.ofNullable(System.getenv("SLACK_APP_OAUTH_CALLBACK_PATH")).orElse(DEFAULT_OAUTH_REDIRECT_URI_PATH));
    }

    @Generated
    private static String $default$oauthCancellationUrl() {
        return Optional.ofNullable(System.getenv("SLACK_OAUTH_CANCELLATION_URL")).orElse(System.getenv("SLACK_APP_OAUTH_CANCELLATION_URL"));
    }

    @Generated
    private static String $default$oauthCompletionUrl() {
        return Optional.ofNullable(System.getenv("SLACK_OAUTH_COMPLETION_URL")).orElse(System.getenv("SLACK_APP_OAUTH_COMPLETION_URL"));
    }

    @Generated
    private static boolean $default$alwaysRequestUserTokenNeeded() {
        return false;
    }

    @Generated
    private static boolean $default$appInitializersEnabled() {
        return true;
    }

    @Generated
    public static AppConfigBuilder builder() {
        return new AppConfigBuilder();
    }

    @Generated
    public AppConfigBuilder toBuilder() {
        return new AppConfigBuilder().slack(this.slack).singleTeamBotToken(this.singleTeamBotToken).signingSecret(this.signingSecret).verificationToken(this.verificationToken).oAuthInstallPathEnabled(this.oAuthInstallPathEnabled).oAuthStartEnabled(this.oAuthStartEnabled).oAuthRedirectUriPathEnabled(this.oAuthRedirectUriPathEnabled).oAuthCallbackEnabled(this.oAuthCallbackEnabled).oAuthInstallPageRenderingEnabled(this.oAuthInstallPageRenderingEnabled).oAuthInstallPageRenderer(this.oAuthInstallPageRenderer).oAuthRedirectUriPageRenderer(this.oAuthRedirectUriPageRenderer).authTestCacheEnabled(this.authTestCacheEnabled).authTestCacheExpirationMillis(this.authTestCacheExpirationMillis).classicAppPermissionsEnabled(this.classicAppPermissionsEnabled).threadPoolSize(this.threadPoolSize).clientId(this.clientId).clientSecret(this.clientSecret).redirectUri(this.redirectUri).scope(this.scope).userScope(this.userScope).appPath(this.appPath).oauthStartPath(this.oauthStartPath).oauthInstallPath(this.oauthInstallPath).oauthCallbackPath(this.oauthCallbackPath).oauthRedirectUriPath(this.oauthRedirectUriPath).oauthCancellationUrl(this.oauthCancellationUrl).oauthCompletionUrl(this.oauthCompletionUrl).alwaysRequestUserTokenNeeded(this.alwaysRequestUserTokenNeeded).appInitializersEnabled(this.appInitializersEnabled);
    }

    @Generated
    public Slack getSlack() {
        return this.slack;
    }

    @Generated
    public String getSingleTeamBotToken() {
        return this.singleTeamBotToken;
    }

    @Generated
    public String getSigningSecret() {
        return this.signingSecret;
    }

    @Deprecated
    @Generated
    public String getVerificationToken() {
        return this.verificationToken;
    }

    @Generated
    public boolean isOAuthInstallPageRenderingEnabled() {
        return this.oAuthInstallPageRenderingEnabled;
    }

    @Generated
    public OAuthInstallPageRenderer getOAuthInstallPageRenderer() {
        return this.oAuthInstallPageRenderer;
    }

    @Generated
    public OAuthRedirectUriPageRenderer getOAuthRedirectUriPageRenderer() {
        return this.oAuthRedirectUriPageRenderer;
    }

    @Generated
    public boolean isAuthTestCacheEnabled() {
        return this.authTestCacheEnabled;
    }

    @Generated
    public long getAuthTestCacheExpirationMillis() {
        return this.authTestCacheExpirationMillis;
    }

    @Generated
    public boolean isClassicAppPermissionsEnabled() {
        return this.classicAppPermissionsEnabled;
    }

    @Generated
    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public String getRedirectUri() {
        return this.redirectUri;
    }

    @Generated
    public String getScope() {
        return this.scope;
    }

    @Generated
    public String getUserScope() {
        return this.userScope;
    }

    @Generated
    public String getAppPath() {
        return this.appPath;
    }

    @Generated
    public String getOauthCancellationUrl() {
        return this.oauthCancellationUrl;
    }

    @Generated
    public String getOauthCompletionUrl() {
        return this.oauthCompletionUrl;
    }

    @Generated
    public boolean isAlwaysRequestUserTokenNeeded() {
        return this.alwaysRequestUserTokenNeeded;
    }

    @Generated
    public boolean isAppInitializersEnabled() {
        return this.appInitializersEnabled;
    }

    @Generated
    public void setSlack(Slack slack) {
        this.slack = slack;
    }

    @Generated
    public void setSingleTeamBotToken(String singleTeamBotToken) {
        this.singleTeamBotToken = singleTeamBotToken;
    }

    @Generated
    public void setSigningSecret(String signingSecret) {
        this.signingSecret = signingSecret;
    }

    @Deprecated
    @Generated
    public void setVerificationToken(String verificationToken) {
        this.verificationToken = verificationToken;
    }

    @Generated
    public void setOAuthInstallPathEnabled(boolean oAuthInstallPathEnabled) {
        this.oAuthInstallPathEnabled = oAuthInstallPathEnabled;
    }

    @Generated
    public void setOAuthRedirectUriPathEnabled(boolean oAuthRedirectUriPathEnabled) {
        this.oAuthRedirectUriPathEnabled = oAuthRedirectUriPathEnabled;
    }

    @Generated
    public void setOAuthInstallPageRenderingEnabled(boolean oAuthInstallPageRenderingEnabled) {
        this.oAuthInstallPageRenderingEnabled = oAuthInstallPageRenderingEnabled;
    }

    @Generated
    public void setOAuthInstallPageRenderer(OAuthInstallPageRenderer oAuthInstallPageRenderer) {
        this.oAuthInstallPageRenderer = oAuthInstallPageRenderer;
    }

    @Generated
    public void setOAuthRedirectUriPageRenderer(OAuthRedirectUriPageRenderer oAuthRedirectUriPageRenderer) {
        this.oAuthRedirectUriPageRenderer = oAuthRedirectUriPageRenderer;
    }

    @Generated
    public void setAuthTestCacheEnabled(boolean authTestCacheEnabled) {
        this.authTestCacheEnabled = authTestCacheEnabled;
    }

    @Generated
    public void setAuthTestCacheExpirationMillis(long authTestCacheExpirationMillis) {
        this.authTestCacheExpirationMillis = authTestCacheExpirationMillis;
    }

    @Generated
    public void setClassicAppPermissionsEnabled(boolean classicAppPermissionsEnabled) {
        this.classicAppPermissionsEnabled = classicAppPermissionsEnabled;
    }

    @Generated
    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    @Generated
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Generated
    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    @Generated
    public void setScope(String scope) {
        this.scope = scope;
    }

    @Generated
    public void setUserScope(String userScope) {
        this.userScope = userScope;
    }

    @Generated
    public void setAppPath(String appPath) {
        this.appPath = appPath;
    }

    @Generated
    public void setOauthCancellationUrl(String oauthCancellationUrl) {
        this.oauthCancellationUrl = oauthCancellationUrl;
    }

    @Generated
    public void setOauthCompletionUrl(String oauthCompletionUrl) {
        this.oauthCompletionUrl = oauthCompletionUrl;
    }

    @Generated
    public void setAlwaysRequestUserTokenNeeded(boolean alwaysRequestUserTokenNeeded) {
        this.alwaysRequestUserTokenNeeded = alwaysRequestUserTokenNeeded;
    }

    @Generated
    public void setAppInitializersEnabled(boolean appInitializersEnabled) {
        this.appInitializersEnabled = appInitializersEnabled;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppConfig)) {
            return false;
        }
        AppConfig other = (AppConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOAuthInstallPathEnabled() != other.isOAuthInstallPathEnabled()) {
            return false;
        }
        if (this.isOAuthStartEnabled() != other.isOAuthStartEnabled()) {
            return false;
        }
        if (this.isOAuthRedirectUriPathEnabled() != other.isOAuthRedirectUriPathEnabled()) {
            return false;
        }
        if (this.isOAuthCallbackEnabled() != other.isOAuthCallbackEnabled()) {
            return false;
        }
        if (this.isOAuthInstallPageRenderingEnabled() != other.isOAuthInstallPageRenderingEnabled()) {
            return false;
        }
        if (this.isAuthTestCacheEnabled() != other.isAuthTestCacheEnabled()) {
            return false;
        }
        if (this.getAuthTestCacheExpirationMillis() != other.getAuthTestCacheExpirationMillis()) {
            return false;
        }
        if (this.isClassicAppPermissionsEnabled() != other.isClassicAppPermissionsEnabled()) {
            return false;
        }
        if (this.getThreadPoolSize() != other.getThreadPoolSize()) {
            return false;
        }
        if (this.isAlwaysRequestUserTokenNeeded() != other.isAlwaysRequestUserTokenNeeded()) {
            return false;
        }
        if (this.isAppInitializersEnabled() != other.isAppInitializersEnabled()) {
            return false;
        }
        String this$singleTeamBotToken = this.getSingleTeamBotToken();
        String other$singleTeamBotToken = other.getSingleTeamBotToken();
        if (this$singleTeamBotToken == null ? other$singleTeamBotToken != null : !this$singleTeamBotToken.equals(other$singleTeamBotToken)) {
            return false;
        }
        String this$signingSecret = this.getSigningSecret();
        String other$signingSecret = other.getSigningSecret();
        if (this$signingSecret == null ? other$signingSecret != null : !this$signingSecret.equals(other$signingSecret)) {
            return false;
        }
        String this$verificationToken = this.getVerificationToken();
        String other$verificationToken = other.getVerificationToken();
        if (this$verificationToken == null ? other$verificationToken != null : !this$verificationToken.equals(other$verificationToken)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$redirectUri = this.getRedirectUri();
        String other$redirectUri = other.getRedirectUri();
        if (this$redirectUri == null ? other$redirectUri != null : !this$redirectUri.equals(other$redirectUri)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$userScope = this.getUserScope();
        String other$userScope = other.getUserScope();
        if (this$userScope == null ? other$userScope != null : !this$userScope.equals(other$userScope)) {
            return false;
        }
        String this$appPath = this.getAppPath();
        String other$appPath = other.getAppPath();
        if (this$appPath == null ? other$appPath != null : !this$appPath.equals(other$appPath)) {
            return false;
        }
        String this$oauthStartPath = this.getOauthStartPath();
        String other$oauthStartPath = other.getOauthStartPath();
        if (this$oauthStartPath == null ? other$oauthStartPath != null : !this$oauthStartPath.equals(other$oauthStartPath)) {
            return false;
        }
        String this$oauthInstallPath = this.getOauthInstallPath();
        String other$oauthInstallPath = other.getOauthInstallPath();
        if (this$oauthInstallPath == null ? other$oauthInstallPath != null : !this$oauthInstallPath.equals(other$oauthInstallPath)) {
            return false;
        }
        String this$oauthCallbackPath = this.getOauthCallbackPath();
        String other$oauthCallbackPath = other.getOauthCallbackPath();
        if (this$oauthCallbackPath == null ? other$oauthCallbackPath != null : !this$oauthCallbackPath.equals(other$oauthCallbackPath)) {
            return false;
        }
        String this$oauthRedirectUriPath = this.getOauthRedirectUriPath();
        String other$oauthRedirectUriPath = other.getOauthRedirectUriPath();
        if (this$oauthRedirectUriPath == null ? other$oauthRedirectUriPath != null : !this$oauthRedirectUriPath.equals(other$oauthRedirectUriPath)) {
            return false;
        }
        String this$oauthCancellationUrl = this.getOauthCancellationUrl();
        String other$oauthCancellationUrl = other.getOauthCancellationUrl();
        if (this$oauthCancellationUrl == null ? other$oauthCancellationUrl != null : !this$oauthCancellationUrl.equals(other$oauthCancellationUrl)) {
            return false;
        }
        String this$oauthCompletionUrl = this.getOauthCompletionUrl();
        String other$oauthCompletionUrl = other.getOauthCompletionUrl();
        return !(this$oauthCompletionUrl == null ? other$oauthCompletionUrl != null : !this$oauthCompletionUrl.equals(other$oauthCompletionUrl));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AppConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOAuthInstallPathEnabled() ? 79 : 97);
        result = result * 59 + (this.isOAuthStartEnabled() ? 79 : 97);
        result = result * 59 + (this.isOAuthRedirectUriPathEnabled() ? 79 : 97);
        result = result * 59 + (this.isOAuthCallbackEnabled() ? 79 : 97);
        result = result * 59 + (this.isOAuthInstallPageRenderingEnabled() ? 79 : 97);
        result = result * 59 + (this.isAuthTestCacheEnabled() ? 79 : 97);
        long $authTestCacheExpirationMillis = this.getAuthTestCacheExpirationMillis();
        result = result * 59 + (int)($authTestCacheExpirationMillis >>> 32 ^ $authTestCacheExpirationMillis);
        result = result * 59 + (this.isClassicAppPermissionsEnabled() ? 79 : 97);
        result = result * 59 + this.getThreadPoolSize();
        result = result * 59 + (this.isAlwaysRequestUserTokenNeeded() ? 79 : 97);
        result = result * 59 + (this.isAppInitializersEnabled() ? 79 : 97);
        String $singleTeamBotToken = this.getSingleTeamBotToken();
        result = result * 59 + ($singleTeamBotToken == null ? 43 : $singleTeamBotToken.hashCode());
        String $signingSecret = this.getSigningSecret();
        result = result * 59 + ($signingSecret == null ? 43 : $signingSecret.hashCode());
        String $verificationToken = this.getVerificationToken();
        result = result * 59 + ($verificationToken == null ? 43 : $verificationToken.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $redirectUri = this.getRedirectUri();
        result = result * 59 + ($redirectUri == null ? 43 : $redirectUri.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $userScope = this.getUserScope();
        result = result * 59 + ($userScope == null ? 43 : $userScope.hashCode());
        String $appPath = this.getAppPath();
        result = result * 59 + ($appPath == null ? 43 : $appPath.hashCode());
        String $oauthStartPath = this.getOauthStartPath();
        result = result * 59 + ($oauthStartPath == null ? 43 : $oauthStartPath.hashCode());
        String $oauthInstallPath = this.getOauthInstallPath();
        result = result * 59 + ($oauthInstallPath == null ? 43 : $oauthInstallPath.hashCode());
        String $oauthCallbackPath = this.getOauthCallbackPath();
        result = result * 59 + ($oauthCallbackPath == null ? 43 : $oauthCallbackPath.hashCode());
        String $oauthRedirectUriPath = this.getOauthRedirectUriPath();
        result = result * 59 + ($oauthRedirectUriPath == null ? 43 : $oauthRedirectUriPath.hashCode());
        String $oauthCancellationUrl = this.getOauthCancellationUrl();
        result = result * 59 + ($oauthCancellationUrl == null ? 43 : $oauthCancellationUrl.hashCode());
        String $oauthCompletionUrl = this.getOauthCompletionUrl();
        result = result * 59 + ($oauthCompletionUrl == null ? 43 : $oauthCompletionUrl.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AppConfig(slack=" + this.getSlack() + ", singleTeamBotToken=" + this.getSingleTeamBotToken() + ", signingSecret=" + this.getSigningSecret() + ", verificationToken=" + this.getVerificationToken() + ", oAuthInstallPathEnabled=" + this.isOAuthInstallPathEnabled() + ", oAuthStartEnabled=" + this.isOAuthStartEnabled() + ", oAuthRedirectUriPathEnabled=" + this.isOAuthRedirectUriPathEnabled() + ", oAuthCallbackEnabled=" + this.isOAuthCallbackEnabled() + ", oAuthInstallPageRenderingEnabled=" + this.isOAuthInstallPageRenderingEnabled() + ", oAuthInstallPageRenderer=" + this.getOAuthInstallPageRenderer() + ", oAuthRedirectUriPageRenderer=" + this.getOAuthRedirectUriPageRenderer() + ", authTestCacheEnabled=" + this.isAuthTestCacheEnabled() + ", authTestCacheExpirationMillis=" + this.getAuthTestCacheExpirationMillis() + ", classicAppPermissionsEnabled=" + this.isClassicAppPermissionsEnabled() + ", threadPoolSize=" + this.getThreadPoolSize() + ", clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ", redirectUri=" + this.getRedirectUri() + ", scope=" + this.getScope() + ", userScope=" + this.getUserScope() + ", appPath=" + this.getAppPath() + ", oauthStartPath=" + this.getOauthStartPath() + ", oauthInstallPath=" + this.getOauthInstallPath() + ", oauthCallbackPath=" + this.getOauthCallbackPath() + ", oauthRedirectUriPath=" + this.getOauthRedirectUriPath() + ", oauthCancellationUrl=" + this.getOauthCancellationUrl() + ", oauthCompletionUrl=" + this.getOauthCompletionUrl() + ", alwaysRequestUserTokenNeeded=" + this.isAlwaysRequestUserTokenNeeded() + ", appInitializersEnabled=" + this.isAppInitializersEnabled() + ")";
    }

    @Generated
    public AppConfig() {
        this.slack = AppConfig.$default$slack();
        this.singleTeamBotToken = AppConfig.$default$singleTeamBotToken();
        this.signingSecret = AppConfig.$default$signingSecret();
        this.verificationToken = AppConfig.$default$verificationToken();
        this.oAuthInstallPathEnabled = AppConfig.$default$oAuthInstallPathEnabled();
        this.oAuthStartEnabled = AppConfig.$default$oAuthStartEnabled();
        this.oAuthRedirectUriPathEnabled = AppConfig.$default$oAuthRedirectUriPathEnabled();
        this.oAuthCallbackEnabled = AppConfig.$default$oAuthCallbackEnabled();
        this.oAuthInstallPageRenderingEnabled = AppConfig.$default$oAuthInstallPageRenderingEnabled();
        this.oAuthInstallPageRenderer = AppConfig.$default$oAuthInstallPageRenderer();
        this.oAuthRedirectUriPageRenderer = AppConfig.$default$oAuthRedirectUriPageRenderer();
        this.authTestCacheEnabled = AppConfig.$default$authTestCacheEnabled();
        this.authTestCacheExpirationMillis = AppConfig.$default$authTestCacheExpirationMillis();
        this.classicAppPermissionsEnabled = AppConfig.$default$classicAppPermissionsEnabled();
        this.threadPoolSize = AppConfig.$default$threadPoolSize();
        this.clientId = AppConfig.$default$clientId();
        this.clientSecret = AppConfig.$default$clientSecret();
        this.redirectUri = AppConfig.$default$redirectUri();
        this.scope = AppConfig.$default$scope();
        this.userScope = AppConfig.$default$userScope();
        this.oauthStartPath = AppConfig.$default$oauthStartPath();
        this.oauthInstallPath = AppConfig.$default$oauthInstallPath();
        this.oauthCallbackPath = AppConfig.$default$oauthCallbackPath();
        this.oauthRedirectUriPath = AppConfig.$default$oauthRedirectUriPath();
        this.oauthCancellationUrl = AppConfig.$default$oauthCancellationUrl();
        this.oauthCompletionUrl = AppConfig.$default$oauthCompletionUrl();
        this.alwaysRequestUserTokenNeeded = AppConfig.$default$alwaysRequestUserTokenNeeded();
        this.appInitializersEnabled = AppConfig.$default$appInitializersEnabled();
    }

    @Generated
    public AppConfig(Slack slack, String singleTeamBotToken, String signingSecret, String verificationToken, boolean oAuthInstallPathEnabled, boolean oAuthStartEnabled, boolean oAuthRedirectUriPathEnabled, boolean oAuthCallbackEnabled, boolean oAuthInstallPageRenderingEnabled, OAuthInstallPageRenderer oAuthInstallPageRenderer, OAuthRedirectUriPageRenderer oAuthRedirectUriPageRenderer, boolean authTestCacheEnabled, long authTestCacheExpirationMillis, boolean classicAppPermissionsEnabled, int threadPoolSize, String clientId, String clientSecret, String redirectUri, String scope, String userScope, String appPath, String oauthStartPath, String oauthInstallPath, String oauthCallbackPath, String oauthRedirectUriPath, String oauthCancellationUrl, String oauthCompletionUrl, boolean alwaysRequestUserTokenNeeded, boolean appInitializersEnabled) {
        this.slack = slack;
        this.singleTeamBotToken = singleTeamBotToken;
        this.signingSecret = signingSecret;
        this.verificationToken = verificationToken;
        this.oAuthInstallPathEnabled = oAuthInstallPathEnabled;
        this.oAuthStartEnabled = oAuthStartEnabled;
        this.oAuthRedirectUriPathEnabled = oAuthRedirectUriPathEnabled;
        this.oAuthCallbackEnabled = oAuthCallbackEnabled;
        this.oAuthInstallPageRenderingEnabled = oAuthInstallPageRenderingEnabled;
        this.oAuthInstallPageRenderer = oAuthInstallPageRenderer;
        this.oAuthRedirectUriPageRenderer = oAuthRedirectUriPageRenderer;
        this.authTestCacheEnabled = authTestCacheEnabled;
        this.authTestCacheExpirationMillis = authTestCacheExpirationMillis;
        this.classicAppPermissionsEnabled = classicAppPermissionsEnabled;
        this.threadPoolSize = threadPoolSize;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectUri = redirectUri;
        this.scope = scope;
        this.userScope = userScope;
        this.appPath = appPath;
        this.oauthStartPath = oauthStartPath;
        this.oauthInstallPath = oauthInstallPath;
        this.oauthCallbackPath = oauthCallbackPath;
        this.oauthRedirectUriPath = oauthRedirectUriPath;
        this.oauthCancellationUrl = oauthCancellationUrl;
        this.oauthCompletionUrl = oauthCompletionUrl;
        this.alwaysRequestUserTokenNeeded = alwaysRequestUserTokenNeeded;
        this.appInitializersEnabled = appInitializersEnabled;
    }

    @Generated
    public static class AppConfigBuilder {
        @Generated
        private boolean slack$set;
        @Generated
        private Slack slack$value;
        @Generated
        private boolean singleTeamBotToken$set;
        @Generated
        private String singleTeamBotToken$value;
        @Generated
        private boolean signingSecret$set;
        @Generated
        private String signingSecret$value;
        @Generated
        private boolean verificationToken$set;
        @Generated
        private String verificationToken$value;
        @Generated
        private boolean oAuthInstallPathEnabled$set;
        @Generated
        private boolean oAuthInstallPathEnabled$value;
        @Generated
        private boolean oAuthStartEnabled$set;
        @Generated
        private boolean oAuthStartEnabled$value;
        @Generated
        private boolean oAuthRedirectUriPathEnabled$set;
        @Generated
        private boolean oAuthRedirectUriPathEnabled$value;
        @Generated
        private boolean oAuthCallbackEnabled$set;
        @Generated
        private boolean oAuthCallbackEnabled$value;
        @Generated
        private boolean oAuthInstallPageRenderingEnabled$set;
        @Generated
        private boolean oAuthInstallPageRenderingEnabled$value;
        @Generated
        private boolean oAuthInstallPageRenderer$set;
        @Generated
        private OAuthInstallPageRenderer oAuthInstallPageRenderer$value;
        @Generated
        private boolean oAuthRedirectUriPageRenderer$set;
        @Generated
        private OAuthRedirectUriPageRenderer oAuthRedirectUriPageRenderer$value;
        @Generated
        private boolean authTestCacheEnabled$set;
        @Generated
        private boolean authTestCacheEnabled$value;
        @Generated
        private boolean authTestCacheExpirationMillis$set;
        @Generated
        private long authTestCacheExpirationMillis$value;
        @Generated
        private boolean classicAppPermissionsEnabled$set;
        @Generated
        private boolean classicAppPermissionsEnabled$value;
        @Generated
        private boolean threadPoolSize$set;
        @Generated
        private int threadPoolSize$value;
        @Generated
        private boolean clientId$set;
        @Generated
        private String clientId$value;
        @Generated
        private boolean clientSecret$set;
        @Generated
        private String clientSecret$value;
        @Generated
        private boolean redirectUri$set;
        @Generated
        private String redirectUri$value;
        @Generated
        private boolean scope$set;
        @Generated
        private String scope$value;
        @Generated
        private boolean userScope$set;
        @Generated
        private String userScope$value;
        @Generated
        private String appPath;
        @Generated
        private boolean oauthStartPath$set;
        @Generated
        private String oauthStartPath$value;
        @Generated
        private boolean oauthInstallPath$set;
        @Generated
        private String oauthInstallPath$value;
        @Generated
        private boolean oauthCallbackPath$set;
        @Generated
        private String oauthCallbackPath$value;
        @Generated
        private boolean oauthRedirectUriPath$set;
        @Generated
        private String oauthRedirectUriPath$value;
        @Generated
        private boolean oauthCancellationUrl$set;
        @Generated
        private String oauthCancellationUrl$value;
        @Generated
        private boolean oauthCompletionUrl$set;
        @Generated
        private String oauthCompletionUrl$value;
        @Generated
        private boolean alwaysRequestUserTokenNeeded$set;
        @Generated
        private boolean alwaysRequestUserTokenNeeded$value;
        @Generated
        private boolean appInitializersEnabled$set;
        @Generated
        private boolean appInitializersEnabled$value;

        @Generated
        AppConfigBuilder() {
        }

        @Generated
        public AppConfigBuilder slack(Slack slack) {
            this.slack$value = slack;
            this.slack$set = true;
            return this;
        }

        @Generated
        public AppConfigBuilder singleTeamBotToken(String singleTeamBotToken) {
            this.singleTeamBotToken$value = singleTeamBotToken;
            this.singleTeamBotToken$set = true;
            return this;
        }

        @Generated
        public AppConfigBuilder signingSecret(String signingSecret) {
            this.signingSecret$value = signingSecret;
            this.signingSecret$set = true;
            return this;
        }

        @Deprecated
        @Generated
        public AppConfigBuilder verificationToken(String verificationToken) {
            this.verificationToken$value = verificationToken;
            this.verificationToken$set = true;
            return this;
        }

        @Generated
        public AppConfigBuilder oAuthInstallPathEnabled(boolean oAuthInstallPathEnabled) {
            this.oAuthInstallPathEnabled$value = oAuthInstallPathEnabled;
            this.oAuthInstallPathEnabled$set = true;
            return this;
        }

        @Deprecated
        @Generated
        public AppConfigBuilder oAuthStartEnabled(boolean oAuthStartEnabled) {
            this.oAuthStartEnabled$value = oAuthStartEnabled;
            this.oAuthStartEnabled$set = true;
            return this;
        }

        @Generated
        public AppConfigBuilder oAuthRedirectUriPathEnabled(boolean oAuthRedirectUriPathEnabled) {
            this.oAuthRedirectUriPathEnabled$value = oAuthRedirectUriPathEnabled;
            this.oAuthRedirectUriPathEnabled$set = true;
            return this;
        }

        @Deprecated
        @Generated
        public AppConfigBuilder oAuthCallbackEnabled(boolean oAuthCallbackEnabled) {
            this.oAuthCallbackEnabled$value = oAuthCallbackEnabled;
            this.oAuthCallbackEnabled$set = true;
            return this;
        }

        @Generated
        public AppConfigBuilder oAuthInstallPageRenderingEnabled(boolean oAuthInstallPageRenderingEnabled) {
            this.oAuthInstallPageRenderingEnabled$value = oAuthInstallPageRenderingEnabled;
            this.oAuthInstallPageRenderingEnabled$set = true;
            return this;
        }

        @Generated
        public AppConfigBuilder oAuthInstallPageRenderer(OAuthInstallPageRenderer oAuthInstallPageRenderer) {
            this.oAuthInstallPageRenderer$value = oAuthInstallPageRenderer;
            this.oAuthInstallPageRenderer$set = true;
            return this;
        }

        @Generated
        public AppConfigBuilder oAuthRedirectUriPageRenderer(OAuthRedirectUriPageRenderer oAuthRedirectUriPageRenderer) {
            this.oAuthRedirectUriPageRenderer$value = oAuthRedirectUriPageRenderer;
            this.oAuthRedirectUriPageRenderer$set = true;
            return this;
        }

        @Generated
        public AppConfigBuilder authTestCacheEnabled(boolean authTestCacheEnabled) {
            this.authTestCacheEnabled$value = authTestCacheEnabled;
            this.authTestCacheEnabled$set = true;
            return this;
        }

        @Generated
        public AppConfigBuilder authTestCacheExpirationMillis(long authTestCacheExpirationMillis) {
            this.authTestCacheExpirationMillis$value = authTestCacheExpirationMillis;
            this.authTestCacheExpirationMillis$set = true;
            return this;
        }

        @Generated
        public AppConfigBuilder classicAppPermissionsEnabled(boolean classicAppPermissionsEnabled) {
            this.classicAppPermissionsEnabled$value = classicAppPermissionsEnabled;
            this.classicAppPermissionsEnabled$set = true;
            return this;
        }

        @Generated
        public AppConfigBuilder threadPoolSize(int threadPoolSize) {
            this.threadPoolSize$value = threadPoolSize;
            this.threadPoolSize$set = true;
            return this;
        }

        @Generated
        public AppConfigBuilder clientId(String clientId) {
            this.clientId$value = clientId;
            this.clientId$set = true;
            return this;
        }

        @Generated
        public AppConfigBuilder clientSecret(String clientSecret) {
            this.clientSecret$value = clientSecret;
            this.clientSecret$set = true;
            return this;
        }

        @Generated
        public AppConfigBuilder redirectUri(String redirectUri) {
            this.redirectUri$value = redirectUri;
            this.redirectUri$set = true;
            return this;
        }

        @Generated
        public AppConfigBuilder scope(String scope) {
            this.scope$value = scope;
            this.scope$set = true;
            return this;
        }

        @Generated
        public AppConfigBuilder userScope(String userScope) {
            this.userScope$value = userScope;
            this.userScope$set = true;
            return this;
        }

        @Generated
        public AppConfigBuilder appPath(String appPath) {
            this.appPath = appPath;
            return this;
        }

        @Deprecated
        @Generated
        public AppConfigBuilder oauthStartPath(String oauthStartPath) {
            this.oauthStartPath$value = oauthStartPath;
            this.oauthStartPath$set = true;
            return this;
        }

        @Generated
        public AppConfigBuilder oauthInstallPath(String oauthInstallPath) {
            this.oauthInstallPath$value = oauthInstallPath;
            this.oauthInstallPath$set = true;
            return this;
        }

        @Deprecated
        @Generated
        public AppConfigBuilder oauthCallbackPath(String oauthCallbackPath) {
            this.oauthCallbackPath$value = oauthCallbackPath;
            this.oauthCallbackPath$set = true;
            return this;
        }

        @Generated
        public AppConfigBuilder oauthRedirectUriPath(String oauthRedirectUriPath) {
            this.oauthRedirectUriPath$value = oauthRedirectUriPath;
            this.oauthRedirectUriPath$set = true;
            return this;
        }

        @Generated
        public AppConfigBuilder oauthCancellationUrl(String oauthCancellationUrl) {
            this.oauthCancellationUrl$value = oauthCancellationUrl;
            this.oauthCancellationUrl$set = true;
            return this;
        }

        @Generated
        public AppConfigBuilder oauthCompletionUrl(String oauthCompletionUrl) {
            this.oauthCompletionUrl$value = oauthCompletionUrl;
            this.oauthCompletionUrl$set = true;
            return this;
        }

        @Generated
        public AppConfigBuilder alwaysRequestUserTokenNeeded(boolean alwaysRequestUserTokenNeeded) {
            this.alwaysRequestUserTokenNeeded$value = alwaysRequestUserTokenNeeded;
            this.alwaysRequestUserTokenNeeded$set = true;
            return this;
        }

        @Generated
        public AppConfigBuilder appInitializersEnabled(boolean appInitializersEnabled) {
            this.appInitializersEnabled$value = appInitializersEnabled;
            this.appInitializersEnabled$set = true;
            return this;
        }

        @Generated
        public AppConfig build() {
            Slack slack$value = this.slack$value;
            if (!this.slack$set) {
                slack$value = AppConfig.$default$slack();
            }
            String singleTeamBotToken$value = this.singleTeamBotToken$value;
            if (!this.singleTeamBotToken$set) {
                singleTeamBotToken$value = AppConfig.$default$singleTeamBotToken();
            }
            String signingSecret$value = this.signingSecret$value;
            if (!this.signingSecret$set) {
                signingSecret$value = AppConfig.$default$signingSecret();
            }
            String verificationToken$value = this.verificationToken$value;
            if (!this.verificationToken$set) {
                verificationToken$value = AppConfig.$default$verificationToken();
            }
            boolean oAuthInstallPathEnabled$value = this.oAuthInstallPathEnabled$value;
            if (!this.oAuthInstallPathEnabled$set) {
                oAuthInstallPathEnabled$value = AppConfig.$default$oAuthInstallPathEnabled();
            }
            boolean oAuthStartEnabled$value = this.oAuthStartEnabled$value;
            if (!this.oAuthStartEnabled$set) {
                oAuthStartEnabled$value = AppConfig.$default$oAuthStartEnabled();
            }
            boolean oAuthRedirectUriPathEnabled$value = this.oAuthRedirectUriPathEnabled$value;
            if (!this.oAuthRedirectUriPathEnabled$set) {
                oAuthRedirectUriPathEnabled$value = AppConfig.$default$oAuthRedirectUriPathEnabled();
            }
            boolean oAuthCallbackEnabled$value = this.oAuthCallbackEnabled$value;
            if (!this.oAuthCallbackEnabled$set) {
                oAuthCallbackEnabled$value = AppConfig.$default$oAuthCallbackEnabled();
            }
            boolean oAuthInstallPageRenderingEnabled$value = this.oAuthInstallPageRenderingEnabled$value;
            if (!this.oAuthInstallPageRenderingEnabled$set) {
                oAuthInstallPageRenderingEnabled$value = AppConfig.$default$oAuthInstallPageRenderingEnabled();
            }
            OAuthInstallPageRenderer oAuthInstallPageRenderer$value = this.oAuthInstallPageRenderer$value;
            if (!this.oAuthInstallPageRenderer$set) {
                oAuthInstallPageRenderer$value = AppConfig.$default$oAuthInstallPageRenderer();
            }
            OAuthRedirectUriPageRenderer oAuthRedirectUriPageRenderer$value = this.oAuthRedirectUriPageRenderer$value;
            if (!this.oAuthRedirectUriPageRenderer$set) {
                oAuthRedirectUriPageRenderer$value = AppConfig.$default$oAuthRedirectUriPageRenderer();
            }
            boolean authTestCacheEnabled$value = this.authTestCacheEnabled$value;
            if (!this.authTestCacheEnabled$set) {
                authTestCacheEnabled$value = AppConfig.$default$authTestCacheEnabled();
            }
            long authTestCacheExpirationMillis$value = this.authTestCacheExpirationMillis$value;
            if (!this.authTestCacheExpirationMillis$set) {
                authTestCacheExpirationMillis$value = AppConfig.$default$authTestCacheExpirationMillis();
            }
            boolean classicAppPermissionsEnabled$value = this.classicAppPermissionsEnabled$value;
            if (!this.classicAppPermissionsEnabled$set) {
                classicAppPermissionsEnabled$value = AppConfig.$default$classicAppPermissionsEnabled();
            }
            int threadPoolSize$value = this.threadPoolSize$value;
            if (!this.threadPoolSize$set) {
                threadPoolSize$value = AppConfig.$default$threadPoolSize();
            }
            String clientId$value = this.clientId$value;
            if (!this.clientId$set) {
                clientId$value = AppConfig.$default$clientId();
            }
            String clientSecret$value = this.clientSecret$value;
            if (!this.clientSecret$set) {
                clientSecret$value = AppConfig.$default$clientSecret();
            }
            String redirectUri$value = this.redirectUri$value;
            if (!this.redirectUri$set) {
                redirectUri$value = AppConfig.$default$redirectUri();
            }
            String scope$value = this.scope$value;
            if (!this.scope$set) {
                scope$value = AppConfig.$default$scope();
            }
            String userScope$value = this.userScope$value;
            if (!this.userScope$set) {
                userScope$value = AppConfig.$default$userScope();
            }
            String oauthStartPath$value = this.oauthStartPath$value;
            if (!this.oauthStartPath$set) {
                oauthStartPath$value = AppConfig.$default$oauthStartPath();
            }
            String oauthInstallPath$value = this.oauthInstallPath$value;
            if (!this.oauthInstallPath$set) {
                oauthInstallPath$value = AppConfig.$default$oauthInstallPath();
            }
            String oauthCallbackPath$value = this.oauthCallbackPath$value;
            if (!this.oauthCallbackPath$set) {
                oauthCallbackPath$value = AppConfig.$default$oauthCallbackPath();
            }
            String oauthRedirectUriPath$value = this.oauthRedirectUriPath$value;
            if (!this.oauthRedirectUriPath$set) {
                oauthRedirectUriPath$value = AppConfig.$default$oauthRedirectUriPath();
            }
            String oauthCancellationUrl$value = this.oauthCancellationUrl$value;
            if (!this.oauthCancellationUrl$set) {
                oauthCancellationUrl$value = AppConfig.$default$oauthCancellationUrl();
            }
            String oauthCompletionUrl$value = this.oauthCompletionUrl$value;
            if (!this.oauthCompletionUrl$set) {
                oauthCompletionUrl$value = AppConfig.$default$oauthCompletionUrl();
            }
            boolean alwaysRequestUserTokenNeeded$value = this.alwaysRequestUserTokenNeeded$value;
            if (!this.alwaysRequestUserTokenNeeded$set) {
                alwaysRequestUserTokenNeeded$value = AppConfig.$default$alwaysRequestUserTokenNeeded();
            }
            boolean appInitializersEnabled$value = this.appInitializersEnabled$value;
            if (!this.appInitializersEnabled$set) {
                appInitializersEnabled$value = AppConfig.$default$appInitializersEnabled();
            }
            return new AppConfig(slack$value, singleTeamBotToken$value, signingSecret$value, verificationToken$value, oAuthInstallPathEnabled$value, oAuthStartEnabled$value, oAuthRedirectUriPathEnabled$value, oAuthCallbackEnabled$value, oAuthInstallPageRenderingEnabled$value, oAuthInstallPageRenderer$value, oAuthRedirectUriPageRenderer$value, authTestCacheEnabled$value, authTestCacheExpirationMillis$value, classicAppPermissionsEnabled$value, threadPoolSize$value, clientId$value, clientSecret$value, redirectUri$value, scope$value, userScope$value, this.appPath, oauthStartPath$value, oauthInstallPath$value, oauthCallbackPath$value, oauthRedirectUriPath$value, oauthCancellationUrl$value, oauthCompletionUrl$value, alwaysRequestUserTokenNeeded$value, appInitializersEnabled$value);
        }

        @Generated
        public String toString() {
            return "AppConfig.AppConfigBuilder(slack$value=" + this.slack$value + ", singleTeamBotToken$value=" + this.singleTeamBotToken$value + ", signingSecret$value=" + this.signingSecret$value + ", verificationToken$value=" + this.verificationToken$value + ", oAuthInstallPathEnabled$value=" + this.oAuthInstallPathEnabled$value + ", oAuthStartEnabled$value=" + this.oAuthStartEnabled$value + ", oAuthRedirectUriPathEnabled$value=" + this.oAuthRedirectUriPathEnabled$value + ", oAuthCallbackEnabled$value=" + this.oAuthCallbackEnabled$value + ", oAuthInstallPageRenderingEnabled$value=" + this.oAuthInstallPageRenderingEnabled$value + ", oAuthInstallPageRenderer$value=" + this.oAuthInstallPageRenderer$value + ", oAuthRedirectUriPageRenderer$value=" + this.oAuthRedirectUriPageRenderer$value + ", authTestCacheEnabled$value=" + this.authTestCacheEnabled$value + ", authTestCacheExpirationMillis$value=" + this.authTestCacheExpirationMillis$value + ", classicAppPermissionsEnabled$value=" + this.classicAppPermissionsEnabled$value + ", threadPoolSize$value=" + this.threadPoolSize$value + ", clientId$value=" + this.clientId$value + ", clientSecret$value=" + this.clientSecret$value + ", redirectUri$value=" + this.redirectUri$value + ", scope$value=" + this.scope$value + ", userScope$value=" + this.userScope$value + ", appPath=" + this.appPath + ", oauthStartPath$value=" + this.oauthStartPath$value + ", oauthInstallPath$value=" + this.oauthInstallPath$value + ", oauthCallbackPath$value=" + this.oauthCallbackPath$value + ", oauthRedirectUriPath$value=" + this.oauthRedirectUriPath$value + ", oauthCancellationUrl$value=" + this.oauthCancellationUrl$value + ", oauthCompletionUrl$value=" + this.oauthCompletionUrl$value + ", alwaysRequestUserTokenNeeded$value=" + this.alwaysRequestUserTokenNeeded$value + ", appInitializersEnabled$value=" + this.appInitializersEnabled$value + ")";
        }
    }

    public static final class EnvVariableName {
        public static final String SLACK_BOT_TOKEN = "SLACK_BOT_TOKEN";
        public static final String SLACK_SIGNING_SECRET = "SLACK_SIGNING_SECRET";
        public static final String SLACK_VERIFICATION_TOKEN = "SLACK_VERIFICATION_TOKEN";
        public static final String SLACK_CLIENT_ID = "SLACK_CLIENT_ID";
        public static final String SLACK_CLIENT_SECRET = "SLACK_CLIENT_SECRET";
        public static final String SLACK_REDIRECT_URI = "SLACK_REDIRECT_URI";
        public static final String SLACK_SCOPES = "SLACK_SCOPES";
        public static final String SLACK_USER_SCOPES = "SLACK_USER_SCOPES";
        public static final String SLACK_INSTALL_PATH = "SLACK_INSTALL_PATH";
        public static final String SLACK_REDIRECT_URI_PATH = "SLACK_REDIRECT_URI_PATH";
        public static final String SLACK_OAUTH_CANCELLATION_URL = "SLACK_OAUTH_CANCELLATION_URL";
        public static final String SLACK_OAUTH_COMPLETION_URL = "SLACK_OAUTH_COMPLETION_URL";
        @Deprecated
        public static final String SLACK_APP_CLIENT_ID = "SLACK_APP_CLIENT_ID";
        @Deprecated
        public static final String SLACK_APP_CLIENT_SECRET = "SLACK_APP_CLIENT_SECRET";
        @Deprecated
        public static final String SLACK_APP_REDIRECT_URI = "SLACK_APP_REDIRECT_URI";
        @Deprecated
        public static final String SLACK_APP_SCOPE = "SLACK_APP_SCOPE";
        @Deprecated
        public static final String SLACK_APP_USER_SCOPE = "SLACK_APP_USER_SCOPE";
        @Deprecated
        public static final String SLACK_APP_OAUTH_START_PATH = "SLACK_APP_OAUTH_START_PATH";
        @Deprecated
        public static final String SLACK_APP_OAUTH_CALLBACK_PATH = "SLACK_APP_OAUTH_CALLBACK_PATH";
        @Deprecated
        public static final String SLACK_APP_OAUTH_CANCELLATION_URL = "SLACK_APP_OAUTH_CANCELLATION_URL";
        @Deprecated
        public static final String SLACK_APP_OAUTH_COMPLETION_URL = "SLACK_APP_OAUTH_COMPLETION_URL";

        private EnvVariableName() {
        }
    }
}

