/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.slack.api.app_backend.oauth.payload.VerificationCodePayload;
import com.slack.api.app_backend.slash_commands.SlashCommandPayloadDetector;
import com.slack.api.app_backend.ssl_check.SSLCheckPayloadDetector;
import com.slack.api.app_backend.util.JsonPayloadExtractor;
import com.slack.api.bolt.AppConfig;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.request.builtin.AttachmentActionRequest;
import com.slack.api.bolt.request.builtin.BlockActionRequest;
import com.slack.api.bolt.request.builtin.BlockSuggestionRequest;
import com.slack.api.bolt.request.builtin.DialogCancellationRequest;
import com.slack.api.bolt.request.builtin.DialogSubmissionRequest;
import com.slack.api.bolt.request.builtin.DialogSuggestionRequest;
import com.slack.api.bolt.request.builtin.EventRequest;
import com.slack.api.bolt.request.builtin.GlobalShortcutRequest;
import com.slack.api.bolt.request.builtin.MessageShortcutRequest;
import com.slack.api.bolt.request.builtin.OAuthCallbackRequest;
import com.slack.api.bolt.request.builtin.OAuthStartRequest;
import com.slack.api.bolt.request.builtin.SSLCheckRequest;
import com.slack.api.bolt.request.builtin.SlashCommandRequest;
import com.slack.api.bolt.request.builtin.UrlVerificationRequest;
import com.slack.api.bolt.request.builtin.ViewClosedRequest;
import com.slack.api.bolt.request.builtin.ViewSubmissionRequest;
import com.slack.api.bolt.request.builtin.WorkflowStepEditRequest;
import com.slack.api.bolt.request.builtin.WorkflowStepExecuteRequest;
import com.slack.api.bolt.request.builtin.WorkflowStepSaveRequest;
import com.slack.api.util.json.GsonFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackRequestParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SlackRequestParser.class);
    private final AppConfig appConfig;
    private JsonPayloadExtractor jsonPayloadExtractor = new JsonPayloadExtractor();
    private SlashCommandPayloadDetector commandRequestDetector = new SlashCommandPayloadDetector();
    private SSLCheckPayloadDetector sslCheckPayloadDetector = new SSLCheckPayloadDetector();
    private Gson gson = GsonFactory.createSnakeCase();

    public SlackRequestParser(AppConfig appConfig) {
        this.appConfig = appConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    public Request<?> parse(HttpRequest httpRequest) {
        String requestUri = httpRequest.getRequestUri();
        String requestBody = httpRequest.getRequestBody();
        RequestHeaders headers = httpRequest.getHeaders();
        Request slackRequest = null;
        try {
            String jsonPayload = this.jsonPayloadExtractor.extractIfExists(requestBody);
            if (jsonPayload != null) {
                String payloadType;
                JsonObject payload = ((JsonElement)this.gson.fromJson(jsonPayload, JsonElement.class)).getAsJsonObject();
                JsonElement typeElem = payload.get("type");
                if (typeElem == null) {
                    Request<?> request = null;
                    return request;
                }
                switch (payloadType = typeElem.getAsString()) {
                    case "interactive_message": {
                        slackRequest = new AttachmentActionRequest(requestBody, jsonPayload, headers);
                        break;
                    }
                    case "block_actions": {
                        slackRequest = new BlockActionRequest(requestBody, jsonPayload, headers);
                        break;
                    }
                    case "block_suggestion": {
                        slackRequest = new BlockSuggestionRequest(requestBody, jsonPayload, headers);
                        break;
                    }
                    case "shortcut": {
                        slackRequest = new GlobalShortcutRequest(requestBody, jsonPayload, headers);
                        break;
                    }
                    case "message_action": {
                        slackRequest = new MessageShortcutRequest(requestBody, jsonPayload, headers);
                        break;
                    }
                    case "event_callback": {
                        String type = payload.get("event").getAsJsonObject().get("type").getAsString();
                        if (type.equals("workflow_step_execute")) {
                            slackRequest = new WorkflowStepExecuteRequest(jsonPayload, headers);
                            break;
                        }
                        slackRequest = new EventRequest(jsonPayload, headers);
                        break;
                    }
                    case "url_verification": {
                        slackRequest = new UrlVerificationRequest(jsonPayload, headers);
                        break;
                    }
                    case "dialog_cancellation": {
                        slackRequest = new DialogCancellationRequest(requestBody, jsonPayload, headers);
                        break;
                    }
                    case "dialog_submission": {
                        slackRequest = new DialogSubmissionRequest(requestBody, jsonPayload, headers);
                        break;
                    }
                    case "dialog_suggestion": {
                        slackRequest = new DialogSuggestionRequest(requestBody, jsonPayload, headers);
                        break;
                    }
                    case "view_submission": {
                        String viewType = payload.get("view").getAsJsonObject().get("type").getAsString();
                        if (viewType.equals("workflow_step")) {
                            slackRequest = new WorkflowStepSaveRequest(requestBody, jsonPayload, headers);
                            break;
                        }
                        slackRequest = new ViewSubmissionRequest(requestBody, jsonPayload, headers);
                        break;
                    }
                    case "view_closed": {
                        slackRequest = new ViewClosedRequest(requestBody, jsonPayload, headers);
                        break;
                    }
                    case "workflow_step_edit": {
                        slackRequest = new WorkflowStepEditRequest(requestBody, jsonPayload, headers);
                        break;
                    }
                    default: {
                        log.warn("No request pattern detected for {}", (Object)jsonPayload);
                        break;
                    }
                }
            } else if (this.commandRequestDetector.isCommand(requestBody)) {
                slackRequest = new SlashCommandRequest(requestBody, headers);
            } else if (this.sslCheckPayloadDetector.isSSLCheckRequest(requestBody)) {
                slackRequest = new SSLCheckRequest(requestBody, headers);
            } else if (this.appConfig.isOAuthInstallPathEnabled() && this.appConfig.getOauthInstallRequestURI().equals(requestUri)) {
                slackRequest = new OAuthStartRequest(requestBody, headers);
            } else if (this.appConfig.isOAuthRedirectUriPathEnabled() && this.appConfig.getOauthRedirectUriRequestURI().equals(requestUri) && httpRequest.getQueryString() != null) {
                HashMap<String, List<String>> queryString = new HashMap<String, List<String>>();
                for (Object original : httpRequest.getQueryString().entrySet()) {
                    if (original.getValue() == null) continue;
                    queryString.put((String)original.getKey(), new ArrayList((Collection)original.getValue()));
                }
                VerificationCodePayload payload = VerificationCodePayload.from(queryString);
                slackRequest = new OAuthCallbackRequest(queryString, requestBody, payload, headers);
            } else {
                log.warn("No request pattern detected for {}", (Object)requestBody);
            }
            Request request = slackRequest;
            return request;
        }
        finally {
            if (slackRequest != null) {
                String ipAddress;
                slackRequest.updateContext(this.appConfig);
                Map<String, List<String>> queryString = httpRequest.getQueryString();
                if (queryString != null) {
                    for (Map.Entry<String, List<String>> each : queryString.entrySet()) {
                        List<String> values = slackRequest.getQueryString().get(each.getKey());
                        if (values == null) {
                            values = new ArrayList<String>();
                        }
                        values.addAll((Collection<String>)each.getValue());
                        slackRequest.getQueryString().put(each.getKey(), values);
                    }
                }
                if ((ipAddress = headers.getFirstValue("X-FORWARDED-FOR")) == null) {
                    ipAddress = httpRequest.getRemoteAddress();
                }
                slackRequest.setClientIpAddress(ipAddress);
            }
        }
    }

    @Generated
    public AppConfig getAppConfig() {
        return this.appConfig;
    }

    @Generated
    public JsonPayloadExtractor getJsonPayloadExtractor() {
        return this.jsonPayloadExtractor;
    }

    @Generated
    public SlashCommandPayloadDetector getCommandRequestDetector() {
        return this.commandRequestDetector;
    }

    @Generated
    public SSLCheckPayloadDetector getSslCheckPayloadDetector() {
        return this.sslCheckPayloadDetector;
    }

    @Generated
    public Gson getGson() {
        return this.gson;
    }

    @Generated
    public void setJsonPayloadExtractor(JsonPayloadExtractor jsonPayloadExtractor) {
        this.jsonPayloadExtractor = jsonPayloadExtractor;
    }

    @Generated
    public void setCommandRequestDetector(SlashCommandPayloadDetector commandRequestDetector) {
        this.commandRequestDetector = commandRequestDetector;
    }

    @Generated
    public void setSslCheckPayloadDetector(SSLCheckPayloadDetector sslCheckPayloadDetector) {
        this.sslCheckPayloadDetector = sslCheckPayloadDetector;
    }

    @Generated
    public void setGson(Gson gson) {
        this.gson = gson;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SlackRequestParser)) {
            return false;
        }
        SlackRequestParser other = (SlackRequestParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AppConfig this$appConfig = this.getAppConfig();
        AppConfig other$appConfig = other.getAppConfig();
        if (this$appConfig == null ? other$appConfig != null : !((Object)this$appConfig).equals(other$appConfig)) {
            return false;
        }
        JsonPayloadExtractor this$jsonPayloadExtractor = this.getJsonPayloadExtractor();
        JsonPayloadExtractor other$jsonPayloadExtractor = other.getJsonPayloadExtractor();
        if (this$jsonPayloadExtractor == null ? other$jsonPayloadExtractor != null : !this$jsonPayloadExtractor.equals(other$jsonPayloadExtractor)) {
            return false;
        }
        SlashCommandPayloadDetector this$commandRequestDetector = this.getCommandRequestDetector();
        SlashCommandPayloadDetector other$commandRequestDetector = other.getCommandRequestDetector();
        if (this$commandRequestDetector == null ? other$commandRequestDetector != null : !this$commandRequestDetector.equals(other$commandRequestDetector)) {
            return false;
        }
        SSLCheckPayloadDetector this$sslCheckPayloadDetector = this.getSslCheckPayloadDetector();
        SSLCheckPayloadDetector other$sslCheckPayloadDetector = other.getSslCheckPayloadDetector();
        if (this$sslCheckPayloadDetector == null ? other$sslCheckPayloadDetector != null : !this$sslCheckPayloadDetector.equals(other$sslCheckPayloadDetector)) {
            return false;
        }
        Gson this$gson = this.getGson();
        Gson other$gson = other.getGson();
        return !(this$gson == null ? other$gson != null : !this$gson.equals(other$gson));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SlackRequestParser;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AppConfig $appConfig = this.getAppConfig();
        result = result * 59 + ($appConfig == null ? 43 : ((Object)$appConfig).hashCode());
        JsonPayloadExtractor $jsonPayloadExtractor = this.getJsonPayloadExtractor();
        result = result * 59 + ($jsonPayloadExtractor == null ? 43 : $jsonPayloadExtractor.hashCode());
        SlashCommandPayloadDetector $commandRequestDetector = this.getCommandRequestDetector();
        result = result * 59 + ($commandRequestDetector == null ? 43 : $commandRequestDetector.hashCode());
        SSLCheckPayloadDetector $sslCheckPayloadDetector = this.getSslCheckPayloadDetector();
        result = result * 59 + ($sslCheckPayloadDetector == null ? 43 : $sslCheckPayloadDetector.hashCode());
        Gson $gson = this.getGson();
        result = result * 59 + ($gson == null ? 43 : $gson.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SlackRequestParser(appConfig=" + this.getAppConfig() + ", jsonPayloadExtractor=" + this.getJsonPayloadExtractor() + ", commandRequestDetector=" + this.getCommandRequestDetector() + ", sslCheckPayloadDetector=" + this.getSslCheckPayloadDetector() + ", gson=" + this.getGson() + ")";
    }

    public static class HttpRequest {
        private String requestUri;
        private Map<String, List<String>> queryString;
        private String requestBody;
        private RequestHeaders headers;
        private String remoteAddress;

        @Generated
        HttpRequest(String requestUri, Map<String, List<String>> queryString, String requestBody, RequestHeaders headers, String remoteAddress) {
            this.requestUri = requestUri;
            this.queryString = queryString;
            this.requestBody = requestBody;
            this.headers = headers;
            this.remoteAddress = remoteAddress;
        }

        @Generated
        public static HttpRequestBuilder builder() {
            return new HttpRequestBuilder();
        }

        @Generated
        public String getRequestUri() {
            return this.requestUri;
        }

        @Generated
        public Map<String, List<String>> getQueryString() {
            return this.queryString;
        }

        @Generated
        public String getRequestBody() {
            return this.requestBody;
        }

        @Generated
        public RequestHeaders getHeaders() {
            return this.headers;
        }

        @Generated
        public String getRemoteAddress() {
            return this.remoteAddress;
        }

        @Generated
        public void setRequestUri(String requestUri) {
            this.requestUri = requestUri;
        }

        @Generated
        public void setQueryString(Map<String, List<String>> queryString) {
            this.queryString = queryString;
        }

        @Generated
        public void setRequestBody(String requestBody) {
            this.requestBody = requestBody;
        }

        @Generated
        public void setHeaders(RequestHeaders headers) {
            this.headers = headers;
        }

        @Generated
        public void setRemoteAddress(String remoteAddress) {
            this.remoteAddress = remoteAddress;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpRequest)) {
                return false;
            }
            HttpRequest other = (HttpRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$requestUri = this.getRequestUri();
            String other$requestUri = other.getRequestUri();
            if (this$requestUri == null ? other$requestUri != null : !this$requestUri.equals(other$requestUri)) {
                return false;
            }
            Map<String, List<String>> this$queryString = this.getQueryString();
            Map<String, List<String>> other$queryString = other.getQueryString();
            if (this$queryString == null ? other$queryString != null : !((Object)this$queryString).equals(other$queryString)) {
                return false;
            }
            String this$requestBody = this.getRequestBody();
            String other$requestBody = other.getRequestBody();
            if (this$requestBody == null ? other$requestBody != null : !this$requestBody.equals(other$requestBody)) {
                return false;
            }
            RequestHeaders this$headers = this.getHeaders();
            RequestHeaders other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
                return false;
            }
            String this$remoteAddress = this.getRemoteAddress();
            String other$remoteAddress = other.getRemoteAddress();
            return !(this$remoteAddress == null ? other$remoteAddress != null : !this$remoteAddress.equals(other$remoteAddress));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof HttpRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $requestUri = this.getRequestUri();
            result = result * 59 + ($requestUri == null ? 43 : $requestUri.hashCode());
            Map<String, List<String>> $queryString = this.getQueryString();
            result = result * 59 + ($queryString == null ? 43 : ((Object)$queryString).hashCode());
            String $requestBody = this.getRequestBody();
            result = result * 59 + ($requestBody == null ? 43 : $requestBody.hashCode());
            RequestHeaders $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
            String $remoteAddress = this.getRemoteAddress();
            result = result * 59 + ($remoteAddress == null ? 43 : $remoteAddress.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SlackRequestParser.HttpRequest(requestUri=" + this.getRequestUri() + ", queryString=" + this.getQueryString() + ", requestBody=" + this.getRequestBody() + ", headers=" + this.getHeaders() + ", remoteAddress=" + this.getRemoteAddress() + ")";
        }

        @Generated
        public static class HttpRequestBuilder {
            @Generated
            private String requestUri;
            @Generated
            private Map<String, List<String>> queryString;
            @Generated
            private String requestBody;
            @Generated
            private RequestHeaders headers;
            @Generated
            private String remoteAddress;

            @Generated
            HttpRequestBuilder() {
            }

            @Generated
            public HttpRequestBuilder requestUri(String requestUri) {
                this.requestUri = requestUri;
                return this;
            }

            @Generated
            public HttpRequestBuilder queryString(Map<String, List<String>> queryString) {
                this.queryString = queryString;
                return this;
            }

            @Generated
            public HttpRequestBuilder requestBody(String requestBody) {
                this.requestBody = requestBody;
                return this;
            }

            @Generated
            public HttpRequestBuilder headers(RequestHeaders headers) {
                this.headers = headers;
                return this;
            }

            @Generated
            public HttpRequestBuilder remoteAddress(String remoteAddress) {
                this.remoteAddress = remoteAddress;
                return this;
            }

            @Generated
            public HttpRequest build() {
                return new HttpRequest(this.requestUri, this.queryString, this.requestBody, this.headers, this.remoteAddress);
            }

            @Generated
            public String toString() {
                return "SlackRequestParser.HttpRequest.HttpRequestBuilder(requestUri=" + this.requestUri + ", queryString=" + this.queryString + ", requestBody=" + this.requestBody + ", headers=" + this.headers + ", remoteAddress=" + this.remoteAddress + ")";
            }
        }
    }
}

