/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.request.builtin;

import com.slack.api.app_backend.interactive_components.payload.GlobalShortcutPayload;
import com.slack.api.bolt.context.builtin.GlobalShortcutContext;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.request.RequestType;
import com.slack.api.util.json.GsonFactory;
import lombok.Generated;

public class GlobalShortcutRequest
extends Request<GlobalShortcutContext> {
    private final String requestBody;
    private final RequestHeaders headers;
    private final GlobalShortcutPayload payload;
    private GlobalShortcutContext context = new GlobalShortcutContext();

    public GlobalShortcutRequest(String requestBody, String payloadBody, RequestHeaders headers) {
        this.requestBody = requestBody;
        this.headers = headers;
        this.payload = (GlobalShortcutPayload)GsonFactory.createSnakeCase().fromJson(payloadBody, GlobalShortcutPayload.class);
        this.getContext().setTriggerId(this.payload.getTriggerId());
        this.getContext().setEnterpriseId(this.payload.getTeam().getEnterpriseId());
        this.getContext().setTeamId(this.payload.getTeam().getId());
        this.getContext().setRequestUserId(this.payload.getUser().getId());
    }

    @Override
    public GlobalShortcutContext getContext() {
        return this.context;
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.GlobalShortcut;
    }

    @Override
    public String getRequestBodyAsString() {
        return this.requestBody;
    }

    @Override
    public RequestHeaders getHeaders() {
        return this.headers;
    }

    public GlobalShortcutPayload getPayload() {
        return this.payload;
    }

    @Override
    public String getResponseUrl() {
        return null;
    }

    @Override
    @Generated
    public String toString() {
        return "GlobalShortcutRequest(super=" + super.toString() + ", requestBody=" + this.requestBody + ", headers=" + this.getHeaders() + ", payload=" + this.getPayload() + ", context=" + this.getContext() + ")";
    }
}

