/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.service.builtin.oauth.default_impl;

import com.slack.api.bolt.AppConfig;
import com.slack.api.bolt.request.builtin.OAuthCallbackRequest;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.service.builtin.oauth.OpenIDConnectErrorHandler;
import com.slack.api.bolt.service.builtin.oauth.view.OAuthRedirectUriPageRenderer;
import com.slack.api.methods.response.openid.connect.OpenIDConnectTokenResponse;
import java.util.Arrays;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenIDConnectDefaultErrorHandler
implements OpenIDConnectErrorHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenIDConnectDefaultErrorHandler.class);
    private final AppConfig appConfig;
    private final OAuthRedirectUriPageRenderer pageRenderer;

    public OpenIDConnectDefaultErrorHandler(AppConfig appConfig) {
        this.appConfig = appConfig;
        this.pageRenderer = appConfig.getOAuthRedirectUriPageRenderer();
    }

    @Override
    public Response handle(OAuthCallbackRequest req, Response response, OpenIDConnectTokenResponse apiResponse) {
        log.error("Failed to run an openid.connect.token API call: {} - {}", (Object)apiResponse.getError(), (Object)apiResponse);
        String url = req.getContext().getOauthCancellationUrl();
        if (url == null) {
            String reason = apiResponse.getError();
            response.setStatusCode(200);
            response.setBody(this.pageRenderer.renderFailurePage(this.appConfig.getOauthInstallRequestURI(), reason));
            response.setContentType("text/html; charset=utf-8");
        } else {
            response.setStatusCode(302);
            response.getHeaders().put("Location", Arrays.asList(url));
        }
        return response;
    }
}

