/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.request.builtin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.slack.api.bolt.context.builtin.EventContext;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.request.RequestType;
import com.slack.api.util.json.GsonFactory;
import lombok.Generated;

public class EventRequest
extends Request<EventContext> {
    private final String requestBody;
    private final RequestHeaders headers;
    private final String eventType;
    private final String eventSubtype;
    private EventContext context = new EventContext();

    public EventRequest(String requestBody, RequestHeaders headers) {
        this.requestBody = requestBody;
        this.headers = headers;
        JsonObject payload = ((JsonElement)GsonFactory.createSnakeCase().fromJson(requestBody, JsonElement.class)).getAsJsonObject();
        JsonObject event = payload.get("event").getAsJsonObject();
        this.eventType = event.get("type").getAsString();
        this.eventSubtype = event.get("subtype") != null ? event.get("subtype").getAsString() : null;
        this.getContext().setTeamId(payload.get("team_id").getAsString());
        JsonElement enterpriseId = payload.get("enterprise_id");
        if (enterpriseId != null) {
            this.getContext().setEnterpriseId(enterpriseId.getAsString());
        }
        if (event.get("channel") != null && event.get("channel").isJsonPrimitive()) {
            this.getContext().setChannelId(event.get("channel").getAsString());
        } else if (event.get("channel_id") != null) {
            this.getContext().setChannelId(event.get("channel_id").getAsString());
        }
    }

    @Override
    public EventContext getContext() {
        return this.context;
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.Event;
    }

    @Override
    public String getRequestBodyAsString() {
        return this.requestBody;
    }

    @Override
    public RequestHeaders getHeaders() {
        return this.headers;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getEventTypeAndSubtype() {
        if (this.eventSubtype == null) {
            return this.eventType;
        }
        return this.eventType + ":" + this.eventSubtype;
    }

    @Override
    public String getResponseUrl() {
        return null;
    }

    @Override
    @Generated
    public String toString() {
        return "EventRequest(super=" + super.toString() + ", requestBody=" + this.requestBody + ", headers=" + this.getHeaders() + ", eventType=" + this.getEventType() + ", eventSubtype=" + this.eventSubtype + ", context=" + this.getContext() + ")";
    }
}

