/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.service.builtin;

import com.slack.api.bolt.AppConfig;
import com.slack.api.bolt.model.Bot;
import com.slack.api.bolt.model.Installer;
import com.slack.api.bolt.model.builtin.DefaultBot;
import com.slack.api.bolt.model.builtin.DefaultInstaller;
import com.slack.api.bolt.service.InstallationService;
import com.slack.api.bolt.util.JsonOps;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInstallationService
implements InstallationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileInstallationService.class);
    public static final String DEFAULT_ROOT_DIR = System.getProperty("user.home") + File.separator + ".slack-app";
    private final AppConfig config;
    private final String rootDir;
    private boolean historicalDataEnabled;

    public FileInstallationService(AppConfig config) {
        this(config, DEFAULT_ROOT_DIR);
    }

    public FileInstallationService(AppConfig config, String rootDir) {
        this.config = config;
        this.rootDir = rootDir;
    }

    @Override
    public boolean isHistoricalDataEnabled() {
        return this.historicalDataEnabled;
    }

    @Override
    public void setHistoricalDataEnabled(boolean isHistoricalDataEnabled) {
        this.historicalDataEnabled = isHistoricalDataEnabled;
    }

    @Override
    public void saveInstallerAndBot(Installer installer) throws Exception {
        this.save(this.getInstallerPath(installer), installer.getInstalledAt(), JsonOps.toJsonString(installer));
        this.save(this.getBotPath(installer.getEnterpriseId(), installer.getTeamId()), installer.getInstalledAt(), JsonOps.toJsonString(installer.toBot()));
    }

    @Override
    public void deleteBot(Bot bot) throws Exception {
        Files.deleteIfExists(Paths.get(this.getBotPath(bot.getEnterpriseId(), bot.getTeamId()), new String[0]));
    }

    @Override
    public void deleteInstaller(Installer installer) throws Exception {
        Files.deleteIfExists(Paths.get(this.getInstallerPath(installer), new String[0]));
        Files.deleteIfExists(Paths.get(this.getBotPath(installer.getEnterpriseId(), installer.getTeamId()), new String[0]));
    }

    @Override
    public Bot findBot(String enterpriseId, String teamId) {
        try {
            String json = null;
            try {
                json = this.loadFileContent(this.getBotPath(enterpriseId, teamId));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (json == null && enterpriseId != null && (json = this.loadFileContent(this.getBotPath(null, teamId))) != null) {
                Bot bot = JsonOps.fromJson(json, DefaultBot.class);
                bot.setEnterpriseId(enterpriseId);
                this.save(this.getBotPath(enterpriseId, teamId), bot.getInstalledAt(), JsonOps.toJsonString(bot));
                return bot;
            }
            if (json != null) {
                return JsonOps.fromJson(json, DefaultBot.class);
            }
            return null;
        }
        catch (IOException e) {
            log.warn("Failed to load a bot user (enterprise_id: {}, team_id: {})", (Object)enterpriseId, (Object)teamId);
            return null;
        }
    }

    @Override
    public Installer findInstaller(String enterpriseId, String teamId, String userId) {
        try {
            String json = null;
            try {
                json = this.loadFileContent(this.getInstallerPath(enterpriseId, teamId, userId));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (json == null && enterpriseId != null && (json = this.loadFileContent(this.getInstallerPath(null, teamId, userId))) != null) {
                Installer i = JsonOps.fromJson(json, DefaultInstaller.class);
                i.setEnterpriseId(enterpriseId);
                this.save(this.getInstallerPath(enterpriseId, teamId, userId), i.getInstalledAt(), JsonOps.toJsonString(i));
                return i;
            }
            if (json != null) {
                return JsonOps.fromJson(json, DefaultInstaller.class);
            }
            return null;
        }
        catch (IOException e) {
            log.warn("Failed to load an installer user (enterprise_id: {}, team_id: {})", (Object)enterpriseId, (Object)teamId);
            return null;
        }
    }

    private String getInstallerPath(Installer i) throws IOException {
        return this.getInstallerPath(i.getEnterpriseId(), i.getTeamId(), i.getInstallerUserId());
    }

    private String getInstallerPath(String enterpriseId, String teamId, String userId) throws IOException {
        String dir = this.getBaseDir() + File.separator + "installer";
        Path dirPath = Paths.get(dir, new String[0]);
        if (!Files.exists(dirPath, new LinkOption[0])) {
            Files.createDirectories(dirPath, new FileAttribute[0]);
        }
        String key = (enterpriseId == null ? "none" : enterpriseId) + "-" + teamId + "-" + userId;
        if (this.isHistoricalDataEnabled()) {
            key = key + "-latest";
        }
        return dir + File.separator + key;
    }

    private String getBotPath(String enterpriseId, String teamId) throws IOException {
        String dir = this.getBaseDir() + File.separator + "bot";
        Path dirPath = Paths.get(dir, new String[0]);
        if (!Files.exists(dirPath, new LinkOption[0])) {
            Files.createDirectories(dirPath, new FileAttribute[0]);
        }
        String key = (enterpriseId == null ? "none" : enterpriseId) + "-" + teamId;
        if (this.isHistoricalDataEnabled()) {
            key = key + "-latest";
        }
        return dir + File.separator + key;
    }

    private String getBaseDir() {
        return this.rootDir + File.separator + this.config.getClientId() + File.separator + "installation";
    }

    private void save(String path, Long installedAt, String json) throws IOException {
        Files.write(Paths.get(path, new String[0]), json.getBytes(), new OpenOption[0]);
        if (this.isHistoricalDataEnabled()) {
            Files.write(Paths.get(path.replaceFirst("-latest$", "-" + installedAt), new String[0]), json.getBytes(), new OpenOption[0]);
        }
    }

    private String loadFileContent(String filepath) throws IOException {
        String content = Files.readAllLines(Paths.get(filepath, new String[0])).stream().collect(Collectors.joining());
        if (content == null || content.trim().isEmpty() || content.trim().equals("null")) {
            return null;
        }
        return content;
    }
}

