/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.context.builtin;

import com.slack.api.app_backend.views.InputBlockResponseSender;
import com.slack.api.app_backend.views.payload.ViewSubmissionPayload;
import com.slack.api.app_backend.views.response.ViewSubmissionResponse;
import com.slack.api.bolt.context.Context;
import com.slack.api.bolt.context.InputBlockRespondUtility;
import com.slack.api.bolt.response.Responder;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.util.BuilderConfigurator;
import com.slack.api.model.view.View;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class ViewSubmissionContext
extends Context
implements InputBlockRespondUtility {
    private List<ViewSubmissionPayload.ResponseUrl> responseUrls;
    private Responder responder;

    public ViewSubmissionContext() {
    }

    public Response ack(ViewSubmissionResponse response) {
        return Response.json(200, response);
    }

    public Response ack(BuilderConfigurator<ViewSubmissionResponse.ViewSubmissionResponseBuilder> builder) {
        return this.ack(builder.configure(ViewSubmissionResponse.builder()).build());
    }

    public Response ackWithErrors(Map<String, String> errors) {
        ViewSubmissionResponse response = ViewSubmissionResponse.builder().responseAction("errors").errors(errors).build();
        return this.ack(response);
    }

    public Response ackWithUpdate(View view) {
        return this.ack("update", view);
    }

    public Response ackWithUpdate(String view) {
        return this.ack("update", view);
    }

    public Response ackWithPush(View view) {
        return this.ack("push", view);
    }

    public Response ackWithPush(String view) {
        return this.ack("push", view);
    }

    public Response ack(String responseAction, View view) {
        ViewSubmissionResponse response = ViewSubmissionResponse.builder().responseAction(responseAction).view(view).build();
        return this.ack(response);
    }

    public Response ack(String responseAction, String view) {
        ViewSubmissionResponse response = ViewSubmissionResponse.builder().responseAction(responseAction).viewAsString(view).build();
        return this.ack(response);
    }

    @Override
    public InputBlockResponseSender getResponder(String blockId, String actionId) {
        if (this.responseUrls != null) {
            for (ViewSubmissionPayload.ResponseUrl url : this.responseUrls) {
                if (!url.getBlockId().equals(blockId) || !url.getActionId().equals(actionId)) continue;
                return new InputBlockResponseSender(this.getSlack(), url.getResponseUrl());
            }
        }
        throw new IllegalArgumentException("A response_url was not found for block_id: " + blockId + " & action_id: " + actionId);
    }

    @Override
    public InputBlockResponseSender getFirstResponder() {
        List<ViewSubmissionPayload.ResponseUrl> urls = this.getResponseUrls();
        if (urls == null || urls.size() == 0) {
            return null;
        }
        if (urls.size() > 1) {
            String warnMessage = "You have " + urls.size() + " `response_url`s in the payload. Context#getFirstResponder() and #respond(...) work but always use the first URL. Consider using Context#getResponder(blockId, actionId).send(...) instead.";
            this.getLogger().warn(warnMessage);
        }
        return new InputBlockResponseSender(this.getSlack(), urls.get(0).getResponseUrl());
    }

    @Generated
    public static ViewSubmissionContextBuilder builder() {
        return new ViewSubmissionContextBuilder();
    }

    @Override
    @Generated
    public List<ViewSubmissionPayload.ResponseUrl> getResponseUrls() {
        return this.responseUrls;
    }

    @Generated
    public Responder getResponder() {
        return this.responder;
    }

    @Generated
    public void setResponseUrls(List<ViewSubmissionPayload.ResponseUrl> responseUrls) {
        this.responseUrls = responseUrls;
    }

    @Generated
    public void setResponder(Responder responder) {
        this.responder = responder;
    }

    @Generated
    public ViewSubmissionContext(List<ViewSubmissionPayload.ResponseUrl> responseUrls, Responder responder) {
        this.responseUrls = responseUrls;
        this.responder = responder;
    }

    @Override
    @Generated
    public String toString() {
        return "ViewSubmissionContext(super=" + super.toString() + ", responseUrls=" + this.getResponseUrls() + ", responder=" + this.getResponder() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ViewSubmissionContext)) {
            return false;
        }
        ViewSubmissionContext other = (ViewSubmissionContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ViewSubmissionPayload.ResponseUrl> this$responseUrls = this.getResponseUrls();
        List<ViewSubmissionPayload.ResponseUrl> other$responseUrls = other.getResponseUrls();
        if (this$responseUrls == null ? other$responseUrls != null : !((Object)this$responseUrls).equals(other$responseUrls)) {
            return false;
        }
        Responder this$responder = this.getResponder();
        Responder other$responder = other.getResponder();
        return !(this$responder == null ? other$responder != null : !this$responder.equals(other$responder));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ViewSubmissionContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ViewSubmissionPayload.ResponseUrl> $responseUrls = this.getResponseUrls();
        result = result * 59 + ($responseUrls == null ? 43 : ((Object)$responseUrls).hashCode());
        Responder $responder = this.getResponder();
        result = result * 59 + ($responder == null ? 43 : $responder.hashCode());
        return result;
    }

    @Generated
    public static class ViewSubmissionContextBuilder {
        @Generated
        private List<ViewSubmissionPayload.ResponseUrl> responseUrls;
        @Generated
        private Responder responder;

        @Generated
        ViewSubmissionContextBuilder() {
        }

        @Generated
        public ViewSubmissionContextBuilder responseUrls(List<ViewSubmissionPayload.ResponseUrl> responseUrls) {
            this.responseUrls = responseUrls;
            return this;
        }

        @Generated
        public ViewSubmissionContextBuilder responder(Responder responder) {
            this.responder = responder;
            return this;
        }

        @Generated
        public ViewSubmissionContext build() {
            return new ViewSubmissionContext(this.responseUrls, this.responder);
        }

        @Generated
        public String toString() {
            return "ViewSubmissionContext.ViewSubmissionContextBuilder(responseUrls=" + this.responseUrls + ", responder=" + this.responder + ")";
        }
    }
}

