/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.request.builtin;

import com.slack.api.app_backend.slash_commands.SlashCommandPayloadParser;
import com.slack.api.app_backend.slash_commands.payload.SlashCommandPayload;
import com.slack.api.bolt.context.builtin.SlashCommandContext;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.request.RequestType;
import lombok.Generated;

public class SlashCommandRequest
extends Request<SlashCommandContext> {
    private static final SlashCommandPayloadParser PAYLOAD_PARSER = new SlashCommandPayloadParser();
    private final SlashCommandContext context = new SlashCommandContext();
    private final String requestBody;
    private final RequestHeaders headers;
    private final SlashCommandPayload payload;

    public SlashCommandRequest(String requestBody, RequestHeaders headers) {
        this.requestBody = requestBody;
        this.headers = headers;
        this.payload = PAYLOAD_PARSER.parse(requestBody);
        this.getContext().setResponseUrl(this.payload.getResponseUrl());
        this.getContext().setTriggerId(this.payload.getTriggerId());
        this.getContext().setChannelId(this.payload.getChannelId());
        this.getContext().setEnterpriseId(this.payload.getEnterpriseId());
        this.getContext().setTeamId(this.payload.getTeamId());
        this.getContext().setRequestUserId(this.payload.getUserId());
    }

    @Override
    public SlashCommandContext getContext() {
        return this.context;
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.Command;
    }

    @Override
    public String getRequestBodyAsString() {
        return this.requestBody;
    }

    @Override
    public RequestHeaders getHeaders() {
        return this.headers;
    }

    public SlashCommandPayload getPayload() {
        return this.payload;
    }

    @Override
    @Generated
    public String toString() {
        return "SlashCommandRequest(super=" + super.toString() + ", context=" + this.getContext() + ", requestBody=" + this.requestBody + ", headers=" + this.getHeaders() + ", payload=" + this.getPayload() + ")";
    }
}

