/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.context.builtin;

import com.slack.api.app_backend.interactive_components.response.ActionResponse;
import com.slack.api.bolt.context.Context;
import com.slack.api.bolt.response.Responder;
import com.slack.api.bolt.util.BuilderConfigurator;
import com.slack.api.model.block.LayoutBlock;
import com.slack.api.webhook.WebhookResponse;
import java.io.IOException;
import java.util.List;
import lombok.Generated;

public class ActionContext
extends Context {
    private String triggerId;
    private String responseUrl;
    private Responder responder;

    public WebhookResponse respond(String text) throws IOException {
        return this.respond(ActionResponse.builder().text(text).build());
    }

    public WebhookResponse respond(List<LayoutBlock> blocks) throws IOException {
        return this.respond(ActionResponse.builder().blocks(blocks).build());
    }

    public WebhookResponse respond(ActionResponse response) throws IOException {
        if (this.responder == null) {
            this.responder = new Responder(this.slack, this.responseUrl);
        }
        return this.responder.send(response);
    }

    public WebhookResponse respond(BuilderConfigurator<ActionResponse.ActionResponseBuilder> builder) throws IOException {
        return this.respond(builder.configure(ActionResponse.builder()).build());
    }

    @Generated
    public static ActionContextBuilder builder() {
        return new ActionContextBuilder();
    }

    @Generated
    public String getTriggerId() {
        return this.triggerId;
    }

    @Generated
    public String getResponseUrl() {
        return this.responseUrl;
    }

    @Generated
    public Responder getResponder() {
        return this.responder;
    }

    @Generated
    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    @Generated
    public void setResponseUrl(String responseUrl) {
        this.responseUrl = responseUrl;
    }

    @Generated
    public void setResponder(Responder responder) {
        this.responder = responder;
    }

    @Generated
    public ActionContext() {
    }

    @Generated
    public ActionContext(String triggerId, String responseUrl, Responder responder) {
        this.triggerId = triggerId;
        this.responseUrl = responseUrl;
        this.responder = responder;
    }

    @Override
    @Generated
    public String toString() {
        return "ActionContext(super=" + super.toString() + ", triggerId=" + this.getTriggerId() + ", responseUrl=" + this.getResponseUrl() + ", responder=" + this.getResponder() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActionContext)) {
            return false;
        }
        ActionContext other = (ActionContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$triggerId = this.getTriggerId();
        String other$triggerId = other.getTriggerId();
        if (this$triggerId == null ? other$triggerId != null : !this$triggerId.equals(other$triggerId)) {
            return false;
        }
        String this$responseUrl = this.getResponseUrl();
        String other$responseUrl = other.getResponseUrl();
        if (this$responseUrl == null ? other$responseUrl != null : !this$responseUrl.equals(other$responseUrl)) {
            return false;
        }
        Responder this$responder = this.getResponder();
        Responder other$responder = other.getResponder();
        return !(this$responder == null ? other$responder != null : !this$responder.equals(other$responder));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ActionContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $triggerId = this.getTriggerId();
        result = result * 59 + ($triggerId == null ? 43 : $triggerId.hashCode());
        String $responseUrl = this.getResponseUrl();
        result = result * 59 + ($responseUrl == null ? 43 : $responseUrl.hashCode());
        Responder $responder = this.getResponder();
        result = result * 59 + ($responder == null ? 43 : $responder.hashCode());
        return result;
    }

    @Generated
    public static class ActionContextBuilder {
        @Generated
        private String triggerId;
        @Generated
        private String responseUrl;
        @Generated
        private Responder responder;

        @Generated
        ActionContextBuilder() {
        }

        @Generated
        public ActionContextBuilder triggerId(String triggerId) {
            this.triggerId = triggerId;
            return this;
        }

        @Generated
        public ActionContextBuilder responseUrl(String responseUrl) {
            this.responseUrl = responseUrl;
            return this;
        }

        @Generated
        public ActionContextBuilder responder(Responder responder) {
            this.responder = responder;
            return this;
        }

        @Generated
        public ActionContext build() {
            return new ActionContext(this.triggerId, this.responseUrl, this.responder);
        }

        @Generated
        public String toString() {
            return "ActionContext.ActionContextBuilder(triggerId=" + this.triggerId + ", responseUrl=" + this.responseUrl + ", responder=" + this.responder + ")";
        }
    }
}

