/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.context.builtin;

import com.slack.api.app_backend.outgoing_webhooks.response.WebhookResponse;
import com.slack.api.bolt.context.Context;
import com.slack.api.bolt.context.SayUtility;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.util.BuilderConfigurator;

public class OutgoingWebhooksContext
extends Context
implements SayUtility {
    private String triggerId;
    private String channelId;

    public Response ack(String text) {
        return Response.json(200, WebhookResponse.builder().text(text).build());
    }

    public Response ack(WebhookResponse response) {
        return Response.json(200, response);
    }

    public Response ack(BuilderConfigurator<WebhookResponse.WebhookResponseBuilder> builder) {
        return this.ack(builder.configure(WebhookResponse.builder()).build());
    }

    public static OutgoingWebhooksContextBuilder builder() {
        return new OutgoingWebhooksContextBuilder();
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    @Override
    public String getChannelId() {
        return this.channelId;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public OutgoingWebhooksContext() {
    }

    public OutgoingWebhooksContext(String triggerId, String channelId) {
        this.triggerId = triggerId;
        this.channelId = channelId;
    }

    @Override
    public String toString() {
        return "OutgoingWebhooksContext(super=" + super.toString() + ", triggerId=" + this.getTriggerId() + ", channelId=" + this.getChannelId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutgoingWebhooksContext)) {
            return false;
        }
        OutgoingWebhooksContext other = (OutgoingWebhooksContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$triggerId = this.getTriggerId();
        String other$triggerId = other.getTriggerId();
        if (this$triggerId == null ? other$triggerId != null : !this$triggerId.equals(other$triggerId)) {
            return false;
        }
        String this$channelId = this.getChannelId();
        String other$channelId = other.getChannelId();
        return !(this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OutgoingWebhooksContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $triggerId = this.getTriggerId();
        result = result * 59 + ($triggerId == null ? 43 : $triggerId.hashCode());
        String $channelId = this.getChannelId();
        result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
        return result;
    }

    public static class OutgoingWebhooksContextBuilder {
        private String triggerId;
        private String channelId;

        OutgoingWebhooksContextBuilder() {
        }

        public OutgoingWebhooksContextBuilder triggerId(String triggerId) {
            this.triggerId = triggerId;
            return this;
        }

        public OutgoingWebhooksContextBuilder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public OutgoingWebhooksContext build() {
            return new OutgoingWebhooksContext(this.triggerId, this.channelId);
        }

        public String toString() {
            return "OutgoingWebhooksContext.OutgoingWebhooksContextBuilder(triggerId=" + this.triggerId + ", channelId=" + this.channelId + ")";
        }
    }
}

