/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.socket_mode.request;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.slack.api.bolt.AppConfig;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.socket_mode.request.SocketModeRequest;
import com.slack.api.bolt.util.SlackRequestParser;
import com.slack.api.socket_mode.request.SocketModeEnvelope;
import com.slack.api.util.json.GsonFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;

public class SocketModeRequestParser {
    private static final Gson GSON = GsonFactory.createSnakeCase();
    private final SlackRequestParser slackRequestParser;
    private static final List<String> ENVELOPE_TYPES = Arrays.asList("events_api", "interactive", "slash_commands");

    public SocketModeRequestParser(AppConfig appConfig) {
        this.slackRequestParser = new SlackRequestParser(appConfig);
    }

    public SocketModeRequest parse(String message) {
        GenericSocketModeEnvelope envelope = (GenericSocketModeEnvelope)GSON.fromJson(message, GenericSocketModeEnvelope.class);
        if (ENVELOPE_TYPES.contains(envelope.getType())) {
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            if (envelope.getRetryAttempt() != null) {
                headers.put("X-Slack-Retry-Num", Arrays.asList(String.valueOf(envelope.getRetryAttempt())));
            }
            if (envelope.getRetryReason() != null) {
                headers.put("X-Slack-Retry-Reason", Arrays.asList(envelope.getRetryReason()));
            }
            return SocketModeRequest.builder().envelope(envelope).boltRequest(this.slackRequestParser.parse(SlackRequestParser.HttpRequest.builder().socketMode(true).requestUri("").remoteAddress("").queryString(Collections.emptyMap()).requestBody(GSON.toJson(envelope.getPayload())).headers(new RequestHeaders(headers)).build())).build();
        }
        return null;
    }

    public static class GenericSocketModeEnvelope
    implements SocketModeEnvelope {
        private String type;
        private String envelopeId;
        private Boolean acceptsResponsePayload;
        private JsonElement payload;
        private Integer retryAttempt;
        private String retryReason;

        @Generated
        public GenericSocketModeEnvelope() {
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getEnvelopeId() {
            return this.envelopeId;
        }

        @Generated
        public Boolean getAcceptsResponsePayload() {
            return this.acceptsResponsePayload;
        }

        @Generated
        public JsonElement getPayload() {
            return this.payload;
        }

        @Generated
        public Integer getRetryAttempt() {
            return this.retryAttempt;
        }

        @Generated
        public String getRetryReason() {
            return this.retryReason;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setEnvelopeId(String envelopeId) {
            this.envelopeId = envelopeId;
        }

        @Generated
        public void setAcceptsResponsePayload(Boolean acceptsResponsePayload) {
            this.acceptsResponsePayload = acceptsResponsePayload;
        }

        @Generated
        public void setPayload(JsonElement payload) {
            this.payload = payload;
        }

        @Generated
        public void setRetryAttempt(Integer retryAttempt) {
            this.retryAttempt = retryAttempt;
        }

        @Generated
        public void setRetryReason(String retryReason) {
            this.retryReason = retryReason;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GenericSocketModeEnvelope)) {
                return false;
            }
            GenericSocketModeEnvelope other = (GenericSocketModeEnvelope)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$acceptsResponsePayload = this.getAcceptsResponsePayload();
            Boolean other$acceptsResponsePayload = other.getAcceptsResponsePayload();
            if (this$acceptsResponsePayload == null ? other$acceptsResponsePayload != null : !((Object)this$acceptsResponsePayload).equals(other$acceptsResponsePayload)) {
                return false;
            }
            Integer this$retryAttempt = this.getRetryAttempt();
            Integer other$retryAttempt = other.getRetryAttempt();
            if (this$retryAttempt == null ? other$retryAttempt != null : !((Object)this$retryAttempt).equals(other$retryAttempt)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$envelopeId = this.getEnvelopeId();
            String other$envelopeId = other.getEnvelopeId();
            if (this$envelopeId == null ? other$envelopeId != null : !this$envelopeId.equals(other$envelopeId)) {
                return false;
            }
            JsonElement this$payload = this.getPayload();
            JsonElement other$payload = other.getPayload();
            if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
                return false;
            }
            String this$retryReason = this.getRetryReason();
            String other$retryReason = other.getRetryReason();
            return !(this$retryReason == null ? other$retryReason != null : !this$retryReason.equals(other$retryReason));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GenericSocketModeEnvelope;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $acceptsResponsePayload = this.getAcceptsResponsePayload();
            result = result * 59 + ($acceptsResponsePayload == null ? 43 : ((Object)$acceptsResponsePayload).hashCode());
            Integer $retryAttempt = this.getRetryAttempt();
            result = result * 59 + ($retryAttempt == null ? 43 : ((Object)$retryAttempt).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $envelopeId = this.getEnvelopeId();
            result = result * 59 + ($envelopeId == null ? 43 : $envelopeId.hashCode());
            JsonElement $payload = this.getPayload();
            result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
            String $retryReason = this.getRetryReason();
            result = result * 59 + ($retryReason == null ? 43 : $retryReason.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SocketModeRequestParser.GenericSocketModeEnvelope(type=" + this.getType() + ", envelopeId=" + this.getEnvelopeId() + ", acceptsResponsePayload=" + this.getAcceptsResponsePayload() + ", payload=" + this.getPayload() + ", retryAttempt=" + this.getRetryAttempt() + ", retryReason=" + this.getRetryReason() + ")";
        }
    }
}

