/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.socket_mode;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.slack.api.SlackConfig;
import com.slack.api.bolt.App;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.socket_mode.request.SocketModeRequest;
import com.slack.api.bolt.socket_mode.request.SocketModeRequestParser;
import com.slack.api.socket_mode.SocketModeClient;
import com.slack.api.socket_mode.response.AckResponse;
import com.slack.api.socket_mode.response.SocketModeResponse;
import com.slack.api.util.json.GsonFactory;
import java.io.IOException;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketModeApp {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SocketModeApp.class);
    private boolean clientStopped = false;
    private final SocketModeClient client;
    private final App app;

    private static SocketModeClient buildSocketModeClient(App app, String appToken, SocketModeClient.Backend backend) throws IOException {
        SocketModeClient client = app.slack().socketMode(appToken, backend);
        SocketModeRequestParser requestParser = new SocketModeRequestParser(app.config());
        Gson gson = GsonFactory.createSnakeCase((SlackConfig)app.slack().getConfig());
        client.addWebSocketMessageListener(message -> {
            long startMillis = System.currentTimeMillis();
            SocketModeRequest req = requestParser.parse(message);
            if (req != null) {
                try {
                    Response boltResponse = app.run(req.getBoltRequest());
                    if (boltResponse.getStatusCode() != 200) {
                        log.warn("Unsuccessful Bolt app execution (status: {}, body: {})", (Object)boltResponse.getStatusCode(), (Object)boltResponse.getBody());
                        return;
                    }
                    if (boltResponse.getBody() != null) {
                        HashMap<String, Object> response = new HashMap<String, Object>();
                        if (boltResponse.getContentType().startsWith("application/json")) {
                            response.put("envelope_id", req.getEnvelope().getEnvelopeId());
                            response.put("payload", gson.fromJson(boltResponse.getBody(), JsonElement.class));
                        } else {
                            response.put("envelope_id", req.getEnvelope().getEnvelopeId());
                            HashMap<String, String> payload = new HashMap<String, String>();
                            payload.put("text", boltResponse.getBody());
                            response.put("payload", payload);
                        }
                        client.sendSocketModeResponse(gson.toJson(response));
                    } else {
                        client.sendSocketModeResponse((SocketModeResponse)new AckResponse(req.getEnvelope().getEnvelopeId()));
                    }
                    long spentMillis = System.currentTimeMillis() - startMillis;
                    log.debug("Response time: {} milliseconds", (Object)spentMillis);
                    return;
                }
                catch (Exception e) {
                    log.error("Failed to handle a request: {}", (Object)e.getMessage(), (Object)e);
                    return;
                }
            }
        });
        return client;
    }

    public SocketModeApp(App app) throws IOException {
        this(System.getenv("SLACK_APP_TOKEN"), SocketModeClient.Backend.Tyrus, app);
    }

    public SocketModeApp(String appToken, App app) throws IOException {
        this(appToken, SocketModeClient.Backend.Tyrus, app);
    }

    public SocketModeApp(String appToken, SocketModeClient.Backend backend, App app) throws IOException {
        this(SocketModeApp.buildSocketModeClient(app, appToken, backend), app);
    }

    public SocketModeApp(SocketModeClient socketModeClient, App app) {
        this.client = socketModeClient;
        this.app = app;
    }

    public void start() throws Exception {
        this.run(true);
    }

    public void startAsync() throws Exception {
        this.run(false);
    }

    public void run(boolean blockCurrentThread) throws Exception {
        this.app.start();
        if (this.clientStopped) {
            this.client.connectToNewEndpoint();
        } else {
            this.client.connect();
        }
        this.client.setAutoReconnectEnabled(true);
        if (blockCurrentThread) {
            Thread.sleep(Long.MAX_VALUE);
        }
    }

    public void stop() throws Exception {
        this.client.disconnect();
        this.clientStopped = true;
        this.app.stop();
    }
}

