/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.google_cloud_functions;

import com.google.cloud.functions.HttpFunction;
import com.google.cloud.functions.HttpRequest;
import com.google.cloud.functions.HttpResponse;
import com.slack.api.bolt.App;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.util.SlackRequestParser;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SlackApiFunction
implements HttpFunction {
    private final App app;
    private final SlackRequestParser requestParser;

    public SlackApiFunction(App app) {
        this.app = app;
        this.requestParser = new SlackRequestParser(this.app.config());
    }

    public void service(HttpRequest httpRequest, HttpResponse httpResponse) throws Exception {
        Request boltRequest = this.toBoltRequest(httpRequest);
        Response boltResponse = this.app.run(boltRequest);
        this.writeResponse(boltResponse, httpResponse);
    }

    private Request toBoltRequest(HttpRequest httpRequest) throws IOException {
        String body = httpRequest.getReader().lines().collect(Collectors.joining());
        SlackRequestParser.HttpRequest req = SlackRequestParser.HttpRequest.builder().requestUri(httpRequest.getPath()).queryString(httpRequest.getQueryParameters()).requestBody(body).headers(new RequestHeaders(httpRequest.getHeaders())).remoteAddress((String)httpRequest.getFirstHeader("X-Forwarded-For").orElse(null)).build();
        return this.requestParser.parse(req);
    }

    private void writeResponse(Response boltResponse, HttpResponse httpResponse) throws IOException {
        httpResponse.setStatusCode(boltResponse.getStatusCode().intValue());
        httpResponse.setContentType(boltResponse.getContentType());
        for (Map.Entry nameAndValues : boltResponse.getHeaders().entrySet()) {
            String headerName = (String)nameAndValues.getKey();
            for (String value : (List)nameAndValues.getValue()) {
                httpResponse.appendHeader(headerName, value);
            }
        }
        httpResponse.getWriter().write(boltResponse.getBody());
    }
}

