/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.code128;

import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.impl.DefaultCanvasLogicHandler;
import org.krysalis.barcode4j.impl.code128.Code128Bean;
import org.krysalis.barcode4j.impl.code128.EAN128LogicImpl;
import org.krysalis.barcode4j.output.Canvas;
import org.krysalis.barcode4j.output.CanvasProvider;

public class EAN128Bean
extends Code128Bean {
    public static final char DEFAULT_GROUP_SEPARATOR = '\u001d';
    public static final char DEFAULT_CHECK_DIGIT_MARKER = '\u00f0';
    private EAN128LogicImpl impl;
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private String template = null;
    private char groupSeparator = (char)29;
    private char checkDigitMarker = (char)240;
    private boolean omitBrackets = false;

    public EAN128Bean() {
        this.impl = new EAN128LogicImpl(this.checksumMode, this.template, this.groupSeparator);
    }

    @Override
    public BarcodeDimension calcDimensions(String msg) {
        int msgLen = this.impl.getEncodedMessage(msg).length + 1;
        double width = (double)(msgLen * 11 + 13) * this.getModuleWidth();
        double qz = this.hasQuietZone() ? this.quietZone : 0.0;
        return new BarcodeDimension(width, this.getHeight(), width + 2.0 * qz, this.getHeight(), this.quietZone, 0.0);
    }

    @Override
    public void generateBarcode(CanvasProvider canvas, String msg) {
        if (msg == null || msg.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        DefaultCanvasLogicHandler handler = new DefaultCanvasLogicHandler(this, new Canvas(canvas));
        this.impl.generateBarcodeLogic(handler, msg);
    }

    public void setChecksumMode(ChecksumMode mode) {
        this.checksumMode = mode;
        this.impl.setChecksumMode(mode);
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public char getGroupSeparator() {
        return this.groupSeparator;
    }

    public void setGroupSeparator(char c) {
        this.groupSeparator = c;
        this.impl.setGroupSeparator(c);
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String string) {
        this.template = string;
        this.impl.setTemplate(string);
    }

    public char getCheckDigitMarker() {
        return this.checkDigitMarker;
    }

    public void setCheckDigitMarker(char c) {
        this.checkDigitMarker = c;
        this.impl.setCheckDigitMarker(c);
    }

    public boolean isOmitBrackets() {
        return this.omitBrackets;
    }

    public void setOmitBrackets(boolean b) {
        this.omitBrackets = b;
        this.impl.setOmitBrackets(b);
    }
}

