/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication.vad;

import android.media.AudioRecord;
import android.os.Process;
import android.util.Log;
import com.konovalov.vad.Vad;
import com.konovalov.vad.VadConfig;
import com.konovalov.vad.VadListener;

public class VoiceRecorder {
    private static final int PCM_CHANNEL = 16;
    private static final int PCM_ENCODING_BIT = 2;
    private Vad vad;
    private AudioRecord audioRecord;
    private Listener callback;
    private Thread thread;
    private boolean isListening = false;
    private static final String TAG = VoiceRecorder.class.getSimpleName();

    public VoiceRecorder(Listener callback, VadConfig config) {
        this.callback = callback;
        this.vad = new Vad(config);
    }

    public void updateConfig(VadConfig config) {
        this.vad.setConfig(config);
    }

    public void start() {
        this.stop();
        this.audioRecord = this.createAudioRecord();
        if (this.audioRecord != null) {
            this.isListening = true;
            this.audioRecord.startRecording();
            this.thread = new Thread(new ProcessVoice());
            this.thread.start();
            this.vad.start();
        } else {
            Log.w((String)TAG, (String)"Failed start Voice Recorder!");
        }
    }

    public void stop() {
        this.isListening = false;
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        if (this.audioRecord != null) {
            try {
                this.audioRecord.release();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Error stop AudioRecord ", (Throwable)e);
            }
            this.audioRecord = null;
        }
        if (this.vad != null) {
            this.vad.stop();
        }
    }

    private AudioRecord createAudioRecord() {
        try {
            int minBufSize = AudioRecord.getMinBufferSize((int)this.vad.getConfig().getSampleRate().getValue(), (int)16, (int)2);
            if (minBufSize == -2) {
                return null;
            }
            AudioRecord audioRecord = new AudioRecord(1, this.vad.getConfig().getSampleRate().getValue(), 16, 2, minBufSize);
            if (audioRecord.getState() == 1) {
                return audioRecord;
            }
            audioRecord.release();
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)"Error can't create AudioRecord ", (Throwable)e);
        }
        return null;
    }

    private int getNumberOfChannels() {
        switch (16) {
            case 16: {
                return 1;
            }
            case 12: {
                return 2;
            }
        }
        return 1;
    }

    public static interface Listener {
        public void onSpeechDetected();

        public void onNoiseDetected();
    }

    private class ProcessVoice
    implements Runnable {
        private ProcessVoice() {
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-16);
            while (!Thread.interrupted() && VoiceRecorder.this.isListening && VoiceRecorder.this.audioRecord != null) {
                short[] buffer = new short[VoiceRecorder.this.vad.getConfig().getFrameSize().getValue() * VoiceRecorder.this.getNumberOfChannels() * 2];
                VoiceRecorder.this.audioRecord.read(buffer, 0, buffer.length);
                this.isSpeechDetected(buffer);
            }
        }

        private void isSpeechDetected(short[] buffer) {
            VoiceRecorder.this.vad.isContinuousSpeech(buffer, new VadListener(){

                public void onSpeechDetected() {
                    VoiceRecorder.this.callback.onSpeechDetected();
                }

                public void onNoiseDetected() {
                    VoiceRecorder.this.callback.onNoiseDetected();
                }
            });
        }
    }
}

