/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

public abstract class PaginationScrollListener
extends RecyclerView.OnScrollListener {
    LinearLayoutManager layoutManager;

    public PaginationScrollListener(LinearLayoutManager layoutManager) {
        this.layoutManager = layoutManager;
    }

    public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
        super.onScrolled(recyclerView, dx, dy);
        int visibleItemCount = this.layoutManager.getChildCount();
        int totalItemCount = this.layoutManager.getItemCount();
        int lastVisibleItemPosition = this.layoutManager.findLastVisibleItemPosition();
        int firstVisibleItemPosition = this.layoutManager.findFirstVisibleItemPosition();
        if (!this.isLoading() && !this.isLastPage() && visibleItemCount - lastVisibleItemPosition <= totalItemCount && firstVisibleItemPosition == 0) {
            this.loadMoreItems();
        }
    }

    protected abstract void loadMoreItems();

    public abstract long getTotalPageCount();

    public abstract boolean isLastPage();

    public abstract boolean isLoading();
}

