/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.siggytech.utils.communication.MessengerHelper;
import com.siggytech.utils.communication.Utils;

public class MessengerReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        if (intent.hasExtra("messageChat")) {
            if (MessengerHelper.getChatListView() != null) {
                MessengerHelper.getChatListView().onMessageReceiver(intent.getStringExtra("messageChat"));
            } else {
                Utils.traces("MessengerReceiver onReceive HAS MESSAGE_CHAT BUT MessengerHelper.getChatListView() IS NULL");
            }
        } else if (intent.hasExtra("messagePtt")) {
            try {
                if (MessengerHelper.getPttButton() != null) {
                    MessengerHelper.getPttButton().PlayShortAudioFileViaAudioTrack(intent.getByteArrayExtra("messagePtt"));
                } else {
                    Utils.traces("MessengerReceiver onReceive HAS MESSAGE_PTT BUT MessengerHelper.getPttButton IS NULL");
                }
            }
            catch (Exception e) {
                Utils.traces("MessengerReceiver onReceive. " + Utils.exceptionToString(e));
            }
        }
    }
}

