package com.siggytech.utils.communication;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;


public class NotificationAgent {

    public void register(Context context, int idGroup, String API_KEY, String nameClient, String iconName){

        Intent intent = new Intent(context, NotificationService.class);

        intent.putExtra("imei", Utils.getImei(context));
        intent.putExtra("clientname", nameClient);
        intent.putExtra("groupid", idGroup);
        intent.putExtra("api_key", API_KEY);
        intent.putExtra("iconName", iconName);

        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(context);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString("imei", Utils.getImei(context));
        editor.putString("clientname", nameClient);
        editor.putString("groupid", String.valueOf(idGroup));
        editor.putString("api_key", API_KEY);
        editor.putString("iconName", iconName);
        editor.commit();

        Utils.writeToFile(Utils.getImei(context) + ";" + nameClient + ";" +
                               API_KEY + ";" + idGroup + ";" + iconName, context);


        context.startService(intent);
    }


}
